/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth.conf;

import dev.dsf.common.auth.DsfOpenIdCredentials;
import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.IdentityProvider;
import dev.dsf.common.auth.conf.PractitionerIdentityImpl;
import dev.dsf.common.auth.conf.RoleConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractIdentityProvider
implements IdentityProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractIdentityProvider.class);
    private static final String PRACTITIONER_IDENTIFIER_SYSTEM = "http://dsf.dev/sid/practitioner-identifier";
    private final RoleConfig roleConfig;
    private final Set<String> thumbprints;

    public AbstractIdentityProvider(RoleConfig roleConfig) {
        this.roleConfig = roleConfig;
        this.thumbprints = roleConfig.getEntries().stream().map(RoleConfig.Mapping::getThumbprints).flatMap(Collection::stream).distinct().collect(Collectors.toUnmodifiableSet());
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.roleConfig, "roleConfig");
    }

    @Override
    public final Identity getIdentity(DsfOpenIdCredentials credentials) {
        if (credentials == null) {
            return null;
        }
        Optional<Practitioner> practitioner = this.toPractitioner(credentials);
        Optional<Organization> localOrganization = this.getLocalOrganization();
        if (practitioner.isPresent() && localOrganization.isPresent()) {
            Map<String, Object> parsedIdToken = credentials.getIdToken();
            Map<String, Object> parsedAccessToken = credentials.getAccessToken();
            List<String> rolesFromTokens = this.getRolesFromTokens(parsedIdToken, parsedAccessToken);
            List<String> groupsFromTokens = this.getGroupsFromTokens(parsedIdToken, parsedAccessToken);
            Set<DsfRole> dsfRoles = this.getDsfRolesFor(practitioner.get(), null, rolesFromTokens, groupsFromTokens);
            Set<Coding> practitionerRoles = this.getPractitionerRolesFor(practitioner.get(), null, rolesFromTokens, groupsFromTokens);
            if (dsfRoles.isEmpty()) {
                logger.warn("User from OpenID Connect token '{}' not configured as local user", (Object)credentials.getUserId());
                return null;
            }
            return new PractitionerIdentityImpl(localOrganization.get(), dsfRoles, null, practitioner.get(), practitionerRoles, credentials);
        }
        logger.warn("User from OpenID Connect token '{}' not configured as local user or local organization unknown", (Object)credentials.getUserId());
        return null;
    }

    protected abstract Optional<Organization> getLocalOrganization();

    protected final String getThumbprint(X509Certificate certificate) {
        try {
            byte[] digest = MessageDigest.getInstance("SHA-512").digest(certificate.getEncoded());
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected final String getDn(X509Certificate certificate) {
        return certificate.getSubjectX500Principal().getName("RFC1779");
    }

    protected final List<String> getGroupsFromTokens(Map<String, Object> parsedIdToken, Map<String, Object> parsedAccessToken) {
        if (logger.isDebugEnabled()) {
            logger.debug("id_token: groups: {}", this.getPropertyArray(parsedIdToken, "groups"));
            logger.debug("access_token: groups: {}", this.getPropertyArray(parsedAccessToken, "groups"));
        }
        return Stream.concat(this.getPropertyArray(parsedIdToken, "groups").stream(), this.getPropertyArray(parsedAccessToken, "groups").stream()).toList();
    }

    protected final List<String> getRolesFromTokens(Map<String, Object> idToken, Map<String, Object> accessToken) {
        return Stream.concat(this.getRolesFromToken("id_token", idToken), this.getRolesFromToken("access_token", accessToken)).toList();
    }

    private Stream<String> getRolesFromToken(String tokenName, Map<String, Object> token) {
        if (logger.isDebugEnabled()) {
            logger.debug("{}: realm_access.roles: {}", (Object)tokenName, this.getPropertyArray(this.getPropertyMap(token, "realm_access"), "roles"));
            logger.debug("{}: resource_access.*.roles: {}", (Object)tokenName, this.getPropertyMap(token, "resource_access").entrySet().stream().flatMap(e -> this.getPropertyArray((Map)e.getValue(), "roles").stream().map(r -> (String)e.getKey() + "." + r)).toList());
        }
        return Stream.concat(this.getPropertyArray(this.getPropertyMap(token, "realm_access"), "roles").stream(), this.getPropertyMap(token, "resource_access").entrySet().stream().flatMap(e -> this.getPropertyArray((Map)e.getValue(), "roles").stream().map(r -> (String)e.getKey() + "." + r)));
    }

    private Map<String, Object> getPropertyMap(Map<String, Object> map, String property) {
        Object propertyValue = map.get(property);
        if (propertyValue != null && propertyValue instanceof Map) {
            Map m = (Map)propertyValue;
            return m;
        }
        return Collections.emptyMap();
    }

    private List<String> getPropertyArray(Map<String, Object> map, String property) {
        Object propertyValue = map.get(property);
        if (propertyValue != null && propertyValue instanceof Object[]) {
            Object[] o = (Object[])propertyValue;
            return Arrays.stream(o).filter(v -> v instanceof String).map(v -> (String)v).toList();
        }
        return Collections.emptyList();
    }

    protected final Set<DsfRole> getDsfRolesFor(Practitioner practitioner, String thumbprint, List<String> tokenRoles, List<String> tokenGroups) {
        List<String> emailAddresses = practitioner.getIdentifier().stream().filter(i -> PRACTITIONER_IDENTIFIER_SYSTEM.equals(i.getSystem()) && i.hasValue()).map(Identifier::getValue).toList();
        Stream r1 = emailAddresses.stream().map(this.roleConfig::getDsfRolesForEmail).flatMap(Collection::stream);
        Stream r2 = thumbprint == null ? Stream.empty() : this.roleConfig.getDsfRolesForThumbprint(thumbprint).stream();
        Stream r3 = tokenRoles == null ? Stream.empty() : tokenRoles.stream().map(this.roleConfig::getDsfRolesForTokenRole).flatMap(Collection::stream);
        Stream r4 = tokenGroups == null ? Stream.empty() : tokenGroups.stream().map(this.roleConfig::getDsfRolesForTokenGroup).flatMap(Collection::stream);
        return Stream.of(r1, r2, r3, r4).flatMap(Function.identity()).distinct().collect(Collectors.toSet());
    }

    protected final Set<Coding> getPractitionerRolesFor(Practitioner practitioner, String thumbprint, List<String> tokenRoles, List<String> tokenGroups) {
        List<String> emailAddresses = practitioner.getIdentifier().stream().filter(i -> PRACTITIONER_IDENTIFIER_SYSTEM.equals(i.getSystem()) && i.hasValue()).map(Identifier::getValue).toList();
        Stream r1 = emailAddresses.stream().map(this.roleConfig::getPractitionerRolesForEmail).flatMap(Collection::stream);
        Stream r2 = thumbprint == null ? Stream.empty() : this.roleConfig.getPractitionerRolesForThumbprint(thumbprint).stream();
        Stream r3 = tokenRoles == null ? Stream.empty() : tokenRoles.stream().map(this.roleConfig::getPractitionerRolesForTokenRole).flatMap(Collection::stream);
        Stream r4 = tokenGroups == null ? Stream.empty() : tokenGroups.stream().map(this.roleConfig::getPractitionerRolesForTokenGroup).flatMap(Collection::stream);
        return Stream.of(r1, r2, r3, r4).flatMap(Function.identity()).distinct().collect(Collectors.toSet());
    }

    protected final Optional<Practitioner> toPractitioner(DsfOpenIdCredentials credentials) {
        if (credentials == null) {
            return Optional.empty();
        }
        String iss = credentials.getStringClaimOrDefault("iss", "");
        String sub = credentials.getStringClaimOrDefault("sub", "");
        Set emails = Stream.of(credentials.getStringClaimOrDefault("email", ""), this.toEmail(iss, sub)).filter(m -> m != null).distinct().collect(Collectors.toSet());
        Stream<String> surname = Stream.of(credentials.getStringClaimOrDefault("family_name", ""));
        Stream<String> givenNames = Stream.of(credentials.getStringClaimOrDefault("given_name", ""));
        return this.toPractitioner(surname, givenNames, emails.stream());
    }

    private Optional<Practitioner> toPractitioner(Stream<String> surname, Stream<String> givenNames, Stream<String> emails) {
        Practitioner practitioner = new Practitioner();
        emails.filter(e -> e != null).filter(e -> e.contains("@")).map(e -> new Identifier().setSystem(PRACTITIONER_IDENTIFIER_SYSTEM).setValue(e)).forEach(arg_0 -> ((Practitioner)practitioner).addIdentifier(arg_0));
        HumanName name = new HumanName();
        name.setFamily(surname.collect(Collectors.joining(" ")));
        givenNames.forEach(arg_0 -> ((HumanName)name).addGiven(arg_0));
        practitioner.addName(name);
        return Optional.of(practitioner);
    }

    private String toEmail(String iss, String sub) {
        if (iss == null || sub == null || iss.isBlank() || sub.isBlank()) {
            return null;
        }
        try {
            return sub + "@" + new URL(iss).getHost();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected final Optional<Practitioner> toPractitioner(X509Certificate certificate) {
        if (certificate == null) {
            return Optional.empty();
        }
        String thumbprint = this.getThumbprint(certificate);
        if (!this.thumbprints.contains(thumbprint)) {
            return Optional.empty();
        }
        return this.toJcaX509CertificateHolder(certificate).flatMap(this::toPractitioner);
    }

    private Optional<JcaX509CertificateHolder> toJcaX509CertificateHolder(X509Certificate certificate) {
        try {
            return Optional.of(new JcaX509CertificateHolder(certificate));
        }
        catch (CertificateEncodingException e) {
            logger.debug("Unable to decode certificate", (Throwable)e);
            logger.warn("Unable to decode certificate: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private Optional<Practitioner> toPractitioner(JcaX509CertificateHolder certificate) {
        X500Name subject = certificate.getSubject();
        List<String> givennames = this.getValues(subject, BCStyle.GIVENNAME);
        List<String> surnames = this.getValues(subject, BCStyle.SURNAME);
        List<String> commonName = this.getValues(subject, BCStyle.CN);
        List<String> email1 = this.getValues(subject, BCStyle.E);
        List<String> email2 = this.getValues(subject, BCStyle.EmailAddress);
        Extension subjectAlternativeNames = certificate.getExtension(Extension.subjectAlternativeName);
        List rfc822Names = subjectAlternativeNames == null ? Collections.emptyList() : Stream.of(GeneralNames.getInstance((Object)subjectAlternativeNames.getParsedValue()).getNames()).filter(n -> n.getTagNo() == 1).map(GeneralName::getName).map(IETFUtils::valueToString).toList();
        Stream<String> emails = Stream.concat(Stream.concat(email1.stream(), email2.stream()), rfc822Names.stream());
        return this.toPractitioner(!surnames.isEmpty() ? surnames.stream() : commonName.stream(), givennames.stream(), emails);
    }

    private List<String> getValues(X500Name name, ASN1ObjectIdentifier attribute) {
        return Stream.of(name.getRDNs(attribute)).flatMap(rdn -> Stream.of(rdn.getTypesAndValues())).map(AttributeTypeAndValue::getValue).map(IETFUtils::valueToString).toList();
    }
}

