/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth.conf;

import dev.dsf.common.auth.conf.DsfRole;
import dev.dsf.common.auth.conf.Identity;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;

public abstract class AbstractIdentity
implements Identity {
    private final boolean localIdentity;
    private final Organization organization;
    private final Set<DsfRole> dsfRoles = new HashSet<DsfRole>();
    private final X509Certificate certificate;

    public AbstractIdentity(boolean localIdentity, Organization organization, Collection<? extends DsfRole> dsfRoles, X509Certificate certificate) {
        this.localIdentity = localIdentity;
        this.organization = Objects.requireNonNull(organization, "organization");
        if (dsfRoles != null) {
            this.dsfRoles.addAll(dsfRoles);
        }
        this.certificate = certificate;
    }

    @Override
    public boolean isLocalIdentity() {
        return this.localIdentity;
    }

    @Override
    public Organization getOrganization() {
        return this.organization;
    }

    @Override
    public Optional<String> getOrganizationIdentifierValue() {
        return this.getIdentifierValue(() -> ((Organization)this.organization).getIdentifier(), "http://dsf.dev/sid/organization-identifier");
    }

    protected Optional<String> getIdentifierValue(Supplier<List<Identifier>> identifiers, String identifierSystem) {
        Objects.requireNonNull(identifiers, "identifiers");
        Objects.requireNonNull(identifierSystem, "identifierSystem");
        List<Identifier> ids = identifiers.get();
        if (ids == null) {
            return Optional.empty();
        }
        return ids.stream().filter(i -> i != null).filter(i -> identifierSystem.equals(i.getSystem())).filter(Identifier::hasValue).findFirst().map(Identifier::getValue);
    }

    @Override
    public Set<DsfRole> getDsfRoles() {
        return Collections.unmodifiableSet(this.dsfRoles);
    }

    @Override
    public boolean hasDsfRole(DsfRole dsfRole) {
        return this.dsfRoles.contains(dsfRole);
    }

    @Override
    public Optional<X509Certificate> getCertificate() {
        return Optional.ofNullable(this.certificate);
    }
}

