/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.common.auth.conf;

import dev.dsf.common.auth.conf.DsfRole;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Coding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoleConfig {
    private static final Logger logger = LoggerFactory.getLogger(RoleConfig.class);
    private static final String PROPERTY_THUMBPRINT = "thumbprint";
    private static final String PROPERTY_EMAIL = "email";
    private static final String PROPERTY_TOKEN_ROLE = "token-role";
    private static final String PROPERTY_TOKEN_GROUP = "token-group";
    private static final String PROPERTY_DSF_ROLE = "dsf-role";
    private static final String PROPERTY_PRACTITIONER_ROLE = "practitioner-role";
    private static final List<String> PROPERTIES = Arrays.asList("thumbprint", "email", "token-role", "token-group", "dsf-role", "practitioner-role");
    private static final String THUMBPRINT_PATTERN_STRING = "^[a-f0-9]{128}$";
    private static final Pattern THUMBPRINT_PATTERN = Pattern.compile("^[a-f0-9]{128}$");
    private static final String EMAIL_PATTERN_STRING = "^[\\w!#$%&'*+/=?`{\\|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{\\|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$";
    private static final Pattern EMAIL_PATTERN = Pattern.compile("^[\\w!#$%&'*+/=?`{\\|}~^-]+(?:\\.[\\w!#$%&'*+/=?`{\\|}~^-]+)*@(?:[a-zA-Z0-9-]+\\.)+[a-zA-Z]{2,6}$");
    private final List<Mapping> entries = new ArrayList<Mapping>();

    public RoleConfig(Object config, Function<String, DsfRole> dsfRoleFactory, Function<String, Coding> practitionerRoleFactory) {
        if (config != null && config instanceof List) {
            List cList = (List)config;
            cList.forEach(mapping -> {
                if (mapping != null && mapping instanceof Map) {
                    Map m = (Map)mapping;
                    m.forEach((mappingKey, mappingValues) -> {
                        if (mappingKey != null && mappingKey instanceof String && mappingValues != null && mappingValues instanceof Map) {
                            Map properties = (Map)mappingValues;
                            List<String> thumbprints = null;
                            List<String> emails = null;
                            List<String> tokenRoles = null;
                            List<String> tokenGroups = null;
                            List<DsfRole> dsfRoles = null;
                            List<Coding> practitionerRoles = null;
                            block16: for (Map.Entry p : properties.entrySet()) {
                                if (p.getKey() == null || !(p.getKey() instanceof String)) continue;
                                switch ((String)p.getKey()) {
                                    case "thumbprint": {
                                        thumbprints = RoleConfig.getValues(p.getValue()).stream().map(value -> {
                                            if (value == null || value.isBlank()) {
                                                logger.warn("Ignoring empty of blank thumbprint in rule '{}'", mappingKey);
                                                return null;
                                            }
                                            if (!THUMBPRINT_PATTERN.matcher(value.trim()).matches()) {
                                                logger.warn("Malformed thumbprint: '{}' not matching {}, ignoring value in rule '{}'", new Object[]{value, THUMBPRINT_PATTERN_STRING, mappingKey});
                                                return null;
                                            }
                                            return value.trim();
                                        }).filter(g -> g != null).toList();
                                        continue block16;
                                    }
                                    case "email": {
                                        emails = RoleConfig.getValues(p.getValue()).stream().map(value -> {
                                            if (value == null || value.isBlank()) {
                                                logger.warn("Ignoring empty of blank email in rule '{}'", mappingKey);
                                                return null;
                                            }
                                            if (!EMAIL_PATTERN.matcher(value.trim()).matches()) {
                                                logger.warn("Malformed email: '{}' not matching {}, ignoring value in rule '{}'", new Object[]{value, EMAIL_PATTERN_STRING, mappingKey});
                                                return null;
                                            }
                                            return value.trim();
                                        }).filter(g -> g != null).toList();
                                        continue block16;
                                    }
                                    case "token-role": {
                                        tokenRoles = RoleConfig.getValues(p.getValue()).stream().map(value -> {
                                            if (value == null || value.isBlank()) {
                                                logger.warn("Ignoring empty of blank token-role in rule '{}'", mappingKey);
                                                return null;
                                            }
                                            return value.trim();
                                        }).filter(g -> g != null).toList();
                                        continue block16;
                                    }
                                    case "token-group": {
                                        tokenGroups = RoleConfig.getValues(p.getValue()).stream().map(value -> {
                                            if (value == null || value.isBlank()) {
                                                logger.warn("Ignoring empty of blank token-group in rule '{}'", mappingKey);
                                                return null;
                                            }
                                            return value.trim();
                                        }).filter(g -> g != null).toList();
                                        continue block16;
                                    }
                                    case "dsf-role": {
                                        dsfRoles = RoleConfig.getValues(p.getValue()).stream().map(value -> {
                                            if (value == null || value.isBlank()) {
                                                logger.warn("Ignoring empty of blank dsf-role in rule '{}'", mappingKey);
                                                return null;
                                            }
                                            DsfRole dsfRole = (DsfRole)dsfRoleFactory.apply(value.trim());
                                            if (dsfRole == null) {
                                                logger.warn("Unknown dsf-role '{}', ignoring value in rule '{}'", value, mappingKey);
                                            }
                                            return dsfRole;
                                        }).filter(r -> r != null).toList();
                                        continue block16;
                                    }
                                    case "practitioner-role": {
                                        practitionerRoles = RoleConfig.getValues(p.getValue()).stream().map(value -> {
                                            if (value == null || value.isBlank()) {
                                                logger.warn("Ignoring empty of blank practitioner-role in rule '{}'", mappingKey);
                                                return null;
                                            }
                                            Coding coding = (Coding)practitionerRoleFactory.apply(value.trim());
                                            if (coding == null) {
                                                logger.warn("Unknown practitioner-role '{}', ignoring value in rule '{}'", value, mappingKey);
                                            }
                                            return coding;
                                        }).filter(r -> r != null).toList();
                                        continue block16;
                                    }
                                }
                                logger.warn("Unknown role config property '{}' expected one of {}, ignoring property in rule '{}'", new Object[]{p.getKey(), PROPERTIES, mappingKey});
                            }
                            this.entries.add(new Mapping((String)mappingKey, thumbprints, emails, tokenRoles, tokenGroups, dsfRoles, practitionerRoles));
                        } else if (mappingKey != null && mappingKey instanceof String && (mappingValues == null || !(mappingValues instanceof Map))) {
                            logger.warn("Ignoring invalud rule '{}'", mappingKey);
                        } else {
                            logger.warn("Ignoring invalud rule '{}'", mappingKey);
                        }
                    });
                } else {
                    logger.warn("Ignoring invalud rule '{}'", mapping);
                }
            });
        }
    }

    private static List<String> getValues(Object o) {
        if (o instanceof String) {
            return Collections.singletonList((String)o);
        }
        if (o instanceof List) {
            return (List)o;
        }
        return Collections.emptyList();
    }

    public List<Mapping> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public List<DsfRole> getDsfRolesForThumbprint(String thumbprint) {
        return this.getDsfRoleFor(Mapping::getThumbprints, thumbprint);
    }

    public List<DsfRole> getDsfRolesForEmail(String email) {
        return this.getDsfRoleFor(Mapping::getEmails, email);
    }

    public List<DsfRole> getDsfRolesForTokenRole(String tokenRole) {
        return this.getDsfRoleFor(Mapping::getTokenRoles, tokenRole);
    }

    public List<DsfRole> getDsfRolesForTokenGroup(String tokenGroup) {
        return this.getDsfRoleFor(Mapping::getTokenGroups, tokenGroup);
    }

    private List<DsfRole> getDsfRoleFor(Function<Mapping, List<String>> values, String value) {
        return this.getEntries().stream().filter(m -> ((List)values.apply((Mapping)m)).contains(value)).flatMap(m -> m.getDsfRoles().stream()).toList();
    }

    public List<Coding> getPractitionerRolesForThumbprint(String thumbprint) {
        return this.getPractitionerRoleFor(Mapping::getThumbprints, thumbprint);
    }

    public List<Coding> getPractitionerRolesForEmail(String email) {
        return this.getPractitionerRoleFor(Mapping::getEmails, email);
    }

    public List<Coding> getPractitionerRolesForTokenRole(String tokenRole) {
        return this.getPractitionerRoleFor(Mapping::getTokenRoles, tokenRole);
    }

    public List<Coding> getPractitionerRolesForTokenGroup(String tokenGroup) {
        return this.getPractitionerRoleFor(Mapping::getTokenGroups, tokenGroup);
    }

    private List<Coding> getPractitionerRoleFor(Function<Mapping, List<String>> values, String value) {
        return this.getEntries().stream().filter(m -> ((List)values.apply((Mapping)m)).contains(value)).flatMap(m -> m.getPractitionerRoles().stream()).toList();
    }

    public String toString() {
        return this.getEntries().stream().map(Mapping::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    public class Mapping {
        private final String name;
        private final List<String> thumbprints = new ArrayList<String>();
        private final List<String> emails = new ArrayList<String>();
        private final List<String> tokenRoles = new ArrayList<String>();
        private final List<String> tokenGroups = new ArrayList<String>();
        private final List<DsfRole> dsfRoles = new ArrayList<DsfRole>();
        private final List<Coding> practitionerRoles = new ArrayList<Coding>();

        private Mapping(String name, List<String> thumbprints, List<String> emails, List<String> tokenRoles, List<String> tokenGroups, List<DsfRole> dsfRoles, List<Coding> practitionerRoles) {
            this.name = name;
            if (thumbprints != null) {
                this.thumbprints.addAll(thumbprints);
            }
            if (emails != null) {
                this.emails.addAll(emails);
            }
            if (tokenRoles != null) {
                this.tokenRoles.addAll(tokenRoles);
            }
            if (tokenGroups != null) {
                this.tokenGroups.addAll(tokenGroups);
            }
            if (dsfRoles != null) {
                this.dsfRoles.addAll(dsfRoles);
            }
            if (practitionerRoles != null) {
                this.practitionerRoles.addAll(practitionerRoles);
            }
        }

        public String getName() {
            return this.name;
        }

        public List<String> getThumbprints() {
            return Collections.unmodifiableList(this.thumbprints);
        }

        public List<String> getEmails() {
            return Collections.unmodifiableList(this.emails);
        }

        public List<String> getTokenRoles() {
            return Collections.unmodifiableList(this.tokenRoles);
        }

        public List<String> getTokenGroups() {
            return Collections.unmodifiableList(this.tokenGroups);
        }

        public List<DsfRole> getDsfRoles() {
            return Collections.unmodifiableList(this.dsfRoles);
        }

        public List<Coding> getPractitionerRoles() {
            return Collections.unmodifiableList(this.practitionerRoles);
        }

        public String toString() {
            return "[name=" + this.name + ", thumbprints=" + this.thumbprints + ", emails=" + this.emails + ", tokenRoles=" + this.tokenRoles + ", tokenGroups=" + this.tokenGroups + ", dsfRoles=" + this.dsfRoles + ", practitionerRoles=" + this.practitionerRoles.stream().map(c -> c.getSystem() + "|" + c.getCode()).collect(Collectors.joining(", ", "[", "]")) + "]";
        }
    }
}

