/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.webservice;

import dev.dsf.bpe.ui.ThymeleafTemplateService;
import dev.dsf.bpe.webservice.AbstractService;
import jakarta.annotation.security.RolesAllowed;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ResourceDefinition;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.springframework.beans.factory.InitializingBean;
import org.thymeleaf.context.Context;

@RolesAllowed(value={"ADMIN"})
@Path(value="Process")
public class ProcessService
extends AbstractService
implements InitializingBean {
    public static final String PATH = "Process";
    private final RepositoryService repositoryService;
    private final TransformerFactory transformerFactory;

    public ProcessService(ThymeleafTemplateService templateService, RepositoryService repositoryService) {
        super(templateService, PATH);
        this.repositoryService = repositoryService;
        this.transformerFactory = TransformerFactory.newInstance();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.repositoryService, "repositoryService");
    }

    @GET
    @Path(value="/{key}")
    @Produces(value={"text/html"})
    public Response readHtml(@PathParam(value="key") String key) {
        return this.readHtml(key, null);
    }

    @GET
    @Path(value="/{key}/{version}")
    @Produces(value={"text/html"})
    public Response readHtml(@PathParam(value="key") String key, @PathParam(value="version") String version) {
        DefinitionDeploymentModel ddm = this.getProcess(key, version);
        if (ddm == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        StreamingOutput output = this.write("DSF: Process", "Process: " + ddm.definition().getKey() + "|" + ddm.definition().getVersionTag(), this.setContextValues(ddm));
        return Response.ok((Object)output).build();
    }

    private DefinitionDeploymentModel getProcess(String key, String version) {
        ProcessDefinition definition = this.getProcessDefinition(key, version);
        if (definition == null) {
            return null;
        }
        Deployment deployment = (Deployment)((DeploymentQuery)this.repositoryService.createDeploymentQuery().deploymentId(definition.getDeploymentId()).orderByDeploymentTime().desc()).singleResult();
        if (deployment == null) {
            return null;
        }
        BpmnModelInstance model = this.repositoryService.getBpmnModelInstance(definition.getId());
        return new DefinitionDeploymentModel(definition, deployment, model);
    }

    private ProcessDefinition getProcessDefinition(String processDefinitionKey, String versionTag) {
        if (versionTag != null && !versionTag.isBlank()) {
            return this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).versionTag(versionTag).list().stream().max(Comparator.comparing(ResourceDefinition::getVersion)).orElse(null);
        }
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processDefinitionKey).latestVersion().singleResult();
    }

    private Consumer<Context> setContextValues(DefinitionDeploymentModel ddm) {
        return context -> {
            context.setVariable("bpmnViewer", (Object)true);
            context.setVariable("download", (Object)this.toDownload(ddm));
        };
    }

    private String getBpmnBase64Encoded(BpmnModelInstance model) {
        String string;
        DOMSource domSource = model.getDocument().getDomSource();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(domSource, new StreamResult(out));
            byte[] encoded = Base64.getEncoder().encode(out.toByteArray());
            string = new String(encoded, StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | TransformerException e) {
                throw new RuntimeException(e);
            }
        }
        out.close();
        return string;
    }

    private Download toDownload(DefinitionDeploymentModel ddm) {
        String href = "data:application/xml;base64," + this.getBpmnBase64Encoded(ddm.model());
        String filename = ddm.definition().getKey() + "_" + ddm.definition().getVersionTag().replaceAll("\\.", "_") + ".bpmn";
        return new Download(href, "Download as BPMN", filename);
    }

    private record DefinitionDeploymentModel(ProcessDefinition definition, Deployment deployment, BpmnModelInstance model) {
    }

    private record Download(String href, String title, String filename) {
    }
}

