/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import dev.dsf.bpe.listener.ListenerVariables;
import dev.dsf.bpe.subscription.QuestionnaireResponseHandler;
import dev.dsf.bpe.v1.variables.Target;
import dev.dsf.bpe.v1.variables.Targets;
import dev.dsf.bpe.v1.variables.Variables;
import dev.dsf.bpe.variables.FhirResourceValues;
import dev.dsf.bpe.variables.FhirResourcesList;
import dev.dsf.bpe.variables.FhirResourcesListValues;
import dev.dsf.bpe.variables.TargetImpl;
import dev.dsf.bpe.variables.TargetValues;
import dev.dsf.bpe.variables.TargetsImpl;
import dev.dsf.bpe.variables.TargetsValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesImpl
implements Variables,
ListenerVariables {
    private static final Logger logger = LoggerFactory.getLogger(VariablesImpl.class);
    private static final String TASKS_PREFIX = VariablesImpl.class.getName() + ".tasks.";
    private static final String START_TASK = VariablesImpl.class.getName() + ".startTask";
    private final DelegateExecution execution;

    public VariablesImpl(DelegateExecution execution) {
        this.execution = Objects.requireNonNull(execution, "execution");
    }

    public void setAlternativeBusinessKey(String alternativeBusinessKey) {
        this.execution.setVariable("alternativeBusinessKey", (Object)alternativeBusinessKey);
    }

    public Target createTarget(String organizationIdentifierValue, String endpointIdentifierValue, String endpointAddress, String correlationKey) {
        Objects.requireNonNull(organizationIdentifierValue, "organizationIdentifierValue");
        Objects.requireNonNull(endpointIdentifierValue, "endpointIdentifierValue");
        Objects.requireNonNull(endpointAddress, "endpointAddress");
        return new TargetImpl(organizationIdentifierValue, endpointIdentifierValue, endpointAddress, correlationKey);
    }

    public void setTarget(Target target) throws IllegalArgumentException {
        if (target == null) {
            this.execution.setVariable("target", null);
            return;
        }
        if (!(target instanceof TargetImpl)) {
            throw new IllegalArgumentException("Given target implementing class " + target.getClass().getName() + " not supported");
        }
        TargetValues.TargetValue variable = TargetValues.create((TargetImpl)target);
        this.execution.setVariable("target", (Object)variable);
    }

    public Target getTarget() {
        return (TargetImpl)this.execution.getVariable("target");
    }

    public Targets createTargets(List<? extends Target> targets) {
        if (targets == null) {
            return new TargetsImpl(Collections.emptyList());
        }
        Optional<Target> firstNonMatch = targets.stream().filter(t -> !(t instanceof TargetImpl)).findFirst();
        if (firstNonMatch.isPresent()) {
            throw new IllegalArgumentException("Target implementing class " + firstNonMatch.get().getClass().getName() + " (in given List) not supported");
        }
        return new TargetsImpl(targets);
    }

    public void setTargets(Targets targets) throws IllegalArgumentException {
        if (targets == null) {
            this.execution.setVariable("targets", null);
        } else if (targets instanceof TargetsImpl) {
            TargetsImpl t = (TargetsImpl)targets;
            this.execution.setVariable("targets", (Object)TargetsValues.create(t));
        } else {
            throw new IllegalArgumentException("Given targets implementing class " + targets.getClass().getName() + " not supported");
        }
    }

    public Targets getTargets() {
        return (Targets)this.execution.getVariable("targets");
    }

    public void setResourceList(String variableName, List<? extends Resource> resources) {
        FhirResourcesListValues.FhirResourcesListValue variable = resources == null ? null : FhirResourcesListValues.create(resources);
        this.execution.setVariable(variableName, (Object)variable);
    }

    public <R extends Resource> List<R> getResourceList(String variableName) {
        FhirResourcesList list = (FhirResourcesList)this.execution.getVariable(variableName);
        return list != null ? list.getResourcesAndCast() : null;
    }

    private <R extends Resource> List<R> getResourceListOrDefault(String variableName, List<R> defaultList) {
        List<R> list = this.getResourceList(variableName);
        return list != null ? list : defaultList;
    }

    public void setResource(String variableName, Resource resource) {
        FhirResourceValues.FhirResourceValue variable = resource == null ? null : FhirResourceValues.create(resource);
        this.execution.setVariable(variableName, (Object)variable);
    }

    public <R extends Resource> R getResource(String variableName) {
        Resource resource = (Resource)this.execution.getVariable(variableName);
        return (R)resource;
    }

    public Task getStartTask() {
        logger.trace("getStartTask - parentActivityInstanceId: {}, parentId: {}", (Object)this.execution.getParentActivityInstanceId(), (Object)this.execution.getParentId());
        return (Task)this.getResource(START_TASK);
    }

    public Task getLatestTask() {
        logger.trace("getLatestTask - parentActivityInstanceId: {}, parentId: {}", (Object)this.execution.getParentActivityInstanceId(), (Object)this.execution.getParentId());
        List<Task> tasks = this.getCurrentTasks();
        return tasks == null || tasks.isEmpty() ? null : tasks.get(tasks.size() - 1);
    }

    public List<Task> getTasks() {
        logger.trace("getTasks - parentActivityInstanceId: {}, parentId: {}", (Object)this.execution.getParentActivityInstanceId(), (Object)this.execution.getParentId());
        List<Task> tasks = Stream.concat(Stream.of(this.getStartTask()), this.execution.getVariables().keySet().stream().filter(k -> k.startsWith(TASKS_PREFIX)).map(this::getResourceList).flatMap(Collection::stream).filter(r -> r instanceof Task).map(r -> (Task)r)).filter(t -> t != null).map(DistinctTask::new).distinct().map(DistinctTask::getTask).toList();
        return Collections.unmodifiableList(tasks);
    }

    public List<Task> getCurrentTasks() {
        logger.trace("getCurrentTasks - parentActivityInstanceId: {}, parentId: {}", (Object)this.execution.getParentActivityInstanceId(), (Object)this.execution.getParentId());
        Stream start = this.execution.getParentId() == null ? Stream.of(this.getStartTask()) : Stream.empty();
        Stream current = this.getResourceListOrDefault(TASKS_PREFIX + this.execution.getParentActivityInstanceId(), Collections.emptyList()).stream();
        return Collections.unmodifiableList(Stream.concat(start, current).toList());
    }

    public void updateTask(Task task) {
        logger.trace("updateTask- Task.id: {}", (Object)(task == null ? "null" : task.getIdElement().getIdPart()));
        if (task != null) {
            if (this.getStartTask() != null && Objects.equals(this.getStartTask().getIdElement().getIdPart(), task.getIdElement().getIdPart())) {
                this.setResource(START_TASK, (Resource)task);
            } else {
                String instanceId = this.execution.getParentActivityInstanceId();
                List tasks = this.getResourceListOrDefault(TASKS_PREFIX + instanceId, Collections.emptyList());
                if (tasks.stream().anyMatch(t -> t.getIdElement().getIdPart().equals(task.getIdElement().getIdPart()))) {
                    this.setResourceList(TASKS_PREFIX + instanceId, tasks);
                } else {
                    logger.warn("Given task {} not part of tasks list '{}', ignoring task", (Object)task.getIdElement().getIdPart().toString(), (Object)instanceId);
                }
            }
        } else {
            logger.warn("Given task is null");
        }
    }

    @Override
    public void onStart(Task task) {
        logger.trace("onStart - Task.id: {}", (Object)(task == null ? "null" : task.getIdElement().getIdPart()));
        if (task != null) {
            this.setResource(START_TASK, (Resource)task);
        } else {
            logger.warn("Given task is null");
        }
    }

    @Override
    public void onContinue(Task task) {
        logger.trace("onContinue - Task.id: {}", (Object)(task == null ? "null" : task.getIdElement().getIdPart()));
        if (task != null) {
            String instanceId = this.execution.getParentActivityInstanceId();
            ArrayList tasks = new ArrayList(this.getResourceListOrDefault(TASKS_PREFIX + instanceId, Collections.emptyList()));
            tasks.add(task);
            this.setResourceList(TASKS_PREFIX + instanceId, tasks);
        } else {
            logger.warn("Given task is null");
        }
    }

    @Override
    public void onEnd() {
        logger.trace("onEnd");
        String instanceId = this.execution.getParentActivityInstanceId();
        ArrayList tasks = new ArrayList(this.getResourceListOrDefault(TASKS_PREFIX + instanceId, Collections.emptyList()));
        tasks.removeAll(this.getCurrentTasks());
        this.setResourceList(TASKS_PREFIX + instanceId, tasks);
    }

    public QuestionnaireResponse getLatestReceivedQuestionnaireResponse() {
        return (QuestionnaireResponse)this.getResource(QuestionnaireResponseHandler.QUESTIONNAIRE_RESPONSE_VARIABLE);
    }

    public void setVariable(String variableName, TypedValue value) {
        Objects.requireNonNull(variableName, "variableName");
        this.execution.setVariable(variableName, (Object)value);
    }

    public Object getVariable(String variableName) {
        Objects.requireNonNull(variableName, "variableName");
        return this.execution.getVariable(variableName);
    }

    private static final class DistinctTask {
        final Task task;

        DistinctTask(Task task) {
            this.task = task;
        }

        Task getTask() {
            return this.task;
        }

        public boolean equals(Object otherO) {
            if (otherO instanceof DistinctTask) {
                DistinctTask other = (DistinctTask)otherO;
                return Objects.equals(other.task.getIdElement().getIdPart(), this.task.getIdElement().getIdPart());
            }
            return false;
        }

        public int hashCode() {
            return this.task.getIdElement().getIdPart().hashCode();
        }
    }
}

