/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.ui;

import dev.dsf.bpe.ui.ThymeleafTemplateService;
import dev.dsf.common.ui.theme.Theme;
import jakarta.ws.rs.core.StreamingOutput;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.springframework.beans.factory.InitializingBean;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateServiceImpl
implements ThymeleafTemplateService,
InitializingBean {
    private final String serverBaseUrl;
    private final Theme theme;
    private final boolean cacheEnabled;
    private final boolean modCssExists;
    private final TemplateEngine templateEngine = new TemplateEngine();

    public ThymeleafTemplateServiceImpl(String serverBaseUrl, Theme theme, boolean cacheEnabled, boolean modCssExists) {
        this.serverBaseUrl = serverBaseUrl;
        this.theme = theme;
        this.cacheEnabled = cacheEnabled;
        this.modCssExists = modCssExists;
        ClassLoaderTemplateResolver resolver = new ClassLoaderTemplateResolver();
        resolver.setTemplateMode(TemplateMode.HTML);
        resolver.setPrefix("/template/");
        resolver.setSuffix(".html");
        resolver.setCacheable(cacheEnabled);
        this.templateEngine.setTemplateResolver((ITemplateResolver)resolver);
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.serverBaseUrl, "serverBaseUrl");
    }

    private String getServerBaseUrlPathWithLeadingSlash() {
        try {
            return new URL(this.serverBaseUrl).getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public StreamingOutput write(Context context, ThymeleafTemplateService.MainValues mainValues) {
        Objects.requireNonNull(context, "context");
        Objects.requireNonNull(mainValues, "mainValues");
        context.setVariable("title", (Object)mainValues.title());
        context.setVariable("heading", (Object)mainValues.heading());
        context.setVariable("htmlFragment", (Object)mainValues.htmlFragment());
        context.setVariable("username", (Object)mainValues.username());
        context.setVariable("openid", (Object)mainValues.openid());
        context.setVariable("basePath", (Object)this.getServerBaseUrlPathWithLeadingSlash());
        context.setVariable("modCssExists", (Object)this.modCssExists);
        context.setVariable("theme", this.theme == null ? null : this.theme.toString());
        context.setVariable("bpmnProd", (Object)this.cacheEnabled);
        return output -> this.templateEngine.process("main", (IContext)context, (Writer)new OutputStreamWriter(output));
    }
}

