/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import dev.dsf.bpe.subscription.ResourceHandler;
import dev.dsf.bpe.v1.constants.CodeSystems;
import dev.dsf.bpe.variables.FhirResourceValues;
import dev.dsf.fhir.client.FhirWebserviceClient;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.camunda.bpm.engine.MismatchingMessageCorrelationException;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.RuntimeService;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ResourceDefinition;
import org.camunda.bpm.engine.runtime.Execution;
import org.camunda.bpm.engine.runtime.MessageCorrelationBuilder;
import org.camunda.bpm.engine.runtime.ProcessInstanceQuery;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.StartEvent;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class TaskHandler
implements ResourceHandler<Task>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(TaskHandler.class);
    public static final String TASK_VARIABLE = TaskHandler.class.getName() + ".task";
    private static final String INSTANTIATES_CANONICAL_PATTERN_STRING = "(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$";
    private static final Pattern INSTANTIATES_CANONICAL_PATTERN = Pattern.compile("(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$");
    private final RuntimeService runtimeService;
    private final RepositoryService repositoryService;
    private final FhirWebserviceClient webserviceClient;

    public TaskHandler(RuntimeService runtimeService, RepositoryService repositoryService, FhirWebserviceClient webserviceClient) {
        this.runtimeService = runtimeService;
        this.repositoryService = repositoryService;
        this.webserviceClient = webserviceClient;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.runtimeService, "runtimeService");
        Objects.requireNonNull(this.repositoryService, "repositoryService");
        Objects.requireNonNull(this.webserviceClient, "webserviceClient");
    }

    @Override
    public void onResource(Task task) {
        Objects.requireNonNull(task, "task");
        Objects.requireNonNull(task.getInstantiatesCanonical(), "task.instantiatesCanonical");
        Matcher matcher = INSTANTIATES_CANONICAL_PATTERN.matcher(task.getInstantiatesCanonical());
        if (!matcher.matches()) {
            throw new IllegalStateException("InstantiatesCanonical of Task with id " + task.getIdElement().getIdPart() + " does not match (?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$");
        }
        String processDomain = matcher.group("domain").replace(".", "");
        String processDefinitionKey = matcher.group("processName");
        String processVersion = matcher.group("processVersion");
        String messageName = this.getFirstInputParameter(task, CodeSystems.BpmnMessage.messageName());
        String businessKey = this.getFirstInputParameter(task, CodeSystems.BpmnMessage.businessKey());
        String correlationKey = this.getFirstInputParameter(task, CodeSystems.BpmnMessage.correlationKey());
        if (businessKey == null) {
            businessKey = UUID.randomUUID().toString();
            logger.debug("Adding business-key {} to Task with id {}", (Object)businessKey, (Object)task.getId());
            task.addInput().setType(new CodeableConcept(CodeSystems.BpmnMessage.businessKey())).setValue((Type)new StringType(businessKey));
        }
        task.setStatus(Task.TaskStatus.INPROGRESS);
        task = (Task)this.webserviceClient.update((Resource)task);
        Map<String, Object> variables = Map.of(TASK_VARIABLE, FhirResourceValues.create((Resource)task));
        try {
            this.onMessage(businessKey, correlationKey, processDomain, processDefinitionKey, processVersion, messageName, variables);
        }
        catch (MismatchingMessageCorrelationException e) {
            logger.debug("Unable to handle Task with id {}", (Object)task.getId(), (Object)e);
            logger.warn("Unable to handle Task with id {}: {} - {}", new Object[]{task.getId(), ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            this.updateTaskFailed(task, "Unable to correlate Task");
        }
        catch (ProcessNotFoundException e) {
            logger.debug("Unable to handle Task with id {}", (Object)task.getId(), (Object)e);
            logger.warn("Unable to handle Task with id {}: {} - {}", new Object[]{task.getId(), ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            this.updateTaskFailed(task, e.getShortMessage());
        }
        catch (Exception e) {
            logger.debug("Unable to handle Task with id {}", (Object)task.getId(), (Object)e);
            logger.error("Unable to handle Task with id {}: {} - {}", new Object[]{task.getId(), e.getClass().getName(), e.getMessage()});
            this.updateTaskFailed(task, e);
        }
    }

    private void updateTaskFailed(Task task, Exception e) {
        this.updateTaskFailed(task, e.getClass().getName() + ": " + e.getMessage());
    }

    private void updateTaskFailed(Task task, String message) {
        task.addOutput().setType(new CodeableConcept(CodeSystems.BpmnMessage.error())).setValue((Type)new StringType(message));
        task.setStatus(Task.TaskStatus.FAILED);
        try {
            this.webserviceClient.update((Resource)task);
        }
        catch (Exception e) {
            logger.debug("Unable to update Task with id {} (status failed)", (Object)task.getId(), (Object)e);
            logger.error("Unable to update Task with id {} (status failed): {} - {}", new Object[]{task.getId(), e.getClass().getName(), e.getMessage()});
        }
    }

    private String getFirstInputParameter(Task task, Coding code) {
        if (task == null || code == null) {
            return null;
        }
        return task.getInput().stream().filter(Task.ParameterComponent::hasType).filter(c -> c.getType().getCoding().stream().anyMatch(co -> co != null && Objects.equals(code.getSystem(), co.getSystem()) && Objects.equals(code.getCode(), co.getCode()))).filter(Task.ParameterComponent::hasValue).map(Task.ParameterComponent::getValue).filter(v -> v instanceof StringType).map(v -> (StringType)v).map(PrimitiveType::getValue).findFirst().orElse(null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onMessage(String businessKey, String correlationKey, String processDomain, String processDefinitionKey, String processVersion, String messageName, Map<String, Object> variables2) {
        ProcessDefinition processDefinition;
        Objects.requireNonNull(processDomain, "processDomain");
        Objects.requireNonNull(processDefinitionKey, "processDefinitionKey");
        Objects.requireNonNull(processVersion, "processVersion");
        Objects.requireNonNull(messageName, "messageName");
        if (variables2 == null) {
            Map variables2 = Collections.emptyMap();
        }
        if ((processDefinition = this.getProcessDefinition(processDomain, processDefinitionKey, processVersion)) == null) {
            throw new ProcessNotFoundException(processDomain, processDefinitionKey, processVersion, null);
        }
        if (businessKey == null) {
            this.runtimeService.startProcessInstanceByMessageAndProcessDefinitionId(messageName, processDefinition.getId(), UUID.randomUUID().toString(), (Map)variables2);
            return;
        } else {
            List instances = this.getProcessInstanceQuery(processDefinition, businessKey).list();
            List instancesWithAlternativeBusinessKey = this.getAlternativeProcessInstanceQuery(processDefinition, businessKey).list();
            if (instances.size() + instancesWithAlternativeBusinessKey.size() > 1) {
                logger.warn("instance-ids {}", (Object)Stream.concat(instances.stream(), instancesWithAlternativeBusinessKey.stream()).map(Execution::getId).collect(Collectors.joining(", ", "[", "]")));
            }
            if (instances.size() + instancesWithAlternativeBusinessKey.size() <= 0) {
                BpmnModelInstance model = this.repositoryService.getBpmnModelInstance(processDefinition.getId());
                Collection<Object> collection = model == null ? Collections.emptySet() : model.getModelElementsByType(StartEvent.class);
                Stream<String> startEventMesssageNames = collection.stream().flatMap(e -> {
                    Collection m = e.getChildElementsByType(MessageEventDefinition.class);
                    return m == null ? Stream.empty() : m.stream();
                }).map(d -> d.getMessage().getName());
                if (!startEventMesssageNames.anyMatch(m -> m.equals(messageName))) throw new ProcessNotFoundException(processDomain, processDefinitionKey, processVersion, messageName);
                this.runtimeService.createMessageCorrelation(messageName).processDefinitionId(processDefinition.getId()).processInstanceBusinessKey(businessKey).setVariables((Map)variables2).correlateStartMessage();
                return;
            } else {
                MessageCorrelationBuilder correlation = instances.size() > 0 ? this.runtimeService.createMessageCorrelation(messageName).setVariables((Map)variables2).processInstanceBusinessKey(businessKey) : this.runtimeService.createMessageCorrelation(messageName).setVariables((Map)variables2).processInstanceVariableEquals("alternativeBusinessKey", (Object)businessKey);
                if (correlationKey != null) {
                    correlation = correlation.localVariableEquals("correlationKey", (Object)correlationKey);
                }
                correlation.correlate();
            }
        }
    }

    private ProcessDefinition getProcessDefinition(String processDomain, String processDefinitionKey, String processVersion) {
        if (processVersion != null && !processVersion.isBlank()) {
            return this.repositoryService.createProcessDefinitionQuery().active().processDefinitionKey(processDomain + "_" + processDefinitionKey).versionTag(processVersion).list().stream().max(Comparator.comparing(ResourceDefinition::getVersion)).orElse(null);
        }
        return (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().active().processDefinitionKey(processDomain + "_" + processDefinitionKey).latestVersion().singleResult();
    }

    private ProcessInstanceQuery getProcessInstanceQuery(ProcessDefinition processDefinition, String businessKey) {
        return this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).processInstanceBusinessKey(businessKey);
    }

    private ProcessInstanceQuery getAlternativeProcessInstanceQuery(ProcessDefinition processDefinition, String businessKey) {
        return this.runtimeService.createProcessInstanceQuery().processDefinitionId(processDefinition.getId()).variableValueEquals("alternativeBusinessKey", (Object)businessKey);
    }

    private static final class ProcessNotFoundException
    extends ProcessEngineException {
        private static final long serialVersionUID = 1L;
        private final String startMessageName;

        ProcessNotFoundException(String processDomain, String processDefinitionKey, String processVersion, String startMessageName) {
            super(ProcessNotFoundException.toMessage(processDomain, processDefinitionKey, processVersion, startMessageName));
            this.startMessageName = startMessageName;
        }

        private static String toMessage(String processDomain, String processDefinitionKey, String processVersion, String startMessageName) {
            Objects.requireNonNull(processDomain, "processDomain");
            Objects.requireNonNull(processDefinitionKey, "processDefinitionKey");
            if (processVersion != null && !processVersion.isBlank()) {
                if (startMessageName != null && !startMessageName.isBlank()) {
                    return "Process with id '" + processDomain + "_" + processDefinitionKey + "', version '" + processVersion + "' and start message-name '" + startMessageName + "' not found";
                }
                return "Process with id: '" + processDomain + "_" + processDefinitionKey + "' and version '" + processVersion + "' not found";
            }
            if (startMessageName != null && !startMessageName.isBlank()) {
                return "Process with id: '" + processDomain + "_" + processDefinitionKey + "' and start message-name: '" + startMessageName + "' not found";
            }
            return "Process with id: '" + processDomain + "_" + processDefinitionKey + "' not found";
        }

        String getShortMessage() {
            if (this.startMessageName != null && !this.startMessageName.isBlank()) {
                return "Process with start message-name '" + this.startMessageName + "' not found";
            }
            return "Process not found";
        }
    }
}

