/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import dev.dsf.bpe.subscription.EventResourceHandler;
import dev.dsf.bpe.subscription.ExistingResourceLoader;
import dev.dsf.bpe.subscription.PingEventResourceHandler;
import dev.dsf.bpe.subscription.SubscriptionHandlerFactory;
import dev.dsf.fhir.client.FhirWebserviceClient;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class ConcurrentSubscriptionHandlerFactory<R extends Resource>
implements SubscriptionHandlerFactory<R>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ConcurrentSubscriptionHandlerFactory.class);
    private final SubscriptionHandlerFactory<R> delegate;
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final ThreadPoolExecutor executor;

    public ConcurrentSubscriptionHandlerFactory(int corePoolSize, SubscriptionHandlerFactory<R> delegate) {
        if (corePoolSize <= 0) {
            throw new IllegalArgumentException("corePoolSize <= 0");
        }
        this.executor = new ThreadPoolExecutor(corePoolSize, corePoolSize, 30L, TimeUnit.MINUTES, this.queue, (r, executor) -> logger.error("Unable to handle Task - execution rejected"));
        this.executor.allowCoreThreadTimeOut(true);
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.delegate, "delegate");
    }

    @Override
    public ExistingResourceLoader<R> createExistingResourceLoader(FhirWebserviceClient client) {
        return this.delegate.createExistingResourceLoader(client);
    }

    @Override
    public EventResourceHandler<R> createEventResourceHandler() {
        EventResourceHandler delegateHandler = this.delegate.createEventResourceHandler();
        return resource -> this.executor.submit(() -> {
            logger.debug("executing onResource for {} with id: {}", (Object)resource.getResourceType().name(), (Object)resource.getIdElement().getValue());
            delegateHandler.onResource(resource);
        });
    }

    @Override
    public PingEventResourceHandler<R> createPingEventResourceHandler(ExistingResourceLoader<R> existingResourceLoader) {
        PingEventResourceHandler delegateHandler = this.delegate.createPingEventResourceHandler(existingResourceLoader);
        return (ping, subscriptionIdPart, searchCriteriaQueryParameters) -> this.executor.submit(() -> delegateHandler.onPing(ping, subscriptionIdPart, searchCriteriaQueryParameters));
    }
}

