/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import dev.dsf.bpe.spring.config.DaoConfig;
import dev.dsf.bpe.spring.config.PropertiesConfig;
import dev.dsf.bpe.ui.ThymeleafTemplateService;
import dev.dsf.bpe.ui.ThymeleafTemplateServiceImpl;
import dev.dsf.bpe.webservice.ProcessService;
import dev.dsf.bpe.webservice.RootService;
import dev.dsf.common.auth.logout.LogoutService;
import dev.dsf.common.status.webservice.StatusService;
import dev.dsf.common.ui.webservice.StaticResourcesService;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.camunda.bpm.engine.ProcessEngine;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebserviceConfig {
    @Autowired
    private ProcessEngine processEngine;
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private PropertiesConfig propertiesConfig;

    @Bean
    public ThymeleafTemplateService thymeleafTemplateService() {
        return new ThymeleafTemplateServiceImpl(this.propertiesConfig.getServerBaseUrl(), this.propertiesConfig.getUiTheme(), this.propertiesConfig.getStaticResourceCacheEnabled(), this.modCssExists());
    }

    private boolean modCssExists() {
        return Files.isReadable(Paths.get("ui/mod.css", new String[0]));
    }

    @Bean
    public LogoutService logoutService() {
        return new LogoutService();
    }

    @Bean
    public ProcessService processService() {
        return new ProcessService(this.thymeleafTemplateService(), this.processEngine.getRepositoryService());
    }

    @Bean
    public RootService rootService() {
        return new RootService(this.thymeleafTemplateService(), this.processEngine.getRepositoryService(), this.processEngine.getRuntimeService());
    }

    @Bean
    public StaticResourcesService staticResourcesService() {
        return new StaticResourcesService(this.propertiesConfig.getStaticResourceCacheEnabled());
    }

    @Bean
    public StatusService statusService() {
        return new StatusService(this.daoConfig.dataSource(), this.propertiesConfig.getJettyStatusConnectorPort());
    }
}

