/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.service;

import dev.dsf.bpe.service.LocalOrganizationProvider;
import dev.dsf.bpe.v1.service.OrganizationProvider;
import java.time.LocalDateTime;
import java.time.temporal.TemporalAmount;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.hl7.fhir.r4.model.Organization;
import org.springframework.beans.factory.InitializingBean;

public class LocalOrganizationProviderImpl
implements LocalOrganizationProvider,
InitializingBean {
    private final AtomicReference<OrganizationEntry> organization = new AtomicReference();
    private final TemporalAmount cacheTimeout;
    private final OrganizationProvider delegate;

    public LocalOrganizationProviderImpl(TemporalAmount cacheTimeout, OrganizationProvider delegate) {
        this.cacheTimeout = cacheTimeout;
        this.delegate = delegate;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.cacheTimeout, "cacheTimeout");
        Objects.requireNonNull(this.delegate, "delegate");
    }

    @Override
    public Optional<Organization> getLocalOrganization() {
        OrganizationEntry entry = this.organization.get();
        if (entry == null || entry.organization().isEmpty() || LocalDateTime.now().isAfter(entry.readTime().plus(this.cacheTimeout))) {
            Optional o = this.delegate.getLocalOrganization();
            if (this.organization.compareAndSet(entry, new OrganizationEntry(o, LocalDateTime.now()))) {
                return o;
            }
            return this.organization.get().organization();
        }
        return entry.organization();
    }

    private record OrganizationEntry(Optional<Organization> organization, LocalDateTime readTime) {
    }
}

