/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessState;
import dev.dsf.bpe.plugin.ResourceInfo;
import dev.dsf.bpe.v1.constants.NamingSystems;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.ValueSet;

public final class ProcessesResource {
    private final ResourceInfo resourceInfo;
    private final Resource resource;
    private final Set<ProcessIdAndVersion> processes = new HashSet<ProcessIdAndVersion>();
    private ProcessState oldState;
    private ProcessState newState;

    public static ProcessesResource from(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        if (resource instanceof ActivityDefinition) {
            ActivityDefinition a = (ActivityDefinition)resource;
            return ProcessesResource.fromMetadataResource((MetadataResource)a);
        }
        if (resource instanceof CodeSystem) {
            CodeSystem c = (CodeSystem)resource;
            return ProcessesResource.fromMetadataResource((MetadataResource)c);
        }
        if (resource instanceof Library) {
            Library l = (Library)resource;
            return ProcessesResource.fromMetadataResource((MetadataResource)l);
        }
        if (resource instanceof Measure) {
            Measure m = (Measure)resource;
            return ProcessesResource.fromMetadataResource((MetadataResource)m);
        }
        if (resource instanceof NamingSystem) {
            NamingSystem n = (NamingSystem)resource;
            return ProcessesResource.fromNamingSystem(n);
        }
        if (resource instanceof Questionnaire) {
            Questionnaire q = (Questionnaire)resource;
            return ProcessesResource.fromMetadataResource((MetadataResource)q);
        }
        if (resource instanceof StructureDefinition) {
            StructureDefinition s = (StructureDefinition)resource;
            return ProcessesResource.fromMetadataResource((MetadataResource)s);
        }
        if (resource instanceof Task) {
            Task t = (Task)resource;
            return ProcessesResource.fromTask(t);
        }
        if (resource instanceof ValueSet) {
            ValueSet v = (ValueSet)resource;
            return ProcessesResource.fromMetadataResource((MetadataResource)v);
        }
        throw new IllegalArgumentException("MetadataResource of type " + resource.getClass().getName() + " not supported");
    }

    public static ProcessesResource fromMetadataResource(MetadataResource resource) {
        return new ProcessesResource(new ResourceInfo(resource.getResourceType(), resource.getUrl(), resource.getVersion(), null, null), (Resource)resource);
    }

    public static ProcessesResource fromNamingSystem(NamingSystem resource) {
        return new ProcessesResource(new ResourceInfo(resource.getResourceType(), null, null, resource.getName(), null), (Resource)resource);
    }

    public static ProcessesResource fromTask(Task resource) {
        return new ProcessesResource(new ResourceInfo(resource.getResourceType(), null, null, null, ProcessesResource.getIdentifier(resource)), (Resource)resource);
    }

    private static String getIdentifier(Task resource) {
        return NamingSystems.TaskIdentifier.findFirst((Task)resource).map(Identifier::getValue).get();
    }

    public static ProcessesResource from(ResourceInfo resourceInfo) {
        return new ProcessesResource(resourceInfo, null);
    }

    private ProcessesResource(ResourceInfo resourceInfo, Resource resource) {
        this.resourceInfo = resourceInfo;
        this.resource = resource;
    }

    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Set<ProcessIdAndVersion> getProcesses() {
        return Collections.unmodifiableSet(this.processes);
    }

    public ProcessesResource add(ProcessIdAndVersion process) {
        this.processes.add(process);
        return this;
    }

    public void addAll(Set<ProcessIdAndVersion> processes) {
        this.processes.addAll(processes);
    }

    public ProcessesResource setOldProcessState(ProcessState oldState) {
        this.oldState = oldState;
        return this;
    }

    public ProcessState getOldProcessState() {
        return this.oldState;
    }

    public ProcessesResource setNewProcessState(ProcessState newState) {
        this.newState = newState;
        return this;
    }

    public ProcessState getNewProcessState() {
        return this.newState;
    }

    public boolean hasStateChangeOrDraft() {
        return !Objects.equals((Object)this.getOldProcessState(), (Object)this.getNewProcessState()) || ProcessState.DRAFT.equals((Object)this.getOldProcessState()) && ProcessState.DRAFT.equals((Object)this.getNewProcessState());
    }

    public boolean notNewToExcludedChange() {
        return !ProcessState.NEW.equals((Object)this.getOldProcessState()) || !ProcessState.EXCLUDED.equals((Object)this.getNewProcessState());
    }

    public boolean shouldExist() {
        return ProcessState.ACTIVE.equals((Object)this.getOldProcessState()) && ProcessState.ACTIVE.equals((Object)this.getNewProcessState()) || ProcessState.RETIRED.equals((Object)this.getOldProcessState()) && ProcessState.RETIRED.equals((Object)this.getNewProcessState());
    }

    public Bundle.BundleEntryComponent toBundleEntry() {
        return switch (this.getOldProcessState()) {
            default -> throw new IncompatibleClassChangeError();
            case ProcessState.MISSING -> this.fromMissing();
            case ProcessState.NEW -> this.fromNew();
            case ProcessState.ACTIVE -> this.fromActive();
            case ProcessState.DRAFT -> this.fromDraft();
            case ProcessState.RETIRED -> this.fromRetired();
            case ProcessState.EXCLUDED -> this.fromExcluded();
        };
    }

    private Bundle.BundleEntryComponent fromMissing() {
        return switch (this.getNewProcessState()) {
            case ProcessState.ACTIVE -> this.createAsActive();
            case ProcessState.RETIRED -> this.createAsRetired();
            default -> throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
        };
    }

    private Bundle.BundleEntryComponent fromNew() {
        return switch (this.getNewProcessState()) {
            case ProcessState.ACTIVE -> this.createAsActive();
            case ProcessState.DRAFT -> this.createAsDraft();
            case ProcessState.RETIRED -> this.createAsRetired();
            default -> throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
        };
    }

    private Bundle.BundleEntryComponent fromActive() {
        return switch (this.getNewProcessState()) {
            case ProcessState.DRAFT -> this.updateToDraft();
            case ProcessState.RETIRED -> this.updateToRetired();
            case ProcessState.EXCLUDED -> this.delete();
            default -> throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
        };
    }

    private Bundle.BundleEntryComponent fromDraft() {
        return switch (this.getNewProcessState()) {
            case ProcessState.ACTIVE -> this.updateToActive();
            case ProcessState.DRAFT -> this.updateToDraft();
            case ProcessState.RETIRED -> this.updateToRetired();
            case ProcessState.EXCLUDED -> this.delete();
            default -> throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
        };
    }

    private Bundle.BundleEntryComponent fromRetired() {
        return switch (this.getNewProcessState()) {
            case ProcessState.ACTIVE -> this.updateToActive();
            case ProcessState.DRAFT -> this.updateToDraft();
            case ProcessState.EXCLUDED -> this.delete();
            default -> throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
        };
    }

    private Bundle.BundleEntryComponent fromExcluded() {
        return switch (this.getNewProcessState()) {
            case ProcessState.ACTIVE -> this.createAsActive();
            case ProcessState.DRAFT -> this.createAsDraft();
            case ProcessState.RETIRED -> this.createAsRetired();
            default -> throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
        };
    }

    private Bundle.BundleEntryComponent createAsActive() {
        Resource resource = this.getResource();
        if (resource instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)resource;
            m.setStatus(Enumerations.PublicationStatus.ACTIVE);
        }
        return this.create();
    }

    private Bundle.BundleEntryComponent createAsDraft() {
        Resource resource = this.getResource();
        if (resource instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)resource;
            m.setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        return this.create();
    }

    private Bundle.BundleEntryComponent createAsRetired() {
        Resource resource = this.getResource();
        if (resource instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)resource;
            m.setStatus(Enumerations.PublicationStatus.RETIRED);
        }
        return this.create();
    }

    private Bundle.BundleEntryComponent create() {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        entry.setResource(this.getResource());
        entry.setFullUrl("urn:uuid:" + UUID.randomUUID().toString());
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.POST);
        request.setUrl(this.getResourceInfo().getResourceType().name());
        request.setIfNoneExist(this.getResourceInfo().toConditionalUrl());
        return entry;
    }

    private Bundle.BundleEntryComponent updateToActive() {
        Resource resource = this.getResource();
        if (resource instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)resource;
            m.setStatus(Enumerations.PublicationStatus.ACTIVE);
        }
        return this.update();
    }

    private Bundle.BundleEntryComponent updateToDraft() {
        Resource resource = this.getResource();
        if (resource instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)resource;
            m.setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        return this.update();
    }

    private Bundle.BundleEntryComponent updateToRetired() {
        Resource resource = this.getResource();
        if (resource instanceof MetadataResource) {
            MetadataResource m = (MetadataResource)resource;
            m.setStatus(Enumerations.PublicationStatus.RETIRED);
        }
        return this.update();
    }

    private Bundle.BundleEntryComponent update() {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        entry.setResource(this.getResource());
        entry.setFullUrl("urn:uuid:" + UUID.randomUUID().toString());
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.PUT);
        request.setUrl(this.getResourceInfo().getResourceType().name() + "?" + this.getResourceInfo().toConditionalUrl());
        return entry;
    }

    private Bundle.BundleEntryComponent delete() {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.DELETE);
        request.setUrl(this.getResourceInfo().getResourceType().name() + "?" + this.getResourceInfo().toConditionalUrl());
        return entry;
    }

    public List<String> getExpectedStatus() {
        return switch (this.getOldProcessState()) {
            default -> throw new IncompatibleClassChangeError();
            case ProcessState.MISSING -> {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        yield Arrays.asList("200", "201");
                    }
                    case RETIRED: {
                        yield Arrays.asList("200", "201");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case ProcessState.NEW -> {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        yield Arrays.asList("200", "201");
                    }
                    case DRAFT: {
                        yield Arrays.asList("200", "201");
                    }
                    case RETIRED: {
                        yield Arrays.asList("200", "201");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case ProcessState.ACTIVE -> {
                switch (this.getNewProcessState()) {
                    case DRAFT: {
                        yield Collections.singletonList("200");
                    }
                    case RETIRED: {
                        yield Collections.singletonList("200");
                    }
                    case EXCLUDED: {
                        yield Arrays.asList("200", "204");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case ProcessState.DRAFT -> {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        yield Collections.singletonList("200");
                    }
                    case DRAFT: {
                        yield Collections.singletonList("200");
                    }
                    case RETIRED: {
                        yield Collections.singletonList("200");
                    }
                    case EXCLUDED: {
                        yield Arrays.asList("200", "204");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case ProcessState.RETIRED -> {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        yield Collections.singletonList("200");
                    }
                    case DRAFT: {
                        yield Collections.singletonList("200");
                    }
                    case EXCLUDED: {
                        yield Arrays.asList("200", "204");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case ProcessState.EXCLUDED -> {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        yield Arrays.asList("200", "201");
                    }
                    case DRAFT: {
                        yield Arrays.asList("200", "201");
                    }
                    case RETIRED: {
                        yield Arrays.asList("200", "201");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
        };
    }

    public Bundle.BundleEntryComponent toSearchBundleEntryCount0() {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.GET);
        request.setUrl(this.getSearchBundleEntryUrl() + "&_count=0");
        return entry;
    }

    public String getSearchBundleEntryUrl() {
        return this.getResourceInfo().getResourceType().name() + "?" + this.getResourceInfo().toConditionalUrl();
    }
}

