/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.bpe.plugin.ProcessPlugin;
import dev.dsf.bpe.plugin.ProcessPluginFactory;
import dev.dsf.bpe.plugin.ProcessPluginLoader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.env.ConfigurableEnvironment;

public class ProcessPluginLoaderImpl
implements ProcessPluginLoader,
InitializingBean {
    public static final String SNAPSHOT_FILE_SUFFIX = "-SNAPSHOT.jar";
    public static final String MILESTONE_FILE_PATTERN = ".*-M[0-9]+.jar";
    public static final String RELEASE_CANDIDATE_FILE_PATTERN = ".*-RC[0-9]+.jar";
    private static final Logger logger = LoggerFactory.getLogger(ProcessPluginLoaderImpl.class);
    private final Path pluginDirectory;
    private final List<ProcessPluginFactory<?>> processPluginFactories = new ArrayList();
    private final FhirContext fhirContext;
    private final ConfigurableEnvironment environment;

    public ProcessPluginLoaderImpl(Collection<? extends ProcessPluginFactory<?>> processPluginFactories, Path pluginDirectory, FhirContext fhirContext, ConfigurableEnvironment environment) {
        this.pluginDirectory = pluginDirectory;
        this.fhirContext = fhirContext;
        this.environment = environment;
        if (processPluginFactories != null) {
            this.processPluginFactories.addAll(processPluginFactories);
            this.processPluginFactories.sort(Comparator.comparingInt(ProcessPluginFactory::getApiVersion).reversed());
        }
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.pluginDirectory, "pluginDirectory");
        Objects.requireNonNull(this.fhirContext, "fhirContext");
        Objects.requireNonNull(this.environment, "environment");
    }

    @Override
    public List<ProcessPlugin<?, ?>> loadPlugins() {
        ArrayList arrayList;
        block8: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.pluginDirectory);
            try {
                ArrayList plugins = new ArrayList();
                directoryStream.forEach(p -> {
                    if (!Files.isReadable(p)) {
                        logger.warn("Ignoring {}: {}", (Object)p.toAbsolutePath().toString(), (Object)"Not readable");
                    } else if (!p.getFileName().toString().endsWith(".jar")) {
                        logger.warn("Ignoring {}: {}", (Object)p.toAbsolutePath().toString(), (Object)"Not a .jar file");
                    } else {
                        ProcessPlugin<?, ?> plugin = this.load((Path)p);
                        if (plugin != null) {
                            plugins.add(plugin);
                        }
                    }
                });
                arrayList = plugins;
                if (directoryStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.debug("Error loading process plugins", (Throwable)e);
                    logger.warn("Error loading process plugins: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                    throw new RuntimeException(e);
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    private ProcessPlugin<?, ?> load(Path jar) {
        for (ProcessPluginFactory<?> factory : this.processPluginFactories) {
            ProcessPlugin<?, ?> plugin = this.load(jar, factory);
            if (plugin == null) continue;
            return plugin;
        }
        logger.warn("Ignoring {}: No process plugin definition for API version{} {} found", new Object[]{jar.toString(), this.processPluginFactories.size() != 1 ? "s" : "", this.processPluginFactories.size() == 1 ? Integer.valueOf(this.processPluginFactories.get(0).getApiVersion()) : this.processPluginFactories.stream().map(f -> String.valueOf(f.getApiVersion())).collect(Collectors.joining(", ", "[", "]"))});
        return null;
    }

    private <D> ProcessPlugin<?, ?> load(Path jar, ProcessPluginFactory<D> factory) {
        try {
            URLClassLoader classLoader = new URLClassLoader(jar.getFileName().toString(), new URL[]{this.toUrl(jar)}, ClassLoader.getSystemClassLoader());
            List definitions = ServiceLoader.load(factory.getProcessPluginDefinitionType(), classLoader).stream().collect(Collectors.toList());
            if (definitions.size() != 1) {
                return null;
            }
            String filename = jar.getFileName().toString();
            boolean isSnapshot = filename.endsWith(SNAPSHOT_FILE_SUFFIX);
            boolean isMilestone = filename.matches(MILESTONE_FILE_PATTERN);
            boolean isReleaseCandidate = filename.matches(RELEASE_CANDIDATE_FILE_PATTERN);
            boolean draft = isSnapshot || isMilestone || isReleaseCandidate;
            return factory.createProcessPlugin(((ServiceLoader.Provider)definitions.get(0)).get(), draft, jar, classLoader, this.fhirContext, this.environment);
        }
        catch (Exception e) {
            logger.debug("Ignoring {}: Unable to load process plugin", (Object)jar.toString(), (Object)e);
            logger.warn("Ignoring {}: Unable to load process plugin: {} - {}", new Object[]{jar.toString(), e.getClass().getName(), e.getMessage()});
            return null;
        }
    }

    private URL toUrl(Path p) {
        try {
            return p.toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

