/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.bpe.dao.ProcessPluginResourcesDao;
import dev.dsf.bpe.plugin.FhirResourceHandler;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessState;
import dev.dsf.bpe.plugin.ProcessStateChangeOutcome;
import dev.dsf.bpe.plugin.ProcessesResource;
import dev.dsf.bpe.plugin.ResourceInfo;
import dev.dsf.fhir.client.BasicFhirWebserviceClient;
import dev.dsf.fhir.client.FhirWebserviceClient;
import dev.dsf.fhir.client.PreferReturnMinimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FhirResourceHandlerImpl
implements FhirResourceHandler,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(FhirResourceHandlerImpl.class);
    private final FhirWebserviceClient localWebserviceClient;
    private final ProcessPluginResourcesDao dao;
    private final FhirContext fhirContext;
    private final int fhirServerRequestMaxRetries;
    private final long fhirServerRetryDelayMillis;

    public FhirResourceHandlerImpl(FhirWebserviceClient localWebserviceClient, ProcessPluginResourcesDao dao, FhirContext fhirContext, int fhirServerRequestMaxRetries, long fhirServerRetryDelayMillis) {
        this.localWebserviceClient = localWebserviceClient;
        this.dao = dao;
        this.fhirContext = fhirContext;
        this.fhirServerRequestMaxRetries = fhirServerRequestMaxRetries;
        this.fhirServerRetryDelayMillis = fhirServerRetryDelayMillis;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.localWebserviceClient, "localWebserviceClient");
        Objects.requireNonNull(this.dao, "dao");
        Objects.requireNonNull(this.fhirContext, "fhirContext");
        if (this.fhirServerRequestMaxRetries < -1) {
            throw new IllegalArgumentException("fhirServerRequestMaxRetries < -1");
        }
        if (this.fhirServerRetryDelayMillis < 0L) {
            throw new IllegalArgumentException("fhirServerRetryDelayMillis < 0");
        }
    }

    private PreferReturnMinimal minimalReturnRetryClient() {
        if (this.fhirServerRequestMaxRetries == -1) {
            return (PreferReturnMinimal)this.localWebserviceClient.withMinimalReturn().withRetryForever(this.fhirServerRetryDelayMillis);
        }
        return (PreferReturnMinimal)this.localWebserviceClient.withMinimalReturn().withRetry(this.fhirServerRequestMaxRetries, this.fhirServerRetryDelayMillis);
    }

    private BasicFhirWebserviceClient retryClient() {
        if (this.fhirServerRequestMaxRetries == -1) {
            return (BasicFhirWebserviceClient)this.localWebserviceClient.withRetryForever(this.fhirServerRetryDelayMillis);
        }
        return (BasicFhirWebserviceClient)this.localWebserviceClient.withRetry(this.fhirServerRequestMaxRetries, this.fhirServerRetryDelayMillis);
    }

    @Override
    public void applyStateChangesAndStoreNewResourcesInDb(Map<ProcessIdAndVersion, List<Resource>> pluginResources, List<ProcessStateChangeOutcome> changes) {
        block6: {
            Objects.requireNonNull(pluginResources, "pluginResources");
            Objects.requireNonNull(changes, "changes");
            Map<ProcessIdAndVersion, List<ResourceInfo>> dbResourcesByProcess = this.getResourceInfosFromDb();
            HashMap<ResourceInfo, ProcessesResource> resources = new HashMap<ResourceInfo, ProcessesResource>();
            for (ProcessStateChangeOutcome change2 : changes) {
                Stream<ProcessesResource> currentOrOldProcessResources = this.getCurrentOrOldResources(pluginResources, dbResourcesByProcess, change2.getProcessKeyAndVersion());
                currentOrOldProcessResources.forEach(res -> {
                    resources.computeIfPresent(res.getResourceInfo(), (processInfo, processResource) -> {
                        processResource.addAll(res.getProcesses());
                        if (change2.getNewProcessState().isHigherPriority(processResource.getNewProcessState())) {
                            processResource.setNewProcessState(change2.getNewProcessState());
                        }
                        if (processResource.getResourceInfo().hasResourceId() && change2.getOldProcessState().isHigherPriority(processResource.getOldProcessState())) {
                            processResource.setOldProcessState(change2.getOldProcessState());
                        }
                        return processResource;
                    });
                    ProcessesResource nullIfNotNeededByOther = resources.putIfAbsent(res.getResourceInfo(), res.setNewProcessState(change2.getNewProcessState()).setOldProcessState(change2.getOldProcessState()));
                    if (nullIfNotNeededByOther == null && ProcessState.DRAFT.equals((Object)change2.getOldProcessState()) && ProcessState.DRAFT.equals((Object)change2.getNewProcessState()) && !res.getResourceInfo().hasResourceId()) {
                        logger.info("Adding new resource {}?{}", (Object)res.getResourceInfo().getResourceType(), (Object)res.getResourceInfo().toConditionalUrl());
                        res.setOldProcessState(ProcessState.NEW);
                    }
                });
            }
            this.addResourcesRemovedFromDraftProcess(changes, dbResourcesByProcess, resources);
            this.findMissingResourcesAndModifyOldState(resources.values());
            ArrayList<ProcessesResource> resourceValues = new ArrayList<ProcessesResource>(resources.values().stream().filter(ProcessesResource::hasStateChangeOrDraft).filter(ProcessesResource::notNewToExcludedChange).collect(Collectors.toList()));
            resourceValues.sort(Comparator.comparingInt(this::getSortIndex));
            Bundle batchBundle = new Bundle();
            batchBundle.setType(Bundle.BundleType.BATCH);
            List<Bundle.BundleEntryComponent> entries = resourceValues.stream().map(ProcessesResource::toBundleEntry).toList();
            batchBundle.setEntry(entries);
            try {
                if (batchBundle.getEntry().isEmpty()) {
                    logger.debug("No transaction bundle to execute");
                    break block6;
                }
                logger.debug("Executing process plugin resources bundle");
                logger.trace("Bundle: {}", (Object)this.fhirContext.newJsonParser().encodeResourceToString((IBaseResource)batchBundle));
                Bundle returnBundle = this.minimalReturnRetryClient().postBundle(batchBundle);
                List<UUID> deletedResourcesIds = this.addIdsAndReturnDeleted(resourceValues, returnBundle);
                List<ProcessIdAndVersion> excludedProcesses = changes.stream().filter(change -> ProcessState.EXCLUDED.equals((Object)change.getNewProcessState())).map(ProcessStateChangeOutcome::getProcessKeyAndVersion).collect(Collectors.toList());
                try {
                    this.dao.addOrRemoveResources(resources.values(), deletedResourcesIds, excludedProcesses);
                }
                catch (SQLException e) {
                    logger.debug("Error while adding process plugin resource to the db", (Throwable)e);
                    logger.warn("Error while adding process plugin resource to the db: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                    throw new RuntimeException(e);
                }
            }
            catch (Exception e) {
                logger.debug("Error while executing process plugins resource bundle", (Throwable)e);
                logger.warn("Error while executing process plugins resource bundle: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
                logger.warn("Resources in FHIR server may not be consistent, please check resources and execute the following bundle if necessary: {}", (Object)this.fhirContext.newJsonParser().encodeResourceToString((IBaseResource)batchBundle));
                throw e;
            }
        }
    }

    private int getSortIndex(ProcessesResource resource) {
        if (resource.getResource() == null) {
            return -1;
        }
        return switch (resource.getResource().getResourceType()) {
            case ResourceType.ActivityDefinition -> 7;
            case ResourceType.CodeSystem -> 1;
            case ResourceType.Library -> 4;
            case ResourceType.Measure -> 5;
            case ResourceType.NamingSystem -> 0;
            case ResourceType.Questionnaire -> 6;
            case ResourceType.StructureDefinition -> 3;
            case ResourceType.Task -> 8;
            case ResourceType.ValueSet -> 2;
            default -> throw new IllegalArgumentException("Unexpected value: " + resource.getResource().getResourceType());
        };
    }

    private void addResourcesRemovedFromDraftProcess(List<ProcessStateChangeOutcome> changes, Map<ProcessIdAndVersion, List<ResourceInfo>> dbResourcesByProcess, Map<ResourceInfo, ProcessesResource> resources) {
        for (ProcessStateChangeOutcome change : changes) {
            if (!ProcessState.DRAFT.equals((Object)change.getOldProcessState()) || !ProcessState.DRAFT.equals((Object)change.getNewProcessState())) continue;
            List<ResourceInfo> dbResources = dbResourcesByProcess.getOrDefault(change.getProcessKeyAndVersion(), Collections.emptyList());
            dbResources.forEach(dbRes -> {
                ProcessesResource processRes = ProcessesResource.from(dbRes);
                processRes.setOldProcessState(ProcessState.DRAFT);
                processRes.setNewProcessState(ProcessState.EXCLUDED);
                ProcessesResource nullIfNotNeededByOther = resources.putIfAbsent((ResourceInfo)dbRes, processRes);
                if (nullIfNotNeededByOther == null) {
                    logger.info("Deleting resource {}?{} with id {} if exists", new Object[]{dbRes.getResourceType(), dbRes.toConditionalUrl(), dbRes.getResourceId()});
                }
            });
        }
    }

    private void findMissingResourcesAndModifyOldState(Collection<ProcessesResource> resources) {
        List resourceValues = resources.stream().filter(ProcessesResource::shouldExist).collect(Collectors.toList());
        Bundle batchBundle = new Bundle();
        batchBundle.setType(Bundle.BundleType.BATCH);
        batchBundle.setEntry(resourceValues.stream().map(ProcessesResource::toSearchBundleEntryCount0).collect(Collectors.toList()));
        if (batchBundle.getEntry().isEmpty()) {
            return;
        }
        Bundle returnBundle = this.retryClient().postBundle(batchBundle);
        if (resourceValues.size() != returnBundle.getEntry().size()) {
            throw new RuntimeException("Return bundle size unexpected, expected " + resourceValues.size() + " got " + returnBundle.getEntry().size());
        }
        for (int i = 0; i < resourceValues.size(); ++i) {
            Bundle b;
            Resource resource;
            ProcessesResource resource2 = (ProcessesResource)resourceValues.get(i);
            Bundle.BundleEntryComponent entry = (Bundle.BundleEntryComponent)returnBundle.getEntry().get(i);
            if (!entry.getResponse().getStatus().startsWith("200")) {
                logger.warn("Response status for {} not 200 OK but {}, missing resource will not be added", (Object)resource2.getSearchBundleEntryUrl(), (Object)entry.getResponse().getStatus());
            } else if (!(entry.hasResource() && (resource = entry.getResource()) instanceof Bundle && Bundle.BundleType.SEARCHSET.equals((Object)(b = (Bundle)resource).getType()))) {
                logger.warn("Response for {} not a searchset Bundle, missing resource will not be added", (Object)resource2.getSearchBundleEntryUrl());
            }
            Bundle searchBundle = (Bundle)entry.getResource();
            if (searchBundle.getTotal() <= 0) {
                resource2.setOldProcessState(ProcessState.MISSING);
                logger.warn("Resource {} not found, setting old process state for resource to {}", (Object)resource2.getSearchBundleEntryUrl(), (Object)ProcessState.MISSING);
                continue;
            }
            logger.info("Resource {} found", (Object)resource2.getSearchBundleEntryUrl());
        }
    }

    private List<UUID> addIdsAndReturnDeleted(List<ProcessesResource> resourceValues, Bundle returnBundle) {
        if (resourceValues.size() != returnBundle.getEntry().size()) {
            throw new RuntimeException("Return bundle size unexpected, expected " + resourceValues.size() + " got " + returnBundle.getEntry().size());
        }
        ArrayList<UUID> deletedIds = new ArrayList<UUID>();
        for (int i = 0; i < resourceValues.size(); ++i) {
            ProcessesResource resource = resourceValues.get(i);
            Bundle.BundleEntryComponent entry = (Bundle.BundleEntryComponent)returnBundle.getEntry().get(i);
            List<String> expectedStatus = resource.getExpectedStatus();
            if (!expectedStatus.stream().anyMatch(eS -> entry.getResponse().getStatus().startsWith((String)eS))) {
                throw new RuntimeException("Return status " + entry.getResponse().getStatus() + " not starting with " + (expectedStatus.size() > 1 ? "one of " : "") + expectedStatus + " for resource " + resource.getResourceInfo().toString() + " of processes " + resource.getProcesses());
            }
            if (!ProcessState.EXCLUDED.equals((Object)resource.getNewProcessState())) {
                IdType id = new IdType(entry.getResponse().getLocation());
                if (!resource.getResourceInfo().getResourceType().equals((Object)ResourceType.fromCode((String)id.getResourceType()))) {
                    throw new RuntimeException("Return resource type unexpected, expected " + resource.getResourceInfo().getResourceType() + " got " + id.getResourceType());
                }
                resource.getResourceInfo().setResourceId(this.toUuid(id.getIdPart()));
                continue;
            }
            deletedIds.add(resource.getResourceInfo().getResourceId());
            resource.getResourceInfo().setResourceId(null);
        }
        return deletedIds;
    }

    private Stream<ProcessesResource> getCurrentOrOldResources(Map<ProcessIdAndVersion, List<Resource>> pluginResourcesByProcess, Map<ProcessIdAndVersion, List<ResourceInfo>> dbResourcesByProcess, ProcessIdAndVersion process) {
        List<Resource> pluginResources = pluginResourcesByProcess.get(process);
        if (pluginResources != null) {
            Stream<Resource> resources = this.getResources(process, pluginResourcesByProcess);
            return resources.map(fhirResource -> {
                ProcessesResource resource = ProcessesResource.from(fhirResource).add(process);
                Optional<UUID> resourceId = this.getResourceId(dbResourcesByProcess, process, resource.getResourceInfo());
                resourceId.ifPresent(id -> resource.getResourceInfo().setResourceId((UUID)id));
                return resource;
            });
        }
        List<ResourceInfo> resources = dbResourcesByProcess.get(process);
        if (resources == null) {
            logger.debug("No resources found in BPE DB for process {}", (Object)process);
            resources = Collections.emptyList();
        }
        return resources.stream().map(info -> ProcessesResource.from(info).add(process));
    }

    private Stream<Resource> getResources(ProcessIdAndVersion process, Map<ProcessIdAndVersion, List<Resource>> pluginResources) {
        List<Resource> resources = pluginResources.get(process);
        if (resources.isEmpty()) {
            logger.warn("No FHIR resources found for process {}", (Object)process.toString());
            return Stream.empty();
        }
        return resources.stream();
    }

    private Optional<UUID> getResourceId(Map<ProcessIdAndVersion, List<ResourceInfo>> dbResourcesByProcess, ProcessIdAndVersion process, ResourceInfo resourceInfo) {
        return dbResourcesByProcess.getOrDefault(process, Collections.emptyList()).stream().filter(r -> r.equals(resourceInfo)).findFirst().map(ResourceInfo::getResourceId);
    }

    private Map<ProcessIdAndVersion, List<ResourceInfo>> getResourceInfosFromDb() {
        try {
            return this.dao.getResources();
        }
        catch (SQLException e) {
            logger.debug("Error while retrieving resource infos from db", (Throwable)e);
            logger.warn("Error while retrieving resource infos from db: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private UUID toUuid(String id) {
        if (id == null) {
            return null;
        }
        try {
            return UUID.fromString(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

