/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.listener;

import dev.dsf.bpe.listener.AbstractListener;
import dev.dsf.bpe.listener.ListenerVariables;
import dev.dsf.bpe.v1.constants.CodeSystems;
import dev.dsf.fhir.client.FhirWebserviceClient;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndListener
extends AbstractListener
implements ExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(EndListener.class);
    private final FhirWebserviceClient webserviceClient;

    public EndListener(String serverBaseUrl, Function<DelegateExecution, ListenerVariables> variablesFactory, FhirWebserviceClient fhirWebserviceClient) {
        super(serverBaseUrl, variablesFactory);
        this.webserviceClient = fhirWebserviceClient;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.webserviceClient, "webserviceClient");
    }

    @Override
    public void doNotify(DelegateExecution execution, ListenerVariables variables) throws Exception {
        List tasks = variables.getCurrentTasks();
        for (int i = tasks.size() - 1; i >= 0; --i) {
            Task task = (Task)tasks.get(i);
            this.updateIfInprogress(task);
            boolean subProcess = execution.getParentId() != null && !execution.getParentId().equals(execution.getProcessInstanceId());
            this.logEnd(subProcess, task, subProcess ? variables.getStartTask() : null);
        }
        variables.onEnd();
    }

    private void updateIfInprogress(Task task) {
        if (Task.TaskStatus.INPROGRESS.equals((Object)task.getStatus())) {
            task.setStatus(Task.TaskStatus.COMPLETED);
            this.updateAndHandleException(task);
        } else {
            logger.debug("Not updating Task {} with status: {}", (Object)this.getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus());
        }
    }

    private void updateAndHandleException(Task task) {
        try {
            logger.debug("Updating Task {}, new status: {}", (Object)this.getLocalVersionlessAbsoluteUrl(task), (Object)task.getStatus().toCode());
            this.webserviceClient.withMinimalReturn().update((Resource)task);
        }
        catch (Exception e) {
            logger.debug("Unable to update Task {}", (Object)this.getLocalVersionlessAbsoluteUrl(task), (Object)e);
            logger.error("Unable to update Task {}: {} - {}", new Object[]{this.getLocalVersionlessAbsoluteUrl(task), e.getClass().getName(), e.getMessage()});
        }
    }

    private void logEnd(boolean subProcess, Task endTask, Task mainTask) {
        String processUrl = endTask.getInstantiatesCanonical();
        String businessKey = this.getFirstInputParameter(endTask, CodeSystems.BpmnMessage.businessKey());
        String correlationKey = this.getFirstInputParameter(endTask, CodeSystems.BpmnMessage.correlationKey());
        String endTaskUrl = this.getLocalVersionlessAbsoluteUrl(endTask);
        String requester = this.getRequesterIdentifierValue(endTask);
        String mainTaskUrl = this.getLocalVersionlessAbsoluteUrl(mainTask);
        if (subProcess) {
            if (correlationKey != null) {
                logger.info("Subprocess of {} finished at {} [task: {}, requester: {}, business-key: {}, correlation-key: {}, main-task: {}]", new Object[]{processUrl, this.getCurrentTime(), endTaskUrl, requester, businessKey, correlationKey, mainTaskUrl});
            } else {
                logger.info("Subprocess of {} finished at {} [task: {}, requester: {}, business-key: {}, main-task: {}]", new Object[]{processUrl, this.getCurrentTime(), endTaskUrl, requester, businessKey, mainTaskUrl});
            }
        } else if (correlationKey != null) {
            logger.info("Process {} finished at {} [task: {}, requester: {}, business-key: {}, correlation-key: {}]", new Object[]{processUrl, this.getCurrentTime(), endTaskUrl, requester, businessKey, correlationKey});
        } else {
            logger.info("Process {} finished at {} [task: {}, requester: {}, business-key: {}]", new Object[]{processUrl, this.getCurrentTime(), endTaskUrl, requester, businessKey});
        }
    }
}

