/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.listener;

import dev.dsf.bpe.listener.AbstractListener;
import dev.dsf.bpe.listener.ListenerVariables;
import dev.dsf.bpe.subscription.TaskHandler;
import dev.dsf.bpe.v1.constants.CodeSystems;
import java.util.function.Function;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinueListener
extends AbstractListener
implements ExecutionListener {
    private static final Logger logger = LoggerFactory.getLogger(ContinueListener.class);

    public ContinueListener(String serverBaseUrl, Function<DelegateExecution, ListenerVariables> variablesFactory) {
        super(serverBaseUrl, variablesFactory);
    }

    @Override
    public void doNotify(DelegateExecution execution, ListenerVariables variables) throws Exception {
        Task task = (Task)variables.getResource(TaskHandler.TASK_VARIABLE);
        execution.removeVariable(TaskHandler.TASK_VARIABLE);
        if (task != null) {
            variables.onContinue(task);
            boolean subProcess = execution.getParentId() != null && !execution.getParentId().equals(execution.getProcessInstanceId());
            this.logContinue(logger, subProcess, task, subProcess ? variables.getStartTask() : null);
        } else {
            logger.warn("Variable 'task' null, not updating tasks");
        }
    }

    private void logContinue(Logger logger, boolean subProcess, Task continueTask, Task mainTask) {
        String processUrl = continueTask.getInstantiatesCanonical();
        String messageName = this.getFirstInputParameter(continueTask, CodeSystems.BpmnMessage.messageName());
        String businessKey = this.getFirstInputParameter(continueTask, CodeSystems.BpmnMessage.businessKey());
        String correlationKey = this.getFirstInputParameter(continueTask, CodeSystems.BpmnMessage.correlationKey());
        String continueTaskUrl = this.getLocalVersionlessAbsoluteUrl(continueTask);
        String requester = this.getRequesterIdentifierValue(continueTask);
        String mainTaskUrl = this.getLocalVersionlessAbsoluteUrl(mainTask);
        if (subProcess) {
            if (correlationKey != null) {
                logger.info("Continuing subprocess of {} at {} [task: {}, requester: {}, business-key: {}, correlation-key: {}, message: {}, main-task: {}]", new Object[]{processUrl, this.getCurrentTime(), continueTaskUrl, requester, businessKey, correlationKey, messageName, mainTaskUrl});
            } else {
                logger.info("Continuing subprocess of {} at {} [task: {}, requester: {}, business-key: {}, message: {}, main-task: {}]", new Object[]{processUrl, this.getCurrentTime(), continueTaskUrl, requester, businessKey, messageName, mainTaskUrl});
            }
        } else if (correlationKey != null) {
            logger.info("Continuing process {} at {} [task: {}, requester: {}, business-key: {}, correlation-key: {}, message: {}]", new Object[]{processUrl, this.getCurrentTime(), continueTaskUrl, requester, businessKey, correlationKey, messageName});
        } else {
            logger.info("Continuing process {} at {} [task: {}, requester: {}, business-key: {}, message: {}]", new Object[]{processUrl, this.getCurrentTime(), continueTaskUrl, requester, businessKey, messageName});
        }
    }
}

