/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.webservice;

import dev.dsf.bpe.ui.ThymeleafTemplateService;
import dev.dsf.common.auth.conf.Identity;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.StreamingOutput;
import java.security.Principal;
import java.util.Objects;
import java.util.function.Consumer;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractService
implements InitializingBean {
    @Context
    private volatile SecurityContext securityContext;
    private final ThymeleafTemplateService templateService;
    private final String htmlFragment;

    public AbstractService(ThymeleafTemplateService templateService, String htmlFragment) {
        this.templateService = templateService;
        this.htmlFragment = htmlFragment;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.templateService, "templateService");
        Objects.requireNonNull(this.htmlFragment, "htmlFragment");
    }

    protected StreamingOutput write(String title, String heading, Consumer<org.thymeleaf.context.Context> setValues) {
        String string;
        org.thymeleaf.context.Context context = new org.thymeleaf.context.Context();
        setValues.accept(context);
        Principal principal = this.securityContext.getUserPrincipal();
        if (principal instanceof Identity) {
            Identity i = (Identity)principal;
            string = i.getDisplayName();
        } else {
            string = null;
        }
        ThymeleafTemplateService.MainValues mainValues = new ThymeleafTemplateService.MainValues(title, heading, this.htmlFragment, string, "OPENID".equals(this.securityContext.getAuthenticationScheme()));
        return this.templateService.write(context, mainValues);
    }
}

