/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.dsf.bpe.v1.variables.Targets;
import dev.dsf.bpe.variables.TargetsImpl;
import dev.dsf.bpe.variables.TargetsValues;
import java.io.IOException;
import java.util.Objects;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.springframework.beans.factory.InitializingBean;

public class TargetsSerializer
extends PrimitiveValueSerializer<TargetsValues.TargetsValue>
implements InitializingBean {
    private final ObjectMapper objectMapper;

    public TargetsSerializer(ObjectMapper objectMapper) {
        super(TargetsValues.VALUE_TYPE);
        this.objectMapper = objectMapper;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.objectMapper, "objectMapper");
    }

    public void writeValue(TargetsValues.TargetsValue value, ValueFields valueFields) {
        Targets targets = (Targets)value.getValue();
        try {
            if (targets != null) {
                valueFields.setByteArrayValue(this.objectMapper.writeValueAsBytes((Object)targets));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public TargetsValues.TargetsValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return TargetsValues.create((TargetsImpl)untypedValue.getValue());
    }

    public TargetsValues.TargetsValue readValue(ValueFields valueFields, boolean asTransientValue) {
        byte[] bytes = valueFields.getByteArrayValue();
        try {
            TargetsImpl targets = bytes == null || bytes.length <= 0 ? null : (TargetsImpl)this.objectMapper.readValue(bytes, TargetsImpl.class);
            return TargetsValues.create(targets);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

