/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.dsf.bpe.v1.variables.Target;
import dev.dsf.bpe.v1.variables.Targets;
import dev.dsf.bpe.variables.TargetImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class TargetsImpl
implements Targets {
    private final List<TargetImpl> entries = new ArrayList<TargetImpl>();

    @JsonCreator
    public TargetsImpl(@JsonProperty(value="entries") List<? extends TargetImpl> targets) {
        if (targets != null) {
            this.entries.addAll(targets);
        }
    }

    @JsonProperty(value="entries")
    public List<Target> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public Targets removeByEndpointIdentifierValue(Target target) {
        if (target == null) {
            return new TargetsImpl(this.entries);
        }
        return this.removeByEndpointIdentifierValue(target.getEndpointIdentifierValue());
    }

    public Targets removeByEndpointIdentifierValue(String targetEndpointIdentifierValue) {
        if (targetEndpointIdentifierValue == null) {
            return new TargetsImpl(this.entries);
        }
        return new TargetsImpl(this.entries.stream().filter(t -> !targetEndpointIdentifierValue.equals(t.getEndpointIdentifierValue())).collect(Collectors.toList()));
    }

    public Targets removeAllByEndpointIdentifierValue(Collection<String> targetEndpointIdentifierValues) {
        if (targetEndpointIdentifierValues == null || targetEndpointIdentifierValues.isEmpty()) {
            return new TargetsImpl(this.entries);
        }
        return new TargetsImpl(this.entries.stream().filter(t -> !targetEndpointIdentifierValues.contains(t.getEndpointIdentifierValue())).collect(Collectors.toList()));
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public String toString() {
        return "TargetsImpl [entries=" + this.entries + "]";
    }
}

