/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import com.fasterxml.jackson.databind.ObjectMapper;
import dev.dsf.bpe.variables.FhirResourcesList;
import dev.dsf.bpe.variables.FhirResourcesListValues;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import org.camunda.bpm.engine.impl.variable.serializer.PrimitiveValueSerializer;
import org.camunda.bpm.engine.impl.variable.serializer.ValueFields;
import org.camunda.bpm.engine.variable.impl.value.UntypedValueImpl;
import org.springframework.beans.factory.InitializingBean;

public class FhirResourcesListSerializer
extends PrimitiveValueSerializer<FhirResourcesListValues.FhirResourcesListValue>
implements InitializingBean {
    private final ObjectMapper objectMapper;

    public FhirResourcesListSerializer(ObjectMapper objectMapper) {
        super(FhirResourcesListValues.VALUE_TYPE);
        this.objectMapper = objectMapper;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.objectMapper, "objectMapper");
    }

    public void writeValue(FhirResourcesListValues.FhirResourcesListValue value, ValueFields valueFields) {
        FhirResourcesList resource = (FhirResourcesList)value.getValue();
        try {
            if (resource != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                this.objectMapper.writeValue((OutputStream)out, (Object)resource);
                valueFields.setTextValue(resource.getClass().getName());
                valueFields.setByteArrayValue(out.toByteArray());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public FhirResourcesListValues.FhirResourcesListValue convertToTypedValue(UntypedValueImpl untypedValue) {
        return FhirResourcesListValues.create((FhirResourcesList)untypedValue.getValue());
    }

    public FhirResourcesListValues.FhirResourcesListValue readValue(ValueFields valueFields, boolean asTransientValue) {
        String className = valueFields.getTextValue();
        byte[] bytes = valueFields.getByteArrayValue();
        try {
            Class<?> clazz = Class.forName(className);
            FhirResourcesList resource = (FhirResourcesList)this.objectMapper.readValue(bytes, clazz);
            return FhirResourcesListValues.create(resource);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

