/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Resource;

public class FhirResourcesList {
    private final List<Resource> resources = new ArrayList<Resource>();

    @JsonCreator
    public FhirResourcesList(@JsonProperty(value="resources") Collection<? extends Resource> resources) {
        if (resources != null) {
            this.resources.addAll(resources);
        }
    }

    public FhirResourcesList(Resource ... resources) {
        this(Arrays.asList(resources));
    }

    @JsonProperty(value="resources")
    public List<Resource> getResources() {
        return Collections.unmodifiableList(this.resources);
    }

    @JsonIgnore
    public <R extends Resource> List<R> getResourcesAndCast() {
        return this.getResources();
    }

    public String toString() {
        return "FhirResourcesList" + this.resources.stream().map(r -> r.getIdElement().toUnqualified().getValue()).collect(Collectors.joining(", ", "[", "]"));
    }
}

