/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Objects;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Resource;

public class FhirResourceJacksonSerializer
extends JsonSerializer<Resource> {
    private final FhirContext fhirContext;

    public FhirResourceJacksonSerializer(FhirContext fhirContext) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext");
    }

    public void serialize(Resource value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        String text = this.newJsonParser().encodeResourceToString((IBaseResource)value);
        jgen.writeRawValue(text);
    }

    private IParser newJsonParser() {
        IParser p = this.fhirContext.newJsonParser();
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        return p;
    }
}

