/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Objects;
import org.hl7.fhir.r4.model.Resource;

public class FhirResourceJacksonDeserializer
extends JsonDeserializer<Resource> {
    private final FhirContext fhirContext;

    public FhirResourceJacksonDeserializer(FhirContext fhirContext) {
        this.fhirContext = Objects.requireNonNull(fhirContext, "fhirContext");
    }

    public Resource deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String string = p.readValueAsTree().toString();
        return (Resource)this.newJsonParser().parseResource(string);
    }

    private IParser newJsonParser() {
        IParser p = this.fhirContext.newJsonParser();
        p.setStripVersionsFromReferences(Boolean.valueOf(false));
        p.setOverrideResourceIdWithBundleEntryFullUrl(Boolean.valueOf(false));
        return p;
    }
}

