/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import dev.dsf.bpe.v1.service.TaskHelper;
import java.util.Objects;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.Type;

public class TaskHelperImpl
implements TaskHelper {
    private final String serverBaseUrl;

    public TaskHelperImpl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    public String getLocalVersionlessAbsoluteUrl(Task task) {
        if (task == null) {
            return null;
        }
        return task.getIdElement().toVersionless().withServerBase(this.serverBaseUrl, ResourceType.Task.name()).getValue();
    }

    public Stream<String> getInputParameterStringValues(Task task, Coding coding) {
        return this.getInputParameterValues(task, coding, StringType.class).map(PrimitiveType::getValue);
    }

    public Stream<String> getInputParameterStringValues(Task task, String system, String code) {
        return this.getInputParameterValues(task, system, code, StringType.class).map(PrimitiveType::getValue);
    }

    public <T extends Type> Stream<T> getInputParameterValues(Task task, Coding coding, Class<T> expectedType) {
        return this.getInputParameters(task, coding, expectedType).filter(Task.ParameterComponent::hasValue).map(c -> (Type)expectedType.cast(c.getValue()));
    }

    public <T extends Type> Stream<T> getInputParameterValues(Task task, String system, String code, Class<T> expectedType) {
        return this.getInputParameters(task, system, code, expectedType).filter(Task.ParameterComponent::hasValue).map(c -> (Type)expectedType.cast(c.getValue()));
    }

    public Stream<Task.ParameterComponent> getInputParametersWithExtension(Task task, Coding coding, Class<? extends Type> expectedType, String extensionUrl) {
        return this.getInputParameters(task, coding, expectedType).filter(Element::hasExtension).filter(c -> c.getExtension().stream().anyMatch(e -> Objects.equals(extensionUrl, e.getUrl())));
    }

    public Stream<Task.ParameterComponent> getInputParametersWithExtension(Task task, String system, String code, Class<? extends Type> expectedType, String extensionUrl) {
        return this.getInputParameters(task, system, code, expectedType).filter(Element::hasExtension).filter(c -> c.getExtension().stream().anyMatch(e -> Objects.equals(extensionUrl, e.getUrl())));
    }

    public Stream<Task.ParameterComponent> getInputParameters(Task task, Coding coding, Class<? extends Type> expectedType) {
        if (coding == null) {
            return Stream.empty();
        }
        return this.getInputParameters(task, coding.getSystem(), coding.getCode(), expectedType);
    }

    public Stream<Task.ParameterComponent> getInputParameters(Task task, String system, String code, Class<? extends Type> expectedType) {
        Objects.requireNonNull(expectedType, "expectedType");
        if (task == null) {
            return Stream.empty();
        }
        return task.getInput().stream().filter(c -> c.hasType() && c.getType().hasCoding()).filter(c -> c.getType().getCoding().stream().anyMatch(co -> Objects.equals(system, co.getSystem()) && Objects.equals(code, co.getCode()))).filter(c -> c.hasValue() && expectedType.isInstance(c.getValue()));
    }

    public Task.ParameterComponent createInput(Type value, Coding coding) {
        return new Task.ParameterComponent(new CodeableConcept(coding), value);
    }

    public Task.ParameterComponent createInput(Type value, String system, String code) {
        return this.createInput(value, new Coding(system, code, null));
    }

    public Task.TaskOutputComponent createOutput(Type value, Coding coding) {
        return new Task.TaskOutputComponent(new CodeableConcept(coding), value);
    }

    public Task.TaskOutputComponent createOutput(Type value, String system, String code) {
        return this.createOutput(value, new Coding(system, code, null));
    }
}

