/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import dev.dsf.bpe.v1.service.QuestionnaireResponseHelper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DecimalType;
import org.hl7.fhir.r4.model.IntegerType;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UriType;

public class QuestionnaireResponseHelperImpl
implements QuestionnaireResponseHelper {
    private final String serverBaseUrl;

    public QuestionnaireResponseHelperImpl(String serverBaseUrl) {
        this.serverBaseUrl = serverBaseUrl;
    }

    public Stream<QuestionnaireResponse.QuestionnaireResponseItemComponent> getItemLeavesMatchingLinkIdAsStream(QuestionnaireResponse questionnaireResponse, String linkId) {
        return this.getItemLeavesAsStream(questionnaireResponse).filter(i -> linkId.equals(i.getLinkId()));
    }

    public Stream<QuestionnaireResponse.QuestionnaireResponseItemComponent> getItemLeavesAsStream(QuestionnaireResponse questionnaireResponse) {
        return this.flatItems(questionnaireResponse.getItem());
    }

    private Stream<QuestionnaireResponse.QuestionnaireResponseItemComponent> flatItems(List<QuestionnaireResponse.QuestionnaireResponseItemComponent> toFlat) {
        return toFlat.stream().flatMap(this::leaves);
    }

    private Stream<QuestionnaireResponse.QuestionnaireResponseItemComponent> leaves(QuestionnaireResponse.QuestionnaireResponseItemComponent component) {
        if (component.getItem().size() > 0) {
            return component.getItem().stream().flatMap(this::leaves);
        }
        return Stream.of(component);
    }

    public void addItemLeafWithAnswer(QuestionnaireResponse questionnaireResponse, String linkId, String text, Type answer) {
        List<QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent> answerComponent = Collections.singletonList(new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent().setValue(answer));
        questionnaireResponse.addItem().setLinkId(linkId).setText(text).setAnswer(answerComponent);
    }

    public void addItemLeafWithoutAnswer(QuestionnaireResponse questionnaireResponse, String linkId, String text) {
        questionnaireResponse.addItem().setLinkId(linkId).setText(text);
    }

    public Type transformQuestionTypeToAnswerType(Questionnaire.QuestionnaireItemComponent question) {
        return switch (question.getType()) {
            case Questionnaire.QuestionnaireItemType.STRING, Questionnaire.QuestionnaireItemType.TEXT -> new StringType("Placeholder..");
            case Questionnaire.QuestionnaireItemType.INTEGER -> new IntegerType(0);
            case Questionnaire.QuestionnaireItemType.DECIMAL -> new DecimalType(0.0);
            case Questionnaire.QuestionnaireItemType.BOOLEAN -> new BooleanType(false);
            case Questionnaire.QuestionnaireItemType.DATE -> new DateType("1900-01-01");
            case Questionnaire.QuestionnaireItemType.TIME -> new TimeType("00:00:00");
            case Questionnaire.QuestionnaireItemType.DATETIME -> new DateTimeType("1900-01-01T00:00:00.000Z");
            case Questionnaire.QuestionnaireItemType.URL -> new UriType("http://example.org/foo");
            case Questionnaire.QuestionnaireItemType.REFERENCE -> new Reference("http://example.org/fhir/Placeholder/id");
            default -> throw new RuntimeException("Type '" + question.getType().getDisplay() + "' in Questionnaire.item is not supported as answer type");
        };
    }

    public String getLocalVersionlessAbsoluteUrl(QuestionnaireResponse questionnaireResponse) {
        return questionnaireResponse.getIdElement().toVersionless().withServerBase(this.serverBaseUrl, ResourceType.Task.name()).getValue();
    }
}

