/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import dev.dsf.bpe.v1.service.FhirWebserviceClientProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractResourceProvider
implements InitializingBean {
    protected final FhirWebserviceClientProvider clientProvider;
    protected final String localEndpointAddress;

    public AbstractResourceProvider(FhirWebserviceClientProvider clientProvider, String localEndpointAddress) {
        this.clientProvider = clientProvider;
        this.localEndpointAddress = localEndpointAddress;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.clientProvider, "clientProvider");
        Objects.requireNonNull(this.localEndpointAddress, "localEndpointAddress");
    }

    protected final String toSearchParameter(Identifier identifier) {
        return (String)(identifier.hasSystem() ? identifier.getSystem() + "|" : "") + identifier.getValue();
    }

    protected final String toSearchParameter(Coding coding) {
        return (String)(coding.hasSystem() ? coding.getSystem() + "|" : "") + coding.getCode();
    }

    protected final <R extends Resource> List<R> search(Class<? extends Resource> searchType, Map<String, List<String>> searchParameters, Bundle.SearchEntryMode targetMode, Class<R> targetType, Predicate<R> filter) {
        ArrayList<Resource> organizations = new ArrayList<Resource>();
        boolean hasMore = true;
        int page = 1;
        while (hasMore) {
            Bundle resultBundle = this.search(searchType, searchParameters, page++);
            organizations.addAll(resultBundle.getEntry().stream().filter(Bundle.BundleEntryComponent::hasSearch).filter(e -> targetMode.equals((Object)e.getSearch().getMode())).filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).filter(targetType::isInstance).map(targetType::cast).filter(filter).toList());
            hasMore = resultBundle.getLink("next") != null;
        }
        return organizations;
    }

    private Bundle search(Class<? extends Resource> searchType, Map<String, List<String>> parameters, int page) {
        HashMap<String, List<String>> parametersAndPage = new HashMap<String, List<String>>(parameters);
        parametersAndPage.put("_page", Collections.singletonList(String.valueOf(page)));
        if (!parameters.containsKey("_sort")) {
            parametersAndPage.put("_sort", Collections.singletonList("_id"));
        }
        return this.clientProvider.getLocalWebserviceClient().searchWithStrictHandling(searchType, parametersAndPage);
    }
}

