/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import dev.dsf.bpe.dao.LastEventTimeDao;
import dev.dsf.bpe.subscription.EventResourceHandler;
import dev.dsf.bpe.subscription.EventResourceHandlerImpl;
import dev.dsf.bpe.subscription.ExistingResourceLoader;
import dev.dsf.bpe.subscription.ExistingResourceLoaderImpl;
import dev.dsf.bpe.subscription.PingEventResourceHandler;
import dev.dsf.bpe.subscription.PingEventResourceHandlerImpl;
import dev.dsf.bpe.subscription.ResourceHandler;
import dev.dsf.bpe.subscription.SubscriptionHandlerFactory;
import dev.dsf.fhir.client.FhirWebserviceClient;
import java.util.Objects;
import org.hl7.fhir.r4.model.Task;
import org.springframework.beans.factory.InitializingBean;

public class TaskSubscriptionHandlerFactory
implements SubscriptionHandlerFactory<Task>,
InitializingBean {
    private final ResourceHandler<Task> resourceHandler;
    private final LastEventTimeDao lastEventTimeDao;

    public TaskSubscriptionHandlerFactory(ResourceHandler<Task> resourceHandler, LastEventTimeDao lastEventTimeDao) {
        this.resourceHandler = resourceHandler;
        this.lastEventTimeDao = lastEventTimeDao;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.resourceHandler, "resourceHandler");
        Objects.requireNonNull(this.lastEventTimeDao, "lastEventTimeDao");
    }

    @Override
    public ExistingResourceLoader<Task> createExistingResourceLoader(FhirWebserviceClient client) {
        return new ExistingResourceLoaderImpl<Task>(this.lastEventTimeDao, this.resourceHandler, client, "Task", Task.class);
    }

    @Override
    public EventResourceHandler<Task> createEventResourceHandler() {
        return new EventResourceHandlerImpl<Task>(this.lastEventTimeDao, this.resourceHandler, Task.class);
    }

    @Override
    public PingEventResourceHandler<Task> createPingEventResourceHandler(ExistingResourceLoader<Task> existingResourceLoader) {
        return new PingEventResourceHandlerImpl<Task>(existingResourceLoader);
    }
}

