/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import dev.dsf.bpe.dao.LastEventTimeDao;
import dev.dsf.bpe.subscription.ExistingResourceLoader;
import dev.dsf.bpe.subscription.ResourceHandler;
import dev.dsf.fhir.client.FhirWebserviceClient;
import jakarta.ws.rs.core.UriBuilder;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExistingResourceLoaderImpl<R extends Resource>
implements ExistingResourceLoader<R> {
    private static final Logger logger = LoggerFactory.getLogger(ExistingResourceLoaderImpl.class);
    private static final String PARAM_LAST_UPDATED = "_lastUpdated";
    private static final String PARAM_COUNT = "_count";
    private static final String PARAM_PAGE = "_page";
    private static final String PARAM_SORT = "_sort";
    private static final int RESULT_PAGE_COUNT = 20;
    private final LastEventTimeDao lastEventTimeDao;
    private final FhirWebserviceClient webserviceClient;
    private final ResourceHandler<R> handler;
    private final String resourceName;
    private final Class<R> resourceClass;

    public ExistingResourceLoaderImpl(LastEventTimeDao lastEventTimeDao, ResourceHandler<R> handler, FhirWebserviceClient webserviceClient, String resourceName, Class<R> resourceClass) {
        this.lastEventTimeDao = lastEventTimeDao;
        this.handler = handler;
        this.webserviceClient = webserviceClient;
        this.resourceName = resourceName;
        this.resourceClass = resourceClass;
    }

    @Override
    public void readExistingResources(Map<String, List<String>> searchCriteriaQueryParameters) {
        while (this.doReadExistingResources(searchCriteriaQueryParameters)) {
        }
    }

    private boolean doReadExistingResources(Map<String, List<String>> searchCriteriaQueryParameters) {
        HashMap<String, List<String>> queryParams = new HashMap<String, List<String>>(searchCriteriaQueryParameters);
        Optional<LocalDateTime> readLastEventTime = this.readLastEventTime();
        readLastEventTime.ifPresent(lastEventTime -> queryParams.put(PARAM_LAST_UPDATED, Collections.singletonList("gt" + lastEventTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME))));
        queryParams.put(PARAM_COUNT, Collections.singletonList(String.valueOf(20)));
        queryParams.put(PARAM_PAGE, Collections.singletonList("1"));
        queryParams.put(PARAM_SORT, Collections.singletonList(PARAM_LAST_UPDATED));
        UriBuilder builder = UriBuilder.fromPath((String)this.resourceName);
        queryParams.forEach((k, v) -> builder.replaceQueryParam(k, v.toArray()));
        logger.debug("Executing search {}", (Object)builder.toString());
        Bundle bundle = this.webserviceClient.searchWithStrictHandling(this.resourceClass, queryParams);
        if (bundle.getTotal() <= 0) {
            logger.debug("Result bundle.total <= 0");
            return false;
        }
        for (Bundle.BundleEntryComponent entry : bundle.getEntry()) {
            if (entry.hasResource()) {
                if (this.resourceClass.isInstance(entry.getResource())) {
                    Resource resource = entry.getResource();
                    this.handler.onResource(resource);
                    this.writeLastEventTime(resource.getMeta().getLastUpdated());
                    continue;
                }
                logger.warn("Ignoring resource of type {}", (Object)entry.getResource().getClass().getAnnotation(ResourceDef.class).name());
                continue;
            }
            logger.warn("Bundle entry did not contain resource");
        }
        return true;
    }

    private Optional<LocalDateTime> readLastEventTime() {
        try {
            return this.lastEventTimeDao.readLastEventTime();
        }
        catch (SQLException e) {
            logger.debug("Unable to read last event time from db", (Throwable)e);
            logger.warn("Unable to read last event time from db: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private void writeLastEventTime(Date lastUpdated) {
        try {
            this.lastEventTimeDao.writeLastEventTime(lastUpdated);
        }
        catch (SQLException e) {
            logger.debug("Unable to write last event time to db", (Throwable)e);
            logger.warn("Unable to write last event time to db: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

