/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.mail;

import dev.dsf.bpe.v1.service.MailService;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.function.Consumer;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingMailService
implements MailService {
    private static final Logger logger = LoggerFactory.getLogger(LoggingMailService.class);
    private static final Logger mailLogger = LoggerFactory.getLogger((String)"mail-logger");

    private MimeMessage createMimeMessage(String subject, MimeBodyPart body) {
        try {
            MimeMessage mimeMessage = new MimeMessage(Session.getInstance((Properties)new Properties()));
            mimeMessage.setSubject(subject);
            mimeMessage.setContent((Multipart)new MimeMultipart(new BodyPart[]{body}));
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void send(String subject, MimeBodyPart body, Consumer<MimeMessage> messageModifier) {
        logger.info("SMTP mail service not configured, see debug log for mail subject / content");
        try {
            if (logger.isDebugEnabled() || mailLogger.isInfoEnabled()) {
                MimeMessage message = this.createMimeMessage(subject, body);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                message.writeTo((OutputStream)out);
                logger.debug("Subject: {}, Content: {}", (Object)subject, (Object)out.toString());
                mailLogger.info("Subject: {}, Content: {}", (Object)subject, (Object)out.toString());
            }
        }
        catch (IOException | MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

