/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.listener;

import dev.dsf.bpe.listener.ContinueListener;
import dev.dsf.bpe.listener.EndListener;
import dev.dsf.bpe.listener.StartListener;
import java.util.Objects;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultBpmnParseListener
extends AbstractBpmnParseListener
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DefaultBpmnParseListener.class);
    private final StartListener startListener;
    private final EndListener endListener;
    private final ContinueListener continueListener;

    public DefaultBpmnParseListener(StartListener startListener, EndListener endListener, ContinueListener continueListener) {
        this.startListener = startListener;
        this.endListener = endListener;
        this.continueListener = continueListener;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.startListener, "startListener");
        Objects.requireNonNull(this.endListener, "endListener");
        Objects.requireNonNull(this.continueListener, "continueListener");
    }

    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl startEventActivity) {
        Element messageEventDefinition = startEventElement.element("messageEventDefinition");
        if (messageEventDefinition != null) {
            startEventActivity.addListener("start", (DelegateListener)this.startListener);
        } else {
            logger.debug("Not adding Listener to StartEvent {}", (Object)startEventActivity.getId());
        }
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl endEventActivity) {
        endEventActivity.addListener("end", (DelegateListener)this.endListener, 0);
    }

    public void parseIntermediateMessageCatchEventDefinition(Element messageEventDefinition, ActivityImpl nestedActivity) {
        nestedActivity.addListener("end", (DelegateListener)this.continueListener, 0);
    }

    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        activity.addListener("end", (DelegateListener)this.continueListener, 0);
    }
}

