/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.listener;

import dev.dsf.bpe.listener.ListenerVariables;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.function.Function;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Task;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractListener
implements ExecutionListener,
InitializingBean {
    private final String serverBaseUrl;
    private final Function<DelegateExecution, ListenerVariables> variablesFactory;

    public AbstractListener(String serverBaseUrl, Function<DelegateExecution, ListenerVariables> variablesFactory) {
        this.serverBaseUrl = serverBaseUrl;
        this.variablesFactory = variablesFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.serverBaseUrl, "serverBaseUrl");
        Objects.requireNonNull(this.variablesFactory, "variablesFactory");
    }

    public final void notify(DelegateExecution execution) throws Exception {
        this.doNotify(execution, this.variablesFactory.apply(execution));
    }

    protected abstract void doNotify(DelegateExecution var1, ListenerVariables var2) throws Exception;

    protected final String getLocalVersionlessAbsoluteUrl(Task task) {
        return task == null ? null : task.getIdElement().toVersionless().withServerBase(this.serverBaseUrl, ResourceType.Task.name()).getValue();
    }

    protected final String getFirstInputParameter(Task task, Coding code) {
        if (task == null || code == null) {
            return null;
        }
        return task.getInput().stream().filter(Task.ParameterComponent::hasType).filter(c -> c.getType().getCoding().stream().anyMatch(co -> co != null && Objects.equals(code.getSystem(), co.getSystem()) && Objects.equals(code.getCode(), co.getCode()))).filter(Task.ParameterComponent::hasValue).map(Task.ParameterComponent::getValue).filter(v -> v instanceof StringType).map(v -> (StringType)v).map(PrimitiveType::getValue).findFirst().orElse(null);
    }

    protected final String getCurrentTime() {
        return ZonedDateTime.now().truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    protected final String getRequesterIdentifierValue(Task task) {
        if (task == null) {
            return null;
        }
        return task.getRequester().getIdentifier().getValue();
    }
}

