/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.camunda;

import dev.dsf.bpe.camunda.DelegateProvider;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import java.util.List;
import org.camunda.bpm.engine.ProcessEngineException;
import org.camunda.bpm.engine.delegate.DelegateTask;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.ProcessEngineLogger;
import org.camunda.bpm.engine.impl.bpmn.parser.FieldDeclaration;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.delegate.DelegateInvocation;
import org.camunda.bpm.engine.impl.persistence.entity.TaskEntity;
import org.camunda.bpm.engine.impl.task.delegate.TaskListenerInvocation;
import org.camunda.bpm.engine.impl.task.listener.ClassDelegateTaskListener;
import org.camunda.bpm.engine.impl.util.ClassDelegateUtil;

public class MultiVersionClassDelegateTaskListener
extends ClassDelegateTaskListener {
    private final DelegateProvider delegateProvider;

    public MultiVersionClassDelegateTaskListener(String className, List<FieldDeclaration> fieldDeclarations, DelegateProvider delegateProvider) {
        super(className, fieldDeclarations);
        this.delegateProvider = delegateProvider;
    }

    public void notify(DelegateTask delegateTask) {
        TaskEntity te = (TaskEntity)delegateTask;
        ProcessIdAndVersion processKeyAndVersion = new ProcessIdAndVersion(te.getProcessDefinition().getKey(), te.getProcessDefinition().getVersionTag());
        TaskListener taskListenerInstance = this.getTaskListenerInstance(processKeyAndVersion);
        try {
            Context.getProcessEngineConfiguration().getDelegateInterceptor().handleInvocation((DelegateInvocation)new TaskListenerInvocation(taskListenerInstance, delegateTask));
        }
        catch (Exception e) {
            throw new ProcessEngineException("Exception while invoking TaskListener: " + e.getMessage(), (Throwable)e);
        }
    }

    protected TaskListener getTaskListenerInstance(ProcessIdAndVersion processKeyAndVersion) {
        Object delegateInstance = this.instantiateDelegate(processKeyAndVersion, this.className, this.fieldDeclarations);
        if (delegateInstance instanceof TaskListener) {
            TaskListener l = (TaskListener)delegateInstance;
            return l;
        }
        throw new ProcessEngineException(delegateInstance.getClass().getName() + " doesn't implement " + TaskListener.class);
    }

    private Object instantiateDelegate(ProcessIdAndVersion processKeyAndVersion, String className, List<FieldDeclaration> fieldDeclarations) {
        try {
            Class<?> clazz = this.delegateProvider.getClassLoader(processKeyAndVersion).loadClass(className);
            Object bean = this.delegateProvider.getApplicationContext(processKeyAndVersion).getBean(clazz);
            ClassDelegateUtil.applyFieldDeclaration(fieldDeclarations, (Object)bean);
            return bean;
        }
        catch (Exception e) {
            throw ProcessEngineLogger.UTIL_LOGGER.exceptionWhileInstantiatingClass(className, e);
        }
    }
}

