/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.camunda;

import dev.dsf.bpe.camunda.DelegateProvider;
import dev.dsf.bpe.camunda.ProcessPluginConsumer;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessPlugin;
import dev.dsf.bpe.v1.activity.DefaultUserTaskListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;

public class DelegateProviderImpl
implements DelegateProvider,
ProcessPluginConsumer,
InitializingBean {
    private final ClassLoader defaultClassLoader;
    private final ApplicationContext defaultApplicationContext;
    private final Map<ProcessIdAndVersion, ProcessPlugin<?, ?>> processPluginsByIdAndVersion = new HashMap();

    public DelegateProviderImpl(ClassLoader mainClassLoader, ApplicationContext mainApplicationContext) {
        this.defaultClassLoader = mainClassLoader;
        this.defaultApplicationContext = mainApplicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.defaultClassLoader, "defaultClassLoader");
        Objects.requireNonNull(this.defaultApplicationContext, "defaultApplicationContext");
    }

    @Override
    public void setProcessPlugins(List<ProcessPlugin<?, ?>> plugins) {
        this.processPluginsByIdAndVersion.putAll(plugins.stream().flatMap(plugin -> plugin.getProcessKeysAndVersions().stream().map(idAndVersion -> new ProcessByIdAndVersion((ProcessIdAndVersion)idAndVersion, (ProcessPlugin<?, ?>)plugin))).collect(Collectors.toMap(ProcessByIdAndVersion::getProcessIdAndVersion, ProcessByIdAndVersion::getPlugin)));
    }

    @Override
    public ClassLoader getClassLoader(ProcessIdAndVersion processIdAndVersion) {
        if (processIdAndVersion == null) {
            return this.defaultClassLoader;
        }
        ProcessPlugin<?, ?> plugin = this.processPluginsByIdAndVersion.get(processIdAndVersion);
        if (plugin == null) {
            return this.defaultClassLoader;
        }
        return plugin.getProcessPluginClassLoader();
    }

    @Override
    public ApplicationContext getApplicationContext(ProcessIdAndVersion processIdAndVersion) {
        if (processIdAndVersion == null) {
            return this.defaultApplicationContext;
        }
        ProcessPlugin<?, ?> plugin = this.processPluginsByIdAndVersion.get(processIdAndVersion);
        if (plugin == null) {
            return this.defaultApplicationContext;
        }
        return plugin.getApplicationContext();
    }

    @Override
    public Class<? extends TaskListener> getDefaultUserTaskListenerClass(String processPluginApiVersion) {
        switch (processPluginApiVersion) {
            case "1": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Process plugin API version " + processPluginApiVersion + " not supported");
            }
        }
        return DefaultUserTaskListener.class;
    }

    private static final class ProcessByIdAndVersion {
        final ProcessIdAndVersion processIdAndVersion;
        final ProcessPlugin<?, ?> plugin;

        ProcessByIdAndVersion(ProcessIdAndVersion idAndVersion, ProcessPlugin<?, ?> plugin) {
            this.processIdAndVersion = idAndVersion;
            this.plugin = plugin;
        }

        public ProcessIdAndVersion getProcessIdAndVersion() {
            return this.processIdAndVersion;
        }

        public ProcessPlugin<?, ?> getPlugin() {
            return this.plugin;
        }
    }
}

