/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.authentication;

import dev.dsf.bpe.service.LocalOrganizationProvider;
import dev.dsf.common.auth.conf.AbstractIdentityProvider;
import dev.dsf.common.auth.conf.Identity;
import dev.dsf.common.auth.conf.IdentityProvider;
import dev.dsf.common.auth.conf.PractitionerIdentityImpl;
import dev.dsf.common.auth.conf.RoleConfig;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Practitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class IdentityProviderImpl
extends AbstractIdentityProvider
implements IdentityProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(IdentityProviderImpl.class);
    private final LocalOrganizationProvider organizationProvider;

    public IdentityProviderImpl(RoleConfig roleConfig, LocalOrganizationProvider organizationProvider) {
        super(roleConfig);
        this.organizationProvider = organizationProvider;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Objects.requireNonNull(this.organizationProvider, "organizationProvider");
    }

    protected Optional<Organization> getLocalOrganization() {
        return this.organizationProvider.getLocalOrganization();
    }

    public Identity getIdentity(X509Certificate[] certificates) {
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        String thumbprint = this.getThumbprint(certificates[0]);
        Optional practitioner = this.toPractitioner(certificates[0]);
        Optional<Organization> localOrganization = this.organizationProvider.getLocalOrganization();
        if (practitioner.isPresent() && localOrganization.isPresent()) {
            Practitioner p = (Practitioner)practitioner.get();
            Organization o = localOrganization.get();
            return new PractitionerIdentityImpl(o, (Collection)this.getDsfRolesFor(p, thumbprint, null, null), certificates[0], p, (Collection)this.getPractitionerRolesFor(p, thumbprint, null, null), null);
        }
        logger.warn("Certificate with thumbprint '{}' for '{}' unknown, not configured as local user or local organization unknown", (Object)thumbprint, (Object)this.getDn(certificates[0]));
        return null;
    }
}

