/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.webservice;

import dev.dsf.common.auth.conf.Identity;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="")
@Produces(value={"text/html"})
public class RootService {
    public static final String PATH = "";
    private static final Logger logger = LoggerFactory.getLogger(RootService.class);

    @GET
    public Response root(@Context UriInfo uri, @Context SecurityContext securityContext) {
        logger.trace("GET {}", (Object)uri.getRequestUri().toString());
        StringBuilder out = new StringBuilder();
        out.append("<html>\n<head>\n<title>BPE Root</title>\n</head>\n<body>\n<span>Hello, ${user}</span>\n".replace("${user}", this.getDisplayName(securityContext)));
        if ("OPENID".equals(securityContext.getAuthenticationScheme())) {
            String basePath = uri.getBaseUri().getRawPath();
            out.append("\t<a href=\"${basePath}logout\">Logout</a>\n".replace("${basePath}", basePath));
        }
        out.append("</body>\n</html>\n");
        return Response.ok((Object)out.toString()).build();
    }

    private String getDisplayName(SecurityContext securityContext) {
        Principal userPrincipal = securityContext.getUserPrincipal();
        if (userPrincipal != null && userPrincipal instanceof Identity) {
            Identity identity = (Identity)userPrincipal;
            return identity.getDisplayName();
        }
        return "?";
    }
}

