/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.v1.service;

import dev.dsf.bpe.v1.service.AbstractResourceProvider;
import dev.dsf.bpe.v1.service.FhirWebserviceClientProvider;
import dev.dsf.bpe.v1.service.OrganizationProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.OrganizationAffiliation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrganizationProviderImpl
extends AbstractResourceProvider
implements OrganizationProvider {
    private static final Logger logger = LoggerFactory.getLogger(OrganizationProviderImpl.class);

    public OrganizationProviderImpl(FhirWebserviceClientProvider clientProvider, String localEndpointAddress) {
        super(clientProvider, localEndpointAddress);
    }

    public Optional<Organization> getLocalOrganization() {
        Bundle resultBundle = this.clientProvider.getLocalWebserviceClient().searchWithStrictHandling(Endpoint.class, Map.of("status", Collections.singletonList("active"), "address", Collections.singletonList(this.localEndpointAddress), "_include", Collections.singletonList("Endpoint:organization")));
        if (resultBundle == null || resultBundle.getEntry() == null || resultBundle.getEntry().size() != 2 || ((Bundle.BundleEntryComponent)resultBundle.getEntry().get(0)).getResource() == null || !(((Bundle.BundleEntryComponent)resultBundle.getEntry().get(0)).getResource() instanceof Endpoint) || ((Bundle.BundleEntryComponent)resultBundle.getEntry().get(1)).getResource() == null || !(((Bundle.BundleEntryComponent)resultBundle.getEntry().get(1)).getResource() instanceof Organization)) {
            logger.warn("No active (or more than one) Endpoint found for address '{}'", (Object)this.localEndpointAddress);
            return Optional.empty();
        }
        if (this.getActiveOrganizationFromIncludes(resultBundle).count() != 1L) {
            logger.warn("No active (or more than one) Organization found by active Endpoint with address '{}'", (Object)this.localEndpointAddress);
            return Optional.empty();
        }
        return this.getActiveOrganizationFromIncludes(resultBundle).findFirst();
    }

    private Stream<Organization> getActiveOrganizationFromIncludes(Bundle resultBundle) {
        return resultBundle.getEntry().stream().filter(Bundle.BundleEntryComponent::hasSearch).filter(e -> Bundle.SearchEntryMode.INCLUDE.equals((Object)e.getSearch().getMode())).filter(Bundle.BundleEntryComponent::hasResource).map(Bundle.BundleEntryComponent::getResource).filter(r -> r instanceof Organization).map(r -> (Organization)r).filter(Organization::getActive);
    }

    public Optional<Organization> getOrganization(Identifier organizationIdentifier) {
        if (organizationIdentifier == null) {
            logger.debug("Organization identifier is null");
            return Optional.empty();
        }
        String organizationIdSp = this.toSearchParameter(organizationIdentifier);
        Bundle resultBundle = this.clientProvider.getLocalWebserviceClient().searchWithStrictHandling(Organization.class, Map.of("active", Collections.singletonList("true"), "identifier", Collections.singletonList(organizationIdSp)));
        if (resultBundle == null || resultBundle.getEntry() == null || resultBundle.getTotal() != 1 || resultBundle.getEntryFirstRep().getResource() == null || !(resultBundle.getEntryFirstRep().getResource() instanceof Organization)) {
            logger.warn("No active (or more than one) Organization found for identifier '{}'", (Object)organizationIdSp);
            return Optional.empty();
        }
        return Optional.of((Organization)resultBundle.getEntryFirstRep().getResource());
    }

    public List<Organization> getOrganizations(Identifier parentOrganizationIdentifier) {
        if (parentOrganizationIdentifier == null) {
            logger.debug("Parent organiztion identifier is null");
            return Collections.emptyList();
        }
        String parentOrganizationIdSp = this.toSearchParameter(parentOrganizationIdentifier);
        Map<String, List<String>> parameters = Map.of("active", Collections.singletonList("true"), "primary-organization:identifier", Collections.singletonList(parentOrganizationIdSp), "_include", Collections.singletonList("OrganizationAffiliation:participating-organization"));
        return this.search(OrganizationAffiliation.class, parameters, Bundle.SearchEntryMode.INCLUDE, Organization.class, Organization::getActive);
    }

    public List<Organization> getOrganizations(Identifier parentOrganizationIdentifier, Coding memberOrganizationRole) {
        if (parentOrganizationIdentifier == null) {
            logger.debug("Parent organiztion identifier is null");
            return Collections.emptyList();
        }
        if (memberOrganizationRole == null) {
            logger.debug("Member organiztion role is null");
            return Collections.emptyList();
        }
        String parentOrganizationIdSp = this.toSearchParameter(parentOrganizationIdentifier);
        String memberOrganizationRoleSp = this.toSearchParameter(memberOrganizationRole);
        Map<String, List<String>> parameters = Map.of("active", Collections.singletonList("true"), "primary-organization:identifier", Collections.singletonList(parentOrganizationIdSp), "role", Collections.singletonList(memberOrganizationRoleSp), "_include", Collections.singletonList("OrganizationAffiliation:participating-organization"));
        return this.search(OrganizationAffiliation.class, parameters, Bundle.SearchEntryMode.INCLUDE, Organization.class, Organization::getActive);
    }

    public List<Organization> getRemoteOrganizations() {
        Optional localOrganizationIdentifier = this.getLocalOrganizationIdentifier();
        if (localOrganizationIdentifier.isEmpty()) {
            logger.debug("Local organiztion identifier unknown");
            return Collections.emptyList();
        }
        Map<String, List<String>> searchParameters = Map.of("active", Collections.singletonList("true"), "identifier:not", Collections.singletonList(this.toSearchParameter((Identifier)localOrganizationIdentifier.get())));
        return this.search(Organization.class, searchParameters, Bundle.SearchEntryMode.MATCH, Organization.class, o -> true);
    }
}

