/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import dev.dsf.bpe.dao.LastEventTimeDao;
import dev.dsf.bpe.subscription.EventResourceHandler;
import dev.dsf.bpe.subscription.EventResourceHandlerImpl;
import dev.dsf.bpe.subscription.ExistingResourceLoader;
import dev.dsf.bpe.subscription.ExistingResourceLoaderImpl;
import dev.dsf.bpe.subscription.PingEventResourceHandler;
import dev.dsf.bpe.subscription.PingEventResourceHandlerImpl;
import dev.dsf.bpe.subscription.ResourceHandler;
import dev.dsf.bpe.subscription.SubscriptionHandlerFactory;
import dev.dsf.fhir.client.FhirWebserviceClient;
import java.util.Objects;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.springframework.beans.factory.InitializingBean;

public class QuestionnaireResponseSubscriptionHandlerFactory
implements SubscriptionHandlerFactory<QuestionnaireResponse>,
InitializingBean {
    private final ResourceHandler<QuestionnaireResponse> resourceHandler;
    private final LastEventTimeDao lastEventTimeDao;

    public QuestionnaireResponseSubscriptionHandlerFactory(ResourceHandler<QuestionnaireResponse> resourceHandler, LastEventTimeDao lastEventTimeDao) {
        this.resourceHandler = resourceHandler;
        this.lastEventTimeDao = lastEventTimeDao;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.resourceHandler, "resourceHandler");
        Objects.requireNonNull(this.lastEventTimeDao, "lastEventTimeDao");
    }

    @Override
    public ExistingResourceLoader<QuestionnaireResponse> createExistingResourceLoader(FhirWebserviceClient client) {
        return new ExistingResourceLoaderImpl<QuestionnaireResponse>(this.lastEventTimeDao, this.resourceHandler, client, "QuestionnaireResponse", QuestionnaireResponse.class);
    }

    @Override
    public EventResourceHandler<QuestionnaireResponse> createEventResourceHandler() {
        return new EventResourceHandlerImpl<QuestionnaireResponse>(this.lastEventTimeDao, this.resourceHandler, QuestionnaireResponse.class);
    }

    @Override
    public PingEventResourceHandler<QuestionnaireResponse> createPingEventResourceHandler(ExistingResourceLoader<QuestionnaireResponse> existingResourceLoader) {
        return new PingEventResourceHandlerImpl<QuestionnaireResponse>(existingResourceLoader);
    }
}

