/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import ca.uhn.fhir.context.FhirContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import dev.dsf.bpe.plugin.BpmnProcessStateChangeService;
import dev.dsf.bpe.plugin.BpmnProcessStateChangeServiceImpl;
import dev.dsf.bpe.plugin.FhirResourceHandler;
import dev.dsf.bpe.plugin.FhirResourceHandlerImpl;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessPluginFactory;
import dev.dsf.bpe.plugin.ProcessPluginLoader;
import dev.dsf.bpe.plugin.ProcessPluginLoaderImpl;
import dev.dsf.bpe.plugin.ProcessPluginManager;
import dev.dsf.bpe.plugin.ProcessPluginManagerImpl;
import dev.dsf.bpe.spring.config.CamundaConfig;
import dev.dsf.bpe.spring.config.DaoConfig;
import dev.dsf.bpe.spring.config.FhirClientConfig;
import dev.dsf.bpe.spring.config.FhirConfig;
import dev.dsf.bpe.spring.config.MailConfig;
import dev.dsf.bpe.spring.config.PropertiesConfig;
import dev.dsf.bpe.spring.config.SerializerConfig;
import dev.dsf.bpe.v1.ProcessPluginApi;
import dev.dsf.bpe.v1.ProcessPluginApiImpl;
import dev.dsf.bpe.v1.ProcessPluginDefinition;
import dev.dsf.bpe.v1.config.ProxyConfigDelegate;
import dev.dsf.bpe.v1.plugin.ProcessPluginFactoryImpl;
import dev.dsf.bpe.v1.service.EndpointProviderImpl;
import dev.dsf.bpe.v1.service.FhirWebserviceClientProviderImpl;
import dev.dsf.bpe.v1.service.MailServiceImpl;
import dev.dsf.bpe.v1.service.OrganizationProviderImpl;
import dev.dsf.bpe.v1.service.QuestionnaireResponseHelperImpl;
import dev.dsf.bpe.v1.service.TaskHelperImpl;
import dev.dsf.fhir.authorization.process.ProcessAuthorizationHelper;
import dev.dsf.fhir.authorization.process.ProcessAuthorizationHelperImpl;
import dev.dsf.fhir.authorization.read.ReadAccessHelper;
import dev.dsf.fhir.authorization.read.ReadAccessHelperImpl;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

@Configuration
public class PluginConfig {
    @Autowired
    private Environment environment;
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private FhirClientConfig fhirClientConfig;
    @Autowired
    private DaoConfig daoConfig;
    @Autowired
    private MailConfig mailConfig;
    @Autowired
    private SerializerConfig serializerConfig;
    @Autowired
    private CamundaConfig camundaConfig;

    @Bean
    public ProcessPluginApi processPluginApiV1() {
        ProxyConfigDelegate proxyConfig = new ProxyConfigDelegate(this.propertiesConfig.proxyConfig());
        FhirWebserviceClientProviderImpl clientProvider = new FhirWebserviceClientProviderImpl(this.fhirClientConfig.clientProvider());
        EndpointProviderImpl endpointProvider = new EndpointProviderImpl(clientProvider, this.propertiesConfig.getServerBaseUrl());
        FhirContext fhirContext = this.fhirConfig.fhirContext();
        MailServiceImpl mailService = new MailServiceImpl(this.mailConfig.mailService());
        ObjectMapper objectMapper = this.serializerConfig.objectMapper();
        OrganizationProviderImpl organizationProvider = new OrganizationProviderImpl(clientProvider, this.propertiesConfig.getServerBaseUrl());
        ProcessAuthorizationHelperImpl processAuthorizationHelper = new ProcessAuthorizationHelperImpl();
        QuestionnaireResponseHelperImpl questionnaireResponseHelper = new QuestionnaireResponseHelperImpl(this.propertiesConfig.getServerBaseUrl());
        ReadAccessHelperImpl readAccessHelper = new ReadAccessHelperImpl();
        TaskHelperImpl taskHelper = new TaskHelperImpl(this.propertiesConfig.getServerBaseUrl());
        return new ProcessPluginApiImpl(proxyConfig, endpointProvider, fhirContext, clientProvider, mailService, objectMapper, organizationProvider, (ProcessAuthorizationHelper)processAuthorizationHelper, questionnaireResponseHelper, (ReadAccessHelper)readAccessHelper, taskHelper);
    }

    @Bean
    public ProcessPluginFactory<ProcessPluginDefinition> processPluginFactoryV1() {
        return new ProcessPluginFactoryImpl(this.processPluginApiV1());
    }

    @Bean
    public ProcessPluginLoader processPluginLoader() {
        Path processPluginDirectoryPath = this.propertiesConfig.getProcessPluginDirectory();
        if (!Files.isDirectory(processPluginDirectoryPath, new LinkOption[0])) {
            throw new RuntimeException("Process plug in directory '" + processPluginDirectoryPath.toString() + "' not readable");
        }
        return new ProcessPluginLoaderImpl(List.of(this.processPluginFactoryV1()), processPluginDirectoryPath, this.fhirConfig.fhirContext(), (ConfigurableEnvironment)this.environment);
    }

    @Bean
    public BpmnProcessStateChangeService bpmnProcessStateChangeService() {
        return new BpmnProcessStateChangeServiceImpl(this.camundaConfig.processEngine().getRepositoryService(), this.daoConfig.processStateDao(), ProcessIdAndVersion.fromStrings(this.propertiesConfig.getProcessExcluded()), ProcessIdAndVersion.fromStrings(this.propertiesConfig.getProcessRetired()));
    }

    @Bean
    public FhirResourceHandler fhirResourceHandler() {
        return new FhirResourceHandlerImpl(this.fhirClientConfig.clientProvider().getLocalWebserviceClient(), this.daoConfig.processPluginResourcesDao(), this.fhirConfig.fhirContext(), this.propertiesConfig.getFhirServerRequestMaxRetries(), this.propertiesConfig.getFhirServerRetryDelayMillis());
    }

    @Bean
    public ProcessPluginManager processPluginManager() {
        return new ProcessPluginManagerImpl(List.of(this.camundaConfig.delegateProvider(), this.camundaConfig.fallbackSerializerFactory()), this.processPluginLoader(), this.bpmnProcessStateChangeService(), this.fhirResourceHandler(), this.propertiesConfig.getServerBaseUrl(), this.fhirClientConfig.clientProvider().getLocalWebserviceClient(), this.propertiesConfig.getFhirServerRequestMaxRetries(), this.propertiesConfig.getFhirServerRetryDelayMillis());
    }
}

