/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessState;
import dev.dsf.bpe.plugin.ResourceInfo;
import dev.dsf.bpe.v1.constants.NamingSystems;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.ValueSet;

public final class ProcessesResource {
    private final ResourceInfo resourceInfo;
    private final Resource resource;
    private final Set<ProcessIdAndVersion> processes = new HashSet<ProcessIdAndVersion>();
    private ProcessState oldState;
    private ProcessState newState;

    public static ProcessesResource from(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        if (resource instanceof ActivityDefinition) {
            return ProcessesResource.fromMetadataResource((MetadataResource)((ActivityDefinition)resource));
        }
        if (resource instanceof CodeSystem) {
            return ProcessesResource.fromMetadataResource((MetadataResource)((CodeSystem)resource));
        }
        if (resource instanceof Library) {
            return ProcessesResource.fromMetadataResource((MetadataResource)((Library)resource));
        }
        if (resource instanceof Measure) {
            return ProcessesResource.fromMetadataResource((MetadataResource)((Measure)resource));
        }
        if (resource instanceof NamingSystem) {
            return ProcessesResource.fromNamingSystem((NamingSystem)resource);
        }
        if (resource instanceof Questionnaire) {
            return ProcessesResource.fromMetadataResource((MetadataResource)((Questionnaire)resource));
        }
        if (resource instanceof StructureDefinition) {
            return ProcessesResource.fromMetadataResource((MetadataResource)((StructureDefinition)resource));
        }
        if (resource instanceof Task) {
            return ProcessesResource.fromTask((Task)resource);
        }
        if (resource instanceof ValueSet) {
            return ProcessesResource.fromMetadataResource((MetadataResource)((ValueSet)resource));
        }
        throw new IllegalArgumentException("MetadataResource of type " + resource.getClass().getName() + " not supported");
    }

    public static ProcessesResource fromMetadataResource(MetadataResource resource) {
        return new ProcessesResource(new ResourceInfo(resource.getResourceType(), resource.getUrl(), resource.getVersion(), null, null), (Resource)resource);
    }

    public static ProcessesResource fromNamingSystem(NamingSystem resource) {
        return new ProcessesResource(new ResourceInfo(resource.getResourceType(), null, null, resource.getName(), null), (Resource)resource);
    }

    public static ProcessesResource fromTask(Task resource) {
        return new ProcessesResource(new ResourceInfo(resource.getResourceType(), null, null, null, ProcessesResource.getIdentifier(resource)), (Resource)resource);
    }

    private static String getIdentifier(Task resource) {
        return NamingSystems.TaskIdentifier.findFirst((Task)resource).map(Identifier::getValue).get();
    }

    public static ProcessesResource from(ResourceInfo resourceInfo) {
        return new ProcessesResource(resourceInfo, null);
    }

    private ProcessesResource(ResourceInfo resourceInfo, Resource resource) {
        this.resourceInfo = resourceInfo;
        this.resource = resource;
    }

    public ResourceInfo getResourceInfo() {
        return this.resourceInfo;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Set<ProcessIdAndVersion> getProcesses() {
        return Collections.unmodifiableSet(this.processes);
    }

    public ProcessesResource add(ProcessIdAndVersion process) {
        this.processes.add(process);
        return this;
    }

    public void addAll(Set<ProcessIdAndVersion> processes) {
        this.processes.addAll(processes);
    }

    public ProcessesResource setOldProcessState(ProcessState oldState) {
        this.oldState = oldState;
        return this;
    }

    public ProcessState getOldProcessState() {
        return this.oldState;
    }

    public ProcessesResource setNewProcessState(ProcessState newState) {
        this.newState = newState;
        return this;
    }

    public ProcessState getNewProcessState() {
        return this.newState;
    }

    public boolean hasStateChangeOrDraft() {
        return !Objects.equals((Object)this.getOldProcessState(), (Object)this.getNewProcessState()) || ProcessState.DRAFT.equals((Object)this.getOldProcessState()) && ProcessState.DRAFT.equals((Object)this.getNewProcessState());
    }

    public boolean notNewToExcludedChange() {
        return !ProcessState.NEW.equals((Object)this.getOldProcessState()) || !ProcessState.EXCLUDED.equals((Object)this.getNewProcessState());
    }

    public boolean shouldExist() {
        return ProcessState.ACTIVE.equals((Object)this.getOldProcessState()) && ProcessState.ACTIVE.equals((Object)this.getNewProcessState()) || ProcessState.RETIRED.equals((Object)this.getOldProcessState()) && ProcessState.RETIRED.equals((Object)this.getNewProcessState());
    }

    public Bundle.BundleEntryComponent toBundleEntry(String baseUrl) {
        switch (this.getOldProcessState()) {
            case MISSING: {
                return this.fromMissing();
            }
            case NEW: {
                return this.fromNew();
            }
            case ACTIVE: {
                return this.fromActive(baseUrl);
            }
            case DRAFT: {
                return this.fromDraft(baseUrl);
            }
            case RETIRED: {
                return this.fromRetired(baseUrl);
            }
            case EXCLUDED: {
                return this.fromExcluded();
            }
        }
        throw new RuntimeException(ProcessState.class.getSimpleName() + " " + this.getOldProcessState() + " not supported");
    }

    private Bundle.BundleEntryComponent fromMissing() {
        switch (this.getNewProcessState()) {
            case ACTIVE: {
                return this.createAsActive();
            }
            case RETIRED: {
                return this.createAsRetired();
            }
        }
        throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
    }

    private Bundle.BundleEntryComponent fromNew() {
        switch (this.getNewProcessState()) {
            case ACTIVE: {
                return this.createAsActive();
            }
            case DRAFT: {
                return this.createAsDraft();
            }
            case RETIRED: {
                return this.createAsRetired();
            }
        }
        throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
    }

    private Bundle.BundleEntryComponent fromActive(String baseUrl) {
        switch (this.getNewProcessState()) {
            case DRAFT: {
                return this.updateToDraft(baseUrl);
            }
            case RETIRED: {
                return this.updateToRetired(baseUrl);
            }
            case EXCLUDED: {
                return this.delete();
            }
        }
        throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
    }

    private Bundle.BundleEntryComponent fromDraft(String baseUrl) {
        switch (this.getNewProcessState()) {
            case ACTIVE: {
                return this.updateToActive(baseUrl);
            }
            case DRAFT: {
                return this.updateToDraft(baseUrl);
            }
            case RETIRED: {
                return this.updateToRetired(baseUrl);
            }
            case EXCLUDED: {
                return this.delete();
            }
        }
        throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
    }

    private Bundle.BundleEntryComponent fromRetired(String baseUrl) {
        switch (this.getNewProcessState()) {
            case ACTIVE: {
                return this.updateToActive(baseUrl);
            }
            case DRAFT: {
                return this.updateToDraft(baseUrl);
            }
            case EXCLUDED: {
                return this.delete();
            }
        }
        throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
    }

    private Bundle.BundleEntryComponent fromExcluded() {
        switch (this.getNewProcessState()) {
            case ACTIVE: {
                return this.createAsActive();
            }
            case DRAFT: {
                return this.createAsDraft();
            }
            case RETIRED: {
                return this.createAsRetired();
            }
        }
        throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
    }

    private Bundle.BundleEntryComponent createAsActive() {
        if (this.getResource() instanceof MetadataResource) {
            ((MetadataResource)this.getResource()).setStatus(Enumerations.PublicationStatus.ACTIVE);
        }
        return this.create();
    }

    private Bundle.BundleEntryComponent createAsDraft() {
        if (this.getResource() instanceof MetadataResource) {
            ((MetadataResource)this.getResource()).setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        return this.create();
    }

    private Bundle.BundleEntryComponent createAsRetired() {
        if (this.getResource() instanceof MetadataResource) {
            ((MetadataResource)this.getResource()).setStatus(Enumerations.PublicationStatus.RETIRED);
        }
        return this.create();
    }

    private Bundle.BundleEntryComponent create() {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        entry.setResource(this.getResource());
        entry.setFullUrl("urn:uuid:" + UUID.randomUUID().toString());
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.POST);
        request.setUrl(this.getResourceInfo().getResourceType().name());
        request.setIfNoneExist(this.getResourceInfo().toConditionalUrl());
        return entry;
    }

    private Bundle.BundleEntryComponent updateToActive(String baseUrl) {
        if (this.getResource() instanceof MetadataResource) {
            ((MetadataResource)this.getResource()).setStatus(Enumerations.PublicationStatus.ACTIVE);
        }
        return this.update(baseUrl);
    }

    private Bundle.BundleEntryComponent updateToDraft(String baseUrl) {
        if (this.getResource() instanceof MetadataResource) {
            ((MetadataResource)this.getResource()).setStatus(Enumerations.PublicationStatus.DRAFT);
        }
        return this.update(baseUrl);
    }

    private Bundle.BundleEntryComponent updateToRetired(String baseUrl) {
        if (this.getResource() instanceof MetadataResource) {
            ((MetadataResource)this.getResource()).setStatus(Enumerations.PublicationStatus.RETIRED);
        }
        return this.update(baseUrl);
    }

    private Bundle.BundleEntryComponent update(String baseUrl) {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        entry.setResource(this.getResource());
        entry.setFullUrl("urn:uuid:" + UUID.randomUUID().toString());
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.PUT);
        request.setUrl(this.getResourceInfo().getResourceType().name() + "?" + this.getResourceInfo().toConditionalUrl());
        return entry;
    }

    private Bundle.BundleEntryComponent delete() {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.DELETE);
        request.setUrl(this.getResourceInfo().getResourceType().name() + "?" + this.getResourceInfo().toConditionalUrl());
        return entry;
    }

    public List<String> getExpectedStatus() {
        switch (this.getOldProcessState()) {
            case MISSING: {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        return Arrays.asList("200", "201");
                    }
                    case RETIRED: {
                        return Arrays.asList("200", "201");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case NEW: {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        return Arrays.asList("200", "201");
                    }
                    case DRAFT: {
                        return Arrays.asList("200", "201");
                    }
                    case RETIRED: {
                        return Arrays.asList("200", "201");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case ACTIVE: {
                switch (this.getNewProcessState()) {
                    case DRAFT: {
                        return Collections.singletonList("200");
                    }
                    case RETIRED: {
                        return Collections.singletonList("200");
                    }
                    case EXCLUDED: {
                        return Arrays.asList("200", "204");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case DRAFT: {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        return Collections.singletonList("200");
                    }
                    case DRAFT: {
                        return Collections.singletonList("200");
                    }
                    case RETIRED: {
                        return Collections.singletonList("200");
                    }
                    case EXCLUDED: {
                        return Arrays.asList("200", "204");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case RETIRED: {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        return Collections.singletonList("200");
                    }
                    case DRAFT: {
                        return Collections.singletonList("200");
                    }
                    case EXCLUDED: {
                        return Arrays.asList("200", "204");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
            case EXCLUDED: {
                switch (this.getNewProcessState()) {
                    case ACTIVE: {
                        return Arrays.asList("200", "201");
                    }
                    case DRAFT: {
                        return Arrays.asList("200", "201");
                    }
                    case RETIRED: {
                        return Arrays.asList("200", "201");
                    }
                }
                throw new RuntimeException("State change " + this.getOldProcessState() + " -> " + this.getNewProcessState() + " not supported");
            }
        }
        throw new RuntimeException(ProcessState.class.getSimpleName() + " " + this.getOldProcessState() + " not supported");
    }

    public Bundle.BundleEntryComponent toSearchBundleEntryCount0() {
        Bundle.BundleEntryComponent entry = new Bundle.BundleEntryComponent();
        Bundle.BundleEntryRequestComponent request = entry.getRequest();
        request.setMethod(Bundle.HTTPVerb.GET);
        request.setUrl(this.getSearchBundleEntryUrl() + "&_count=0");
        return entry;
    }

    public String getSearchBundleEntryUrl() {
        return this.getResourceInfo().getResourceType().name() + "?" + this.getResourceInfo().toConditionalUrl();
    }
}

