/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.Process;

public class ProcessIdAndVersion
implements Comparable<ProcessIdAndVersion> {
    private final String id;
    private final String version;

    public static ProcessIdAndVersion fromString(String idAndVersion) {
        Objects.requireNonNull(idAndVersion, "idAndVersion");
        String[] split = idAndVersion.split("\\|");
        if (split.length != 2) {
            throw new IllegalArgumentException("Format: 'id|version' expected");
        }
        return new ProcessIdAndVersion(split[0], split[1]);
    }

    public static List<ProcessIdAndVersion> fromStrings(List<String> idAndVersions) {
        Objects.requireNonNull(idAndVersions, "idAndVersions");
        return idAndVersions.stream().filter(s -> s != null && !s.isBlank()).map(ProcessIdAndVersion::fromString).collect(Collectors.toList());
    }

    public static ProcessIdAndVersion fromDefinition(ProcessDefinition definition) {
        Objects.requireNonNull(definition, "definition");
        return new ProcessIdAndVersion(definition.getKey(), definition.getVersionTag());
    }

    public static ProcessIdAndVersion fromModel(BpmnModelInstance model) {
        Objects.requireNonNull(model, "model");
        Process process = (Process)model.getModelElementsByType(Process.class).stream().findFirst().get();
        return new ProcessIdAndVersion(process.getId(), process.getCamundaVersionTag());
    }

    public ProcessIdAndVersion(String id, String version) {
        this.id = id;
        this.version = version;
    }

    public String getId() {
        return this.id;
    }

    public String getVersion() {
        return this.version;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessIdAndVersion other = (ProcessIdAndVersion)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return this.getId() + "|" + this.getVersion();
    }

    @Override
    public int compareTo(ProcessIdAndVersion o) {
        return Comparator.comparing(ProcessIdAndVersion::getId).thenComparing(ProcessIdAndVersion::getVersion).compare(this, o);
    }
}

