/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import dev.dsf.bpe.dao.ProcessStateDao;
import dev.dsf.bpe.plugin.BpmnFileAndModel;
import dev.dsf.bpe.plugin.BpmnProcessStateChangeService;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessState;
import dev.dsf.bpe.plugin.ProcessStateChangeOutcome;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.RepositoryService;
import org.camunda.bpm.engine.repository.Deployment;
import org.camunda.bpm.engine.repository.DeploymentBuilder;
import org.camunda.bpm.engine.repository.DeploymentQuery;
import org.camunda.bpm.engine.repository.ProcessDefinition;
import org.camunda.bpm.engine.repository.ProcessDefinitionQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class BpmnProcessStateChangeServiceImpl
implements BpmnProcessStateChangeService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(BpmnProcessStateChangeServiceImpl.class);
    private final RepositoryService repositoryService;
    private final ProcessStateDao processStateDao;
    private final Set<ProcessIdAndVersion> excluded = new HashSet<ProcessIdAndVersion>();
    private final Set<ProcessIdAndVersion> retired = new HashSet<ProcessIdAndVersion>();

    public BpmnProcessStateChangeServiceImpl(RepositoryService repositoryService, ProcessStateDao processStateDao, List<ProcessIdAndVersion> excluded, List<ProcessIdAndVersion> retired) {
        this.repositoryService = repositoryService;
        this.processStateDao = processStateDao;
        if (excluded != null) {
            this.excluded.addAll(excluded);
        }
        if (retired != null) {
            this.retired.addAll(retired);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.repositoryService, "repositoryService");
        Objects.requireNonNull(this.processStateDao, "processStateDao");
        logger.info("Excluded processes: {}", this.excluded);
        logger.info("Retired processes: {}", this.retired);
    }

    private Map<ProcessIdAndVersion, ProcessState> getStates() {
        try {
            return this.processStateDao.getStates();
        }
        catch (SQLException e) {
            logger.warn("Error while retrieving process states from db", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<ProcessStateChangeOutcome> deploySuspendOrActivateProcesses(List<BpmnFileAndModel> models) {
        Objects.requireNonNull(models, "models");
        Map<ProcessIdAndVersion, ProcessState> oldProcessStates = this.getStates();
        HashMap<ProcessIdAndVersion, ProcessState> newProcessStates = new HashMap<ProcessIdAndVersion, ProcessState>();
        logger.debug("Deploying process models ...");
        models.forEach(this::deploy);
        Set loadedProcesses = models.stream().map(BpmnFileAndModel::getProcessIdAndVersion).collect(Collectors.toSet());
        Set draft = models.stream().filter(BpmnFileAndModel::isDraft).map(BpmnFileAndModel::getProcessIdAndVersion).collect(Collectors.toSet());
        List definitions = this.repositoryService.createProcessDefinitionQuery().list();
        for (ProcessDefinition definition : definitions) {
            ProcessState newState;
            ProcessIdAndVersion process = ProcessIdAndVersion.fromDefinition(definition);
            ProcessState oldState = oldProcessStates.getOrDefault(process, ProcessState.NEW);
            ProcessState processState = newState = loadedProcesses.contains(process) ? ProcessState.ACTIVE : ProcessState.EXCLUDED;
            if (this.excluded.contains(process)) {
                newState = ProcessState.EXCLUDED;
            } else if (this.retired.contains(process)) {
                newState = ProcessState.RETIRED;
            } else if (draft.contains(process)) {
                newState = ProcessState.DRAFT;
            }
            newProcessStates.put(process, newState);
            logger.debug("{}: {} -> {}", new Object[]{process.toString(), oldState, newState});
            if (ProcessState.RETIRED.equals((Object)oldState) && ProcessState.ACTIVE.equals((Object)newState) || ProcessState.RETIRED.equals((Object)oldState) && ProcessState.DRAFT.equals((Object)newState) || ProcessState.EXCLUDED.equals((Object)oldState) && ProcessState.ACTIVE.equals((Object)newState) || ProcessState.EXCLUDED.equals((Object)oldState) && ProcessState.DRAFT.equals((Object)newState)) {
                logger.debug("Activating process {}", (Object)process.toString());
                this.repositoryService.activateProcessDefinitionById(definition.getId());
                continue;
            }
            if (!(ProcessState.NEW.equals((Object)oldState) && ProcessState.RETIRED.equals((Object)newState) || ProcessState.NEW.equals((Object)oldState) && ProcessState.EXCLUDED.equals((Object)newState) || ProcessState.ACTIVE.equals((Object)oldState) && ProcessState.RETIRED.equals((Object)newState) || ProcessState.ACTIVE.equals((Object)oldState) && ProcessState.EXCLUDED.equals((Object)newState) || ProcessState.DRAFT.equals((Object)oldState) && ProcessState.RETIRED.equals((Object)newState)) && (!ProcessState.DRAFT.equals((Object)oldState) || !ProcessState.EXCLUDED.equals((Object)newState))) continue;
            logger.debug("Suspending process {}", (Object)process.toString());
            this.repositoryService.suspendProcessDefinitionById(definition.getId());
        }
        this.updateStates(newProcessStates);
        this.logProcessDeploymentStatus();
        return newProcessStates.entrySet().stream().map(e -> new ProcessStateChangeOutcome((ProcessIdAndVersion)e.getKey(), oldProcessStates.getOrDefault(e.getKey(), ProcessState.NEW), (ProcessState)((Object)((Object)e.getValue())))).collect(Collectors.toList());
    }

    private void updateStates(Map<ProcessIdAndVersion, ProcessState> states) {
        try {
            this.processStateDao.updateStates(states);
        }
        catch (SQLException e) {
            logger.warn("Error while updating process states in db", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void logProcessDeploymentStatus() {
        Map deploymentsById = ((DeploymentQuery)((DeploymentQuery)this.repositoryService.createDeploymentQuery().orderByDeploymentName().asc()).orderByDeploymentTime().desc()).list().stream().collect(Collectors.toMap(Deployment::getId, Function.identity()));
        List definitions = ((ProcessDefinitionQuery)((ProcessDefinitionQuery)((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().orderByProcessDefinitionKey().asc()).orderByVersionTag().asc()).orderByProcessDefinitionVersion().asc()).list();
        for (ProcessDefinition def : definitions) {
            Deployment dep = (Deployment)deploymentsById.get(def.getDeploymentId());
            if (def.isSuspended()) {
                logger.debug("Suspended process {}/{} (internal version {}) from {} deployed {}", new Object[]{def.getKey(), def.getVersionTag(), def.getVersion(), dep.getSource(), dep.getDeploymentTime()});
                continue;
            }
            logger.info("Active process {}/{} (internal version {}) from {} deployed {}", new Object[]{def.getKey(), def.getVersionTag(), def.getVersion(), dep.getSource(), dep.getDeploymentTime()});
        }
    }

    private void deploy(BpmnFileAndModel fileAndModel) {
        ProcessIdAndVersion processKeyAndVersion = fileAndModel.getProcessIdAndVersion();
        DeploymentBuilder builder = this.repositoryService.createDeployment().name(processKeyAndVersion.toString()).source(fileAndModel.getFile()).addModelInstance(fileAndModel.getFile(), fileAndModel.getModel()).enableDuplicateFiltering(true);
        Deployment deployment = builder.deploy();
        logger.debug("Process {} from {}://{} deployed with id {}", new Object[]{processKeyAndVersion.toString(), fileAndModel.getJar().toString(), fileAndModel.getFile(), deployment.getId()});
        if (fileAndModel.isDraft()) {
            List activeDraftDefinitions = ((ProcessDefinitionQuery)this.repositoryService.createProcessDefinitionQuery().processDefinitionKey(processKeyAndVersion.getId()).versionTag(processKeyAndVersion.getVersion()).orderByDeploymentTime().desc()).active().list();
            activeDraftDefinitions.stream().skip(1L).forEach(def -> {
                logger.debug("Suspending existing draft process definition {} from deployment with id {}", (Object)processKeyAndVersion.toString(), (Object)def.getDeploymentId());
                this.repositoryService.suspendProcessDefinitionById(def.getId());
            });
        }
    }
}

