/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import dev.dsf.bpe.plugin.BpmnFileAndModel;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import dev.dsf.bpe.plugin.ProcessPlugin;
import dev.dsf.bpe.v1.constants.NamingSystems;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.JavaDelegate;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.variable.serializer.TypedValueSerializer;
import org.camunda.bpm.model.bpmn.Bpmn;
import org.camunda.bpm.model.bpmn.BpmnModelInstance;
import org.camunda.bpm.model.bpmn.instance.EndEvent;
import org.camunda.bpm.model.bpmn.instance.ExtensionElements;
import org.camunda.bpm.model.bpmn.instance.FlowNode;
import org.camunda.bpm.model.bpmn.instance.IntermediateThrowEvent;
import org.camunda.bpm.model.bpmn.instance.MessageEventDefinition;
import org.camunda.bpm.model.bpmn.instance.Process;
import org.camunda.bpm.model.bpmn.instance.SendTask;
import org.camunda.bpm.model.bpmn.instance.ServiceTask;
import org.camunda.bpm.model.bpmn.instance.SubProcess;
import org.camunda.bpm.model.bpmn.instance.UserTask;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaExecutionListener;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaField;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperties;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaProperty;
import org.camunda.bpm.model.bpmn.instance.camunda.CamundaTaskListener;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.ActivityDefinition;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Library;
import org.hl7.fhir.r4.model.Measure;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Task;
import org.hl7.fhir.r4.model.ValueSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;

public abstract class AbstractProcessPlugin<D, A>
implements ProcessPlugin<D, A> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProcessPlugin.class);
    private static final String BPMN_SUFFIX = ".bpmn";
    private static final String JSON_SUFFIX = ".json";
    private static final String XML_SUFFIX = ".xml";
    private static final String RESOURCE_VERSION_PATTERN_STRING = "(?<resourceVersion>\\d+\\.\\d+)";
    private static final Pattern RESOURCE_VERSION_PATTERN = Pattern.compile("(?<resourceVersion>\\d+\\.\\d+)");
    private static final String VERSION_PATTERN_STRING = "(?<pluginVersion>(?<resourceVersion>\\d+\\.\\d+)\\.\\d+\\.\\d+)";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(?<pluginVersion>(?<resourceVersion>\\d+\\.\\d+)\\.\\d+\\.\\d+)");
    private static final String VERSION_PLACEHOLDER_PATTERN_STRING = "#{version}";
    private static final Pattern VERSION_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("#{version}"));
    private static final String DATE_PLACEHOLDER_PATTERN_STRING = "#{date}";
    private static final Pattern DATE_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("#{date}"));
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String ORGANIZATION_PLACEHOLDER_PATTERN_STRING = "#{organization}";
    private static final Pattern ORGANIZATION_PLACEHOLDER_PATTERN = Pattern.compile(Pattern.quote("#{organization}"));
    private static final String PLACEHOLDER_PREFIX_SPRING = "${";
    private static final String PLACEHOLDER_PREFIX_SPRING_ESCAPED = "\\${";
    private static final String PLACEHOLDER_PREFIX_TMP = "\u00a7{";
    private static final String PLACEHOLDER_PREFIX = "#{";
    private static final Pattern PLACEHOLDER_PREFIX_PATTERN_SPRING = Pattern.compile(Pattern.quote("${"));
    private static final Pattern PLACEHOLDER_PREFIX_PATTERN_TMP = Pattern.compile(Pattern.quote("\u00a7{"));
    private static final Pattern PLACEHOLDER_PREFIX_PATTERN = Pattern.compile(Pattern.quote("#{"));
    private static final String ACTIVITY_DEFINITION_URL_PATTERN_STRING = "^(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))$";
    private static final Pattern ACTIVITY_DEFINITION_URL_PATTERN = Pattern.compile("^(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))$");
    private static final String INSTANTIATES_CANONICAL_PATTERN_STRING = "(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$";
    private static final Pattern INSTANTIATES_CANONICAL_PATTERN = Pattern.compile("(?<processUrl>http[s]{0,1}://(?<domain>(?:(?:[a-zA-Z0-9]{1,63}|[a-zA-Z0-9][a-zA-Z0-9-]{0,61}[a-zA-Z0-9])\\.)+(?:[a-zA-Z0-9]{1,63}))/bpe/Process/(?<processName>[a-zA-Z0-9-]+))\\|(?<processVersion>\\d+\\.\\d+)$");
    private static final String PROCESS_ID_PATTERN_STRING = "^(?<domainNoDots>[a-zA-Z0-9-]+)_(?<processName>[a-zA-Z0-9-]+)$";
    private static final Pattern PROCESS_ID_PATTERN = Pattern.compile("^(?<domainNoDots>[a-zA-Z0-9-]+)_(?<processName>[a-zA-Z0-9-]+)$");
    private static final String DEFAULT_PROCESS_HISTORY_TIME_TO_LIVE = "P30D";
    private final D processPluginDefinition;
    private final A processPluginApi;
    private final boolean draft;
    private final Path jarFile;
    private final ClassLoader processPluginClassLoader;
    private final FhirContext fhirContext;
    private final ConfigurableEnvironment environment;
    private boolean initialized;
    private AnnotationConfigApplicationContext applicationContext;
    private List<BpmnFileAndModel> processModels;
    private Map<ProcessIdAndVersion, List<FileAndResource>> fhirResources;

    public AbstractProcessPlugin(D processPluginDefinition, A processPluginApi, boolean draft, Path jarFile, ClassLoader processPluginClassLoader, FhirContext fhirContext, ConfigurableEnvironment environment) {
        Objects.requireNonNull(processPluginDefinition, "definition");
        Objects.requireNonNull(processPluginApi, "processPluginApi");
        Objects.requireNonNull(jarFile, "jarFile");
        Objects.requireNonNull(processPluginClassLoader, "processPluginClassLoader");
        Objects.requireNonNull(fhirContext, "fhirContext");
        Objects.requireNonNull(environment, "environment");
        this.processPluginDefinition = processPluginDefinition;
        this.processPluginApi = processPluginApi;
        this.draft = draft;
        this.jarFile = jarFile;
        this.processPluginClassLoader = processPluginClassLoader;
        this.fhirContext = fhirContext;
        this.environment = environment;
    }

    protected abstract List<Class<?>> getDefinitionSpringConfigurations();

    protected abstract String getDefinitionName();

    protected abstract String getDefinitionVersion();

    protected abstract String getDefinitionResourceVersion();

    protected abstract LocalDate getDefinitionReleaseDate();

    protected abstract LocalDate getDefinitionResourceReleaseDate();

    protected abstract Map<String, List<String>> getDefinitionFhirResourcesByProcessId();

    protected abstract List<String> getDefinitionProcessModels();

    protected abstract Class<?> getDefaultSpringConfiguration();

    protected abstract String getProcessPluginApiVersion();

    @Override
    public boolean initializeAndValidateResources(String localOrganizationIdentifierValue) {
        if (this.initialized) {
            return true;
        }
        boolean pluginDefinitionOk = this.validatePluginDefinitionValues();
        if (!pluginDefinitionOk) {
            return false;
        }
        Map<ProcessIdAndVersion, List<FileAndResource>> resources = this.loadFhirResources(localOrganizationIdentifierValue);
        if (resources.isEmpty()) {
            logger.warn("Ignoring process plugin {}-{} from {}: No valid FHIR resources", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString()});
            return false;
        }
        List<BpmnFileAndModel> models = this.filterNonValidBpmnModels(this.loadBpmnModels(localOrganizationIdentifierValue));
        if (models.isEmpty()) {
            logger.warn("Ignoring process plugin {}-{} from {}: No valid processes", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString()});
            return false;
        }
        Map<String, Integer> processCounts = models.stream().collect(Collectors.toMap(m -> m.getProcessIdAndVersion().getId(), m -> 1, (c1, c2) -> c1 + c2));
        if (processCounts.values().stream().anyMatch(c -> c > 1)) {
            logger.warn("Ignoring process plugin {}-{} from {}: Processes with duplicate IDs found {}", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), processCounts.entrySet().stream().filter(e -> (Integer)e.getValue() > 1).map(Map.Entry::getKey).toList()});
            return false;
        }
        AnnotationConfigApplicationContext context = this.createApplicationContext();
        if (context == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: Unable to initialize spring context", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString()});
            return false;
        }
        if ((models = this.filterBpmnModelsWithoutMatchingActivityDefinitions(resources, this.filterBpmnModelsWithNotAvailableBeans(models, (ApplicationContext)context))).isEmpty()) {
            logger.warn("Ignoring process plugin {}-{} from {}: No valid processes", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString()});
            return false;
        }
        this.applicationContext = context;
        this.processModels = models;
        this.fhirResources = this.filterResourcesOfNotAvailableProcesses(resources, models);
        this.initialized = true;
        return true;
    }

    private boolean validatePluginDefinitionValues() {
        boolean nameOk = this.validateName();
        boolean versionOk = this.validateVersion();
        boolean resourceVersionOk = this.validateResourceVersion();
        boolean releaseDateOk = this.validateReleaseDate();
        boolean resourceReleaseDateOk = this.validateResourceReleaseDate();
        boolean springConfigurationOk = this.validateSpringConfigurations();
        boolean fhirResourcesOk = this.validateFhirResources();
        boolean processModelsOk = this.validateProcessModels();
        return nameOk && versionOk && resourceVersionOk && releaseDateOk && resourceReleaseDateOk && springConfigurationOk && fhirResourcesOk && processModelsOk;
    }

    private boolean validateSpringConfigurations() {
        List<Class<?>> springConfigurations = this.getDefinitionSpringConfigurations();
        if (springConfigurations == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} spring configurations null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (springConfigurations.isEmpty()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} spring configurations empty", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        List<String> invalidConfigurationClasses = springConfigurations.stream().filter(c -> c.getAnnotation(Configuration.class) == null).map(Class::getName).toList();
        if (!invalidConfigurationClasses.isEmpty()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} spring configuration classes without {} annotation: {}", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName(), Configuration.class.getName(), invalidConfigurationClasses.toString()});
            return false;
        }
        return true;
    }

    private boolean validateName() {
        String name = this.getDefinitionName();
        if (name == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} name null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (name.isBlank()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} name blank", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        return true;
    }

    private boolean validateVersion() {
        String version = this.getDefinitionVersion();
        if (version == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} version null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (version.isBlank()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} version blank", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (!VERSION_PATTERN.matcher(version).matches()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} version not matching {}", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName(), VERSION_PATTERN_STRING});
            return false;
        }
        return true;
    }

    private boolean validateResourceVersion() {
        String resourceVersion = this.getDefinitionResourceVersion();
        if (resourceVersion == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} resource version null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (resourceVersion.isBlank()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} resource version blank", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (!RESOURCE_VERSION_PATTERN.matcher(resourceVersion).matches()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} version not matching {}", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName(), RESOURCE_VERSION_PATTERN_STRING});
            return false;
        }
        return true;
    }

    private boolean validateReleaseDate() {
        LocalDate releaseDate = this.getDefinitionReleaseDate();
        if (releaseDate == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} release date null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        return true;
    }

    private boolean validateResourceReleaseDate() {
        LocalDate resourceReleaseDate = this.getDefinitionResourceReleaseDate();
        if (resourceReleaseDate == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} resource release date null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        return true;
    }

    private boolean validateFhirResources() {
        Map<String, List<String>> fhirResources = this.getDefinitionFhirResourcesByProcessId();
        if (fhirResources == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} fhir resources map null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (fhirResources.isEmpty()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} fhir resources map empty", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        return true;
    }

    private boolean validateProcessModels() {
        List<String> processModels = this.getDefinitionProcessModels();
        if (processModels == null) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} process models null", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        if (processModels.isEmpty()) {
            logger.warn("Ignoring process plugin {}-{} from {}: {} process models empty", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), this.getJarFile().toString(), this.processPluginDefinition.getClass().getSimpleName()});
            return false;
        }
        return true;
    }

    @Override
    public D getProcessPluginDefinition() {
        return this.processPluginDefinition;
    }

    @Override
    public A getProcessPluginApi() {
        return this.processPluginApi;
    }

    @Override
    public boolean isDraft() {
        return this.draft;
    }

    @Override
    public Path getJarFile() {
        return this.jarFile;
    }

    @Override
    public ClassLoader getProcessPluginClassLoader() {
        return this.processPluginClassLoader;
    }

    @Override
    public ApplicationContext getApplicationContext() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.applicationContext;
    }

    @Override
    public List<TypedValueSerializer> getTypedValueSerializers() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.applicationContext.getBeansOfType(TypedValueSerializer.class).values().stream().distinct().toList();
    }

    @Override
    public List<ProcessIdAndVersion> getProcessKeysAndVersions() {
        return this.getProcessModels().stream().map(BpmnFileAndModel::getProcessIdAndVersion).toList();
    }

    @Override
    public List<BpmnFileAndModel> getProcessModels() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return Collections.unmodifiableList(this.processModels);
    }

    @Override
    public Map<ProcessIdAndVersion, List<Resource>> getFhirResources() {
        if (!this.initialized) {
            throw new IllegalStateException("not initialized");
        }
        return this.fhirResources.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(FileAndResource::getResource).toList()));
    }

    private ApplicationContext createParentApplicationContext() {
        DefaultListableBeanFactory factory = new DefaultListableBeanFactory();
        factory.registerSingleton("processPluginApi", this.getProcessPluginApi());
        GenericApplicationContext context = new GenericApplicationContext(factory);
        context.refresh();
        return context;
    }

    private AnnotationConfigApplicationContext createApplicationContext() {
        try {
            AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
            context.setParent(this.createParentApplicationContext());
            context.setClassLoader(this.getProcessPluginClassLoader());
            context.register((Class[])Stream.concat(Stream.of(this.getDefaultSpringConfiguration()), this.getDefinitionSpringConfigurations().stream()).toArray(Class[]::new));
            context.setEnvironment(this.environment);
            context.refresh();
            return context;
        }
        catch (BeanCreationException e) {
            logger.error("Unable to create spring application context for process plugin {}-{}: {} {}", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), ((Object)((Object)e)).getClass().getSimpleName(), e.getMessage()});
            logger.debug("Unable to create spring application context for process plugin " + this.getDefinitionName() + "-" + this.getDefinitionVersion() + ", bean with error " + e.getBeanName(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("Unable to create spring application context for process plugin {}-{}: {} {}", new Object[]{this.getDefinitionName(), this.getDefinitionVersion(), e.getClass().getSimpleName(), e.getMessage()});
            logger.debug("Unable to create spring application context for process plugin " + this.getDefinitionName() + "-" + this.getDefinitionVersion(), (Throwable)e);
            return null;
        }
    }

    private Stream<BpmnFileAndModel> loadBpmnModels(String localOrganizationIdentifierValue) {
        return this.getDefinitionProcessModels().stream().map(this.loadBpmnModelOrNull(localOrganizationIdentifierValue)).filter(Objects::nonNull);
    }

    private Function<String, BpmnFileAndModel> loadBpmnModelOrNull(String localOrganizationIdentifierValue) {
        return file -> {
            if (!file.endsWith(BPMN_SUFFIX)) {
                logger.warn("Ignoring BPMN model {} from process plugin {}-{}: Filename not ending in '{}'", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), BPMN_SUFFIX});
                return null;
            }
            String resourceDateValue = this.getDefinitionResourceReleaseDate().format(DATE_FORMAT);
            logger.debug("Reading BPMN model {} from process plugin {}-{} and replacing all occurrences of {} with {}, {} with {} and {} with {}", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), VERSION_PLACEHOLDER_PATTERN_STRING, this.getDefinitionResourceVersion(), DATE_PLACEHOLDER_PATTERN_STRING, resourceDateValue, ORGANIZATION_PLACEHOLDER_PATTERN_STRING, localOrganizationIdentifierValue});
            try (InputStream in = this.getProcessPluginClassLoader().getResourceAsStream((String)file);){
                if (in == null) {
                    logger.warn("Ignoring BPMN model {} from process plugin {}-{}: File not readable, process plugin class loader getResourceAsStream returned null", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
                    BpmnFileAndModel bpmnFileAndModel2 = null;
                    return bpmnFileAndModel2;
                }
                String content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                content = VERSION_PLACEHOLDER_PATTERN.matcher(content).replaceAll(this.getDefinitionResourceVersion());
                content = DATE_PLACEHOLDER_PATTERN.matcher(content).replaceAll(resourceDateValue);
                content = ORGANIZATION_PLACEHOLDER_PATTERN.matcher(content).replaceAll(localOrganizationIdentifierValue != null ? localOrganizationIdentifierValue : "null");
                content = PLACEHOLDER_PREFIX_PATTERN_SPRING.matcher(content).replaceAll(PLACEHOLDER_PREFIX_TMP);
                content = PLACEHOLDER_PREFIX_PATTERN.matcher(content).replaceAll(PLACEHOLDER_PREFIX_SPRING_ESCAPED);
                content = this.environment.resolveRequiredPlaceholders(content);
                content = PLACEHOLDER_PREFIX_PATTERN_TMP.matcher(content).replaceAll(PLACEHOLDER_PREFIX_SPRING_ESCAPED);
                BpmnModelInstance model = Bpmn.readModelFromStream((InputStream)new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)));
                Collection processes = model.getModelElementsByType(Process.class);
                processes.forEach(process -> {
                    ExtensionElements ext = this.getOrCreateExtensionElements((Process)process);
                    CamundaProperties properties = ext.getChildElementsByType(CamundaProperties.class).stream().findFirst().orElseGet(() -> {
                        CamundaProperties p = (CamundaProperties)ext.getModelInstance().newInstance(CamundaProperties.class);
                        ext.addChildElement((ModelElementInstance)p);
                        return p;
                    });
                    CamundaProperty property = properties.getCamundaProperties().stream().filter(p -> "dsf.process.api.version".equals(p.getCamundaName())).findFirst().orElseGet(() -> {
                        CamundaProperty p = (CamundaProperty)properties.getModelInstance().newInstance(CamundaProperty.class);
                        properties.addChildElement((ModelElementInstance)p);
                        return p;
                    });
                    property.setCamundaName("dsf.process.api.version");
                    property.setCamundaValue(this.getProcessPluginApiVersion());
                    if (process.getCamundaHistoryTimeToLiveString() == null || process.getCamundaHistoryTimeToLiveString().isBlank()) {
                        if (this.isDraft()) {
                            logger.info("Setting process history time to live for process {} from {} to {}", new Object[]{process.getId(), this.jarFile.toString(), DEFAULT_PROCESS_HISTORY_TIME_TO_LIVE});
                        } else {
                            logger.debug("Setting process history time to live for process {} from {} to {}", new Object[]{process.getId(), this.jarFile.toString(), DEFAULT_PROCESS_HISTORY_TIME_TO_LIVE});
                        }
                        process.setCamundaHistoryTimeToLiveString(DEFAULT_PROCESS_HISTORY_TIME_TO_LIVE);
                    }
                });
                BpmnFileAndModel bpmnFileAndModel = new BpmnFileAndModel(this.draft, (String)file, model, this.getJarFile());
                return bpmnFileAndModel;
            }
            catch (IOException e) {
                logger.warn("Ignoring BPMN model {} from process plugin {}-{}: {} - {}", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), e.getClass().getName(), e.getMessage()});
                return null;
            }
        };
    }

    private ExtensionElements getOrCreateExtensionElements(Process process) {
        ExtensionElements ext = process.getExtensionElements();
        if (ext == null) {
            ext = (ExtensionElements)process.getModelInstance().newInstance(ExtensionElements.class);
            process.setExtensionElements(ext);
        }
        return ext;
    }

    private List<BpmnFileAndModel> filterNonValidBpmnModels(Stream<BpmnFileAndModel> models) {
        return models.filter(this::isValid).toList();
    }

    private boolean isValid(BpmnFileAndModel fileAndModel) {
        try {
            Bpmn.validateModel((BpmnModelInstance)fileAndModel.getModel());
        }
        catch (Exception e) {
            logger.warn("BPMN file {} not valid: {} - {}", new Object[]{fileAndModel.getFile(), e.getClass().getName(), e.getMessage()});
            return false;
        }
        Collection processes = fileAndModel.getModel().getModelElementsByType(Process.class);
        if (processes.size() != 1) {
            logger.warn("BPMN file {} contains {} processes, expected 1", (Object)fileAndModel.getFile(), (Object)processes.size());
            return false;
        }
        ProcessIdAndVersion processKeyAndVersion = fileAndModel.getProcessIdAndVersion();
        if (!this.getDefinitionResourceVersion().equals(processKeyAndVersion.getVersion())) {
            logger.warn("Camunda version tag of process in '{}' does not match process plugin version (tag: {} vs. plugin: {})", new Object[]{fileAndModel.getFile(), processKeyAndVersion.getVersion(), this.getDefinitionVersion()});
            return false;
        }
        if (!PROCESS_ID_PATTERN.matcher(processKeyAndVersion.getId()).matches()) {
            logger.warn("ID of process in '{}' does not match {}", (Object)fileAndModel.getFile(), (Object)PROCESS_ID_PATTERN_STRING);
            return false;
        }
        return true;
    }

    private Stream<BpmnFileAndModel> filterBpmnModelsWithNotAvailableBeans(List<BpmnFileAndModel> models, ApplicationContext applicationContext) {
        return models.stream().filter(this.beanAvailableForModel(applicationContext));
    }

    private Predicate<BpmnFileAndModel> beanAvailableForModel(ApplicationContext applicationContext) {
        return fileAndModel -> {
            Collection processes = fileAndModel.getModel().getModelElementsByType(Process.class);
            return processes.stream().allMatch(this.beanAvailable(applicationContext));
        };
    }

    private Predicate<Process> beanAvailable(ApplicationContext applicationContext) {
        return process -> this.beanAvailable((ModelElementInstance)process, (Process)process, applicationContext);
    }

    private boolean beanAvailable(ModelElementInstance parent, Process process, ApplicationContext applicationContext) {
        boolean serviceTasksOk = parent.getChildElementsByType(ServiceTask.class).stream().filter(Objects::nonNull).allMatch(t -> this.beanAvailable(process, t.getId(), t.getCamundaClass(), JavaDelegate.class, applicationContext));
        boolean sendTasksOk = parent.getChildElementsByType(SendTask.class).stream().filter(Objects::nonNull).allMatch(t -> this.beanAvailable(process, t.getId(), t.getCamundaClass(), JavaDelegate.class, applicationContext) && this.taskFieldsAvailable(process, "SendTask", t.getId(), t.getExtensionElements()));
        boolean userTasksTaskListenersOk = parent.getChildElementsByType(UserTask.class).stream().filter(Objects::nonNull).allMatch(t -> t.getChildElementsByType(ExtensionElements.class).stream().filter(Objects::nonNull).flatMap(e -> e.getChildElementsByType(CamundaTaskListener.class).stream()).filter(Objects::nonNull).allMatch(l -> this.beanAvailable(process, t.getId(), l.getCamundaClass(), TaskListener.class, applicationContext)));
        boolean allElementsExecutionListenersOk = parent.getChildElementsByType(FlowNode.class).stream().filter(Objects::nonNull).allMatch(n -> n.getChildElementsByType(ExtensionElements.class).stream().filter(Objects::nonNull).flatMap(e -> e.getChildElementsByType(CamundaExecutionListener.class).stream()).filter(Objects::nonNull).allMatch(l -> this.beanAvailable(process, n.getId(), l.getCamundaClass(), ExecutionListener.class, applicationContext)));
        boolean intermediateMessageThrowEventsOk = parent.getChildElementsByType(IntermediateThrowEvent.class).stream().filter(Objects::nonNull).flatMap(e -> e.getEventDefinitions().stream().filter(Objects::nonNull).filter(def -> def instanceof MessageEventDefinition)).map(def -> (MessageEventDefinition)def).allMatch(def -> this.beanAvailable(process, def.getId(), def.getCamundaClass(), JavaDelegate.class, applicationContext) && this.taskFieldsAvailable(process, "IntermediateThrowEvent", def.getId(), def.getExtensionElements()));
        boolean endEventsOk = parent.getChildElementsByType(EndEvent.class).stream().filter(Objects::nonNull).allMatch(e -> e.getEventDefinitions().stream().filter(Objects::nonNull).filter(def -> def instanceof MessageEventDefinition).map(def -> (MessageEventDefinition)def).allMatch(def -> this.beanAvailable(process, def.getId(), def.getCamundaClass(), JavaDelegate.class, applicationContext) && this.taskFieldsAvailable(process, "MessageEndEvent", e.getId(), def.getExtensionElements())));
        boolean subProcessesOk = parent.getChildElementsByType(SubProcess.class).stream().filter(Objects::nonNull).allMatch(subProcess -> this.beanAvailable((ModelElementInstance)subProcess, process, applicationContext));
        return serviceTasksOk && sendTasksOk && userTasksTaskListenersOk && allElementsExecutionListenersOk && intermediateMessageThrowEventsOk && endEventsOk && subProcessesOk;
    }

    public boolean taskFieldsAvailable(Process process, String elementType, String elementId, ExtensionElements extensionElements) {
        Set<CamundaField> fields = extensionElements == null ? Collections.emptySet() : extensionElements.getChildElementsByType(CamundaField.class);
        String instantiatesCanonical = null;
        String messageName = null;
        String profile = null;
        for (CamundaField field : fields) {
            if ("profile".equals(field.getCamundaName())) {
                profile = field.getTextContent();
                continue;
            }
            if ("messageName".equals(field.getCamundaName())) {
                messageName = field.getTextContent();
                continue;
            }
            if (!"instantiatesCanonical".equals(field.getCamundaName())) continue;
            instantiatesCanonical = field.getTextContent();
        }
        if (instantiatesCanonical == null || instantiatesCanonical.isBlank() || messageName == null || messageName.isBlank() || profile == null || profile.isBlank()) {
            String noInstantiatesCanonical = instantiatesCanonical == null || instantiatesCanonical.isBlank() ? "instantiatesCanonical" : null;
            String noMessageName = messageName == null || messageName.isBlank() ? "messageName" : null;
            String noProfile = profile == null || profile.isBlank() ? "profile" : null;
            String message = Stream.of(noInstantiatesCanonical, noMessageName, noProfile).filter(Objects::nonNull).collect(Collectors.joining(", "));
            logger.warn("Mandatory fields in {} with id {} of process {}|{} not defined: {} missing", new Object[]{elementType, elementId, process.getId(), process.getCamundaVersionTag(), message});
        }
        return instantiatesCanonical != null && !instantiatesCanonical.isBlank() && messageName != null && !messageName.isBlank() && profile != null && !profile.isBlank();
    }

    private boolean beanAvailable(Process process, String elementId, String className, Class<?> expectedInterface, ApplicationContext applicationContext) {
        if (className == null || className.isBlank()) {
            return true;
        }
        ProcessIdAndVersion processKeyAndVersion = new ProcessIdAndVersion(process.getId(), process.getCamundaVersionTag());
        Class<?> serviceClass = this.loadClass(processKeyAndVersion, elementId, expectedInterface, className);
        if (serviceClass == null) {
            return false;
        }
        return this.isPrototypeBeanAvailable(processKeyAndVersion, elementId, expectedInterface, applicationContext, serviceClass);
    }

    private Class<?> loadClass(ProcessIdAndVersion processKeyAndVersion, String elementId, Class<?> expectedInterface, String className) {
        try {
            ClassLoader classLoader = this.getProcessPluginClassLoader();
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            logger.warn("{} '{}' defined in process {}, element {} not found", new Object[]{expectedInterface.getSimpleName(), className, processKeyAndVersion.toString(), elementId});
            logger.debug(expectedInterface.getSimpleName() + " '" + className + "' defined in process " + processKeyAndVersion.toString() + " not found", (Throwable)e);
            return null;
        }
    }

    private boolean isPrototypeBeanAvailable(ProcessIdAndVersion processKeyAndVersion, String elementId, Class<?> expectedInterface, ApplicationContext applicationContext, Class<?> serviceClass) {
        String[] beanNames = applicationContext.getBeanNamesForType(serviceClass);
        if (beanNames.length <= 0) {
            logger.warn("Unable to find prototype bean of type {} for element {} in process {}", new Object[]{serviceClass.getName(), elementId, processKeyAndVersion.toString()});
            return false;
        }
        if (beanNames.length > 1) {
            logger.warn("Unable to find unique prototype bean of type {} for element {} in process {}, found {}", new Object[]{serviceClass.getName(), elementId, processKeyAndVersion.toString(), beanNames.length});
            return false;
        }
        boolean isPrototype = applicationContext.isPrototype(beanNames[0]);
        boolean implementsInterface = expectedInterface.isAssignableFrom(serviceClass);
        if (!isPrototype || !implementsInterface) {
            String notPrototype = !isPrototype ? "Bean not declared with 'prototype' scope" : null;
            String notImplementingInterface = !implementsInterface ? serviceClass.getSimpleName() + " not implementing " + expectedInterface.getSimpleName() : null;
            String message = Stream.of(notPrototype, notImplementingInterface).filter(Objects::nonNull).collect(Collectors.joining(", "));
            logger.warn("Unable to find prototype bean of type {} implementing {} for element {} in process {}: {}", new Object[]{serviceClass.getName(), expectedInterface.getName(), elementId, processKeyAndVersion.toString(), message});
        }
        return isPrototype && implementsInterface;
    }

    private Map<ProcessIdAndVersion, List<FileAndResource>> loadFhirResources(String localOrganizationIdentifierValue) {
        Map<String, Resource> resourcesByFilename = this.getDefinitionFhirResourcesByProcessId().entrySet().stream().map(Map.Entry::getValue).flatMap(Collection::stream).distinct().map(this.loadFhirResourceOrNull(localOrganizationIdentifierValue)).filter(Objects::nonNull).collect(Collectors.toMap(FileAndResource::getFile, FileAndResource::getResource));
        return this.getDefinitionFhirResourcesByProcessId().entrySet().stream().collect(Collectors.toMap(e -> new ProcessIdAndVersion((String)e.getKey(), this.getDefinitionResourceVersion()), e -> ((List)e.getValue()).stream().filter(resourcesByFilename::containsKey).map(file -> FileAndResource.of(file, (Resource)resourcesByFilename.get(file))).toList()));
    }

    private Function<String, FileAndResource> loadFhirResourceOrNull(String localOrganizationIdentifierValue) {
        return file -> {
            if (!file.endsWith(JSON_SUFFIX) && !file.endsWith(XML_SUFFIX)) {
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Filename not ending in '{}' or '{}'", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), JSON_SUFFIX, XML_SUFFIX});
                return null;
            }
            String resourceDateValue = this.getDefinitionResourceReleaseDate().format(DATE_FORMAT);
            logger.debug("Reading FHIR resource {} from process plugin {}-{} and replacing all occurrences of {} with {}, {} with {} and {} with {}", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), VERSION_PLACEHOLDER_PATTERN_STRING, this.getDefinitionResourceVersion(), DATE_PLACEHOLDER_PATTERN_STRING, resourceDateValue, ORGANIZATION_PLACEHOLDER_PATTERN_STRING, localOrganizationIdentifierValue});
            try (InputStream in = this.getProcessPluginClassLoader().getResourceAsStream((String)file);){
                if (in == null) {
                    logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Not readable, process plugin class loader getResourceAsStream returned null", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
                    FileAndResource fileAndResource = null;
                    return fileAndResource;
                }
                String content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
                content = VERSION_PLACEHOLDER_PATTERN.matcher(content).replaceAll(this.getDefinitionResourceVersion());
                content = DATE_PLACEHOLDER_PATTERN.matcher(content).replaceAll(resourceDateValue);
                content = ORGANIZATION_PLACEHOLDER_PATTERN.matcher(content).replaceAll(localOrganizationIdentifierValue != null ? localOrganizationIdentifierValue : "null");
                content = PLACEHOLDER_PREFIX_PATTERN.matcher(content).replaceAll(PLACEHOLDER_PREFIX_SPRING_ESCAPED);
                content = this.environment.resolveRequiredPlaceholders(content);
                IBaseResource resource = this.newParser((String)file).parseResource(content);
                if (resource instanceof ActivityDefinition && this.isValid((ActivityDefinition)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof CodeSystem && this.isValid((CodeSystem)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof Library && this.isValid((Library)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof Measure && this.isValid((Measure)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof NamingSystem && this.isValid((NamingSystem)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof Questionnaire && this.isValid((Questionnaire)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof StructureDefinition && this.isValid((StructureDefinition)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof Task && this.isValid((Task)resource, (String)file, localOrganizationIdentifierValue)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                if (resource instanceof ValueSet && this.isValid((ValueSet)resource, (String)file)) {
                    FileAndResource fileAndResource = FileAndResource.of(file, (Resource)resource);
                    return fileAndResource;
                }
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Not a ActivityDefinition, CodeSystem, Library, Measure, NamingSystem, Questionnaire, StructureDefinition, Task or ValueSet", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
                FileAndResource fileAndResource = null;
                return fileAndResource;
            }
            catch (IOException e) {
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: {} - {}", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), e.getClass().getName(), e.getMessage()});
                return null;
            }
        };
    }

    private IParser newParser(String file) {
        if (file.endsWith(JSON_SUFFIX)) {
            return this.fhirContext.newJsonParser();
        }
        if (file.endsWith(XML_SUFFIX)) {
            return this.fhirContext.newXmlParser();
        }
        throw new IllegalArgumentException("FHIR resource filename not ending in .json or .xml");
    }

    private boolean isValidMetadataResouce(MetadataResource resource, String file) {
        boolean versionOk;
        boolean urlOk = resource.hasUrl();
        boolean versionDefined = resource.hasVersion();
        boolean bl = versionOk = versionDefined && resource.getVersion().equals(this.getDefinitionResourceVersion());
        if (!urlOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: {}.url empty", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), resource.getResourceType().name()});
        }
        if (!versionDefined) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: {}.version empty", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), resource.getResourceType().name()});
        } else if (!versionOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: {}.version not equal to {} but {}", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), resource.getResourceType().name(), this.getDefinitionResourceVersion(), resource.getVersion()});
        }
        return urlOk && versionOk;
    }

    private boolean isValid(ActivityDefinition resource, String file) {
        boolean metadataResourceOk = this.isValidMetadataResouce((MetadataResource)resource, file);
        boolean urlOk = ACTIVITY_DEFINITION_URL_PATTERN.matcher(resource.getUrl()).matches();
        if (!urlOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: ActivityDefinition.url not matching {}", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), ACTIVITY_DEFINITION_URL_PATTERN_STRING});
        }
        return metadataResourceOk && urlOk;
    }

    private boolean isValid(CodeSystem resource, String file) {
        return this.isValidMetadataResouce((MetadataResource)resource, file);
    }

    private boolean isValid(Library resource, String file) {
        return this.isValidMetadataResouce((MetadataResource)resource, file);
    }

    private boolean isValid(Measure resource, String file) {
        return this.isValidMetadataResouce((MetadataResource)resource, file);
    }

    private boolean isValid(NamingSystem resource, String file) {
        boolean nameOk = resource.hasName();
        if (!nameOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: NamingSystem.name empty", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
        }
        return nameOk;
    }

    private boolean isValid(Questionnaire resource, String file) {
        return this.isValidMetadataResouce((MetadataResource)resource, file);
    }

    private boolean isValid(StructureDefinition resource, String file) {
        return this.isValidMetadataResouce((MetadataResource)resource, file);
    }

    private boolean isValid(Task resource, String file, String localOrganizationIdentifierValue) {
        boolean outputOk;
        Optional identifier = NamingSystems.TaskIdentifier.findFirst((Task)resource);
        boolean identifierOk = false;
        if (identifier.isEmpty()) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: No Task.identifier with system '{}'", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), "http://dsf.dev/sid/task-identifier"});
        } else {
            boolean bl = identifierOk = ((Identifier)identifier.get()).hasValue() && !((Identifier)identifier.get()).getValue().contains("|");
            if (!identifierOk) {
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: No Task.identifier with system '{}' and value, or value contains | character", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), "http://dsf.dev/sid/task-identifier"});
            }
        }
        boolean statusOk = Task.TaskStatus.DRAFT.equals((Object)resource.getStatus());
        if (!statusOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.status not '{}'", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), Task.TaskStatus.DRAFT.toCode()});
        }
        boolean requesterOk = false;
        if (!resource.hasRequester()) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.requester not defined", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
        } else {
            requesterOk = this.isLocalOrganization(resource.getRequester(), "requester", file, localOrganizationIdentifierValue);
        }
        boolean recipientOk = false;
        if (!resource.hasRestriction() || !resource.getRestriction().hasRecipient() || resource.getRestriction().getRecipient().size() != 1) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.restriction.recipient not defined", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
        } else {
            recipientOk = this.isLocalOrganization(resource.getRestriction().getRecipientFirstRep(), "restriction.recipient", file, localOrganizationIdentifierValue);
        }
        boolean instantiatesCanonicalOk = INSTANTIATES_CANONICAL_PATTERN.matcher(resource.getInstantiatesCanonical()).matches();
        if (!instantiatesCanonicalOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.instantiatesCanonical not matching {}", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), INSTANTIATES_CANONICAL_PATTERN_STRING});
        }
        boolean inputOk = false;
        if (!resource.hasInput()) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.input empty, input parameter with {}|{} expected", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), "http://dsf.dev/fhir/CodeSystem/bpmn-message", "message-name"});
        } else {
            boolean bl = inputOk = resource.getInput().stream().filter(i -> i.getType().getCoding().stream().anyMatch(c -> "http://dsf.dev/fhir/CodeSystem/bpmn-message".equals(c.getSystem()) && "message-name".equals(c.getCode()))).count() == 1L;
            if (!inputOk) {
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: One input parameter with {}|{} expected", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), "http://dsf.dev/fhir/CodeSystem/bpmn-message", "message-name"});
            }
        }
        boolean bl = outputOk = !resource.hasOutput();
        if (!outputOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.output not empty", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
        }
        return identifierOk && statusOk && requesterOk && recipientOk && instantiatesCanonicalOk && inputOk && outputOk;
    }

    private boolean isLocalOrganization(Reference reference, String refLocation, String file, String localOrganizationIdentifierValue) {
        boolean identifierValueOk;
        if (localOrganizationIdentifierValue == null) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Local organization identifier unknown", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion()});
            return false;
        }
        boolean typeOk = ResourceType.Organization.name().equals(reference.getType());
        boolean identifierSystemOk = reference.hasIdentifier() && "http://dsf.dev/sid/organization-identifier".equals(reference.getIdentifier().getSystem());
        boolean bl = identifierValueOk = reference.hasIdentifier() && localOrganizationIdentifierValue.equals(reference.getIdentifier().getValue());
        if (!typeOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.{}.type not '{}'", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), refLocation, ResourceType.Organization.name()});
        }
        if (!identifierSystemOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.{}.identifier.system not '{}'", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), refLocation, "http://dsf.dev/sid/organization-identifier"});
        }
        if (!identifierValueOk) {
            logger.warn("Ignoring FHIR resource {} from process plugin {}-{}: Task.{}.identifier.value not '{}'", new Object[]{file, this.getDefinitionName(), this.getDefinitionVersion(), refLocation, localOrganizationIdentifierValue});
        }
        return typeOk && identifierSystemOk && identifierValueOk;
    }

    private boolean isValid(ValueSet resource, String file) {
        return this.isValidMetadataResouce((MetadataResource)resource, file);
    }

    private List<BpmnFileAndModel> filterBpmnModelsWithoutMatchingActivityDefinitions(Map<ProcessIdAndVersion, List<FileAndResource>> fhirResources, Stream<BpmnFileAndModel> models) {
        return models.filter(this.hasMatchingActivityDefinition(fhirResources)).toList();
    }

    private Predicate<BpmnFileAndModel> hasMatchingActivityDefinition(Map<ProcessIdAndVersion, List<FileAndResource>> fhirResources) {
        return model -> {
            String processName;
            String processDomain;
            String processId;
            ProcessIdAndVersion processIdAndVersion = model.getProcessIdAndVersion();
            List resources = fhirResources.getOrDefault(processIdAndVersion, Collections.emptyList());
            if (resources.isEmpty()) {
                logger.warn("Ignoring BPMN model {} from process plugin {}-{}: No FHIR metadata resources found for process-id '{}'", new Object[]{model.getFile(), this.getDefinitionName(), this.getDefinitionVersion(), model.getProcessIdAndVersion().getId()});
                return false;
            }
            List<FileAndResource> definitions = resources.stream().filter(r -> r.getResource() instanceof ActivityDefinition).toList();
            if (definitions.size() != 1) {
                logger.warn("Ignoring BPMN model {} from process plugin {}-{}: No ActivityDefinition found for process-id '{}'", new Object[]{model.getFile(), this.getDefinitionName(), this.getDefinitionVersion(), model.getProcessIdAndVersion().getId()});
                return false;
            }
            String url = ((ActivityDefinition)definitions.get(0).getResource()).getUrl();
            Matcher urlMatcher = ACTIVITY_DEFINITION_URL_PATTERN.matcher(url);
            if (urlMatcher.matches() && !(processId = (processDomain = urlMatcher.group("domain").replace(".", "")) + "_" + (processName = urlMatcher.group("processName"))).equals(processIdAndVersion.getId())) {
                logger.warn("Ignoring BPMN model {} from process plugin {}-{}: Found ActivityDefinition.url does not match process id (url: '{}' vs. process-id '{}')", new Object[]{model.getFile(), this.getDefinitionName(), this.getDefinitionVersion(), url, model.getProcessIdAndVersion().getId()});
                return false;
            }
            return true;
        };
    }

    private Map<ProcessIdAndVersion, List<FileAndResource>> filterResourcesOfNotAvailableProcesses(Map<ProcessIdAndVersion, List<FileAndResource>> resources, List<BpmnFileAndModel> models) {
        Set processIds = models.stream().map(BpmnFileAndModel::getProcessIdAndVersion).collect(Collectors.toSet());
        return resources.entrySet().stream().filter(e -> processIds.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, this::filterTasksNotMatchingProcessId));
    }

    private List<FileAndResource> filterTasksNotMatchingProcessId(Map.Entry<ProcessIdAndVersion, List<FileAndResource>> entry) {
        return entry.getValue().stream().filter(fileAndResource -> {
            if (fileAndResource.getResource() instanceof Task) {
                return this.instantiatesCanonicalMatchesProcessIdAndIdentifierValid((ProcessIdAndVersion)entry.getKey(), (FileAndResource)fileAndResource);
            }
            return true;
        }).toList();
    }

    private boolean instantiatesCanonicalMatchesProcessIdAndIdentifierValid(ProcessIdAndVersion expectedProcessIdAndVersion, FileAndResource fileAndResource) {
        String instantiatesCanonical = ((Task)fileAndResource.getResource()).getInstantiatesCanonical();
        String identifierValue = NamingSystems.TaskIdentifier.findFirst((Task)((Task)fileAndResource.getResource())).map(Identifier::getValue).get();
        Matcher instantiatesCanonicalMatcher = INSTANTIATES_CANONICAL_PATTERN.matcher(instantiatesCanonical);
        if (instantiatesCanonicalMatcher.matches()) {
            String expectedIdentifierValueStart;
            boolean identifierValueOk;
            boolean processVersionOk;
            String processDomain = instantiatesCanonicalMatcher.group("domain").replace(".", "");
            String processName = instantiatesCanonicalMatcher.group("processName");
            String processVersion = instantiatesCanonicalMatcher.group("processVersion");
            String processUrl = instantiatesCanonicalMatcher.group("processUrl");
            String processId = processDomain + "_" + processName;
            boolean processIdOk = expectedProcessIdAndVersion.getId().equals(processId);
            if (!processIdOk) {
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{} for process {}: Task.instantiatesCanonical does not match process id (instantiatesCanonical: '{}' vs. process-id '{}')", new Object[]{fileAndResource.getFile(), this.getDefinitionName(), this.getDefinitionVersion(), expectedProcessIdAndVersion.getId(), instantiatesCanonical, expectedProcessIdAndVersion.getId()});
            }
            if (!(processVersionOk = expectedProcessIdAndVersion.getVersion().equals(processVersion))) {
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{} for process {}: Task.instantiatesCanonical|version does not match declared resource version (instantiatesCanonical: '{}' vs. resource-version '{}')", new Object[]{fileAndResource.getFile(), this.getDefinitionName(), this.getDefinitionVersion(), expectedProcessIdAndVersion.getId(), instantiatesCanonical, expectedProcessIdAndVersion.getVersion()});
            }
            if (!(identifierValueOk = identifierValue.startsWith(expectedIdentifierValueStart = processUrl + "/" + processVersion + "/"))) {
                logger.warn("Ignoring FHIR resource {} from process plugin {}-{} for process {}: Task.identifier.value is invalid (identifier.value: '{}' not starting with '{}')", new Object[]{fileAndResource.getFile(), this.getDefinitionName(), this.getDefinitionVersion(), expectedProcessIdAndVersion.getId(), identifierValue, expectedIdentifierValueStart});
            }
            return processIdOk && processVersionOk && identifierValueOk;
        }
        return false;
    }

    private static final class FileAndResource {
        final String file;
        final Resource resource;

        FileAndResource(String file, Resource resource) {
            Objects.requireNonNull(file, "file");
            Objects.requireNonNull(resource, "resource");
            this.file = file;
            this.resource = resource;
        }

        static FileAndResource of(String file, Resource resource) {
            return new FileAndResource(file, resource);
        }

        String getFile() {
            return this.file;
        }

        Resource getResource() {
            return this.resource;
        }
    }
}

