/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.listener;

import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.delegate.DelegateListener;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.impl.bpmn.parser.AbstractBpmnParseListener;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParseListener;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DebugLoggingBpmnParseListener
extends AbstractBpmnParseListener
implements BpmnParseListener,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(DebugLoggingBpmnParseListener.class);
    private final boolean logActivityStart;
    private final boolean logActivityEnd;
    private final boolean logVariables;
    private final boolean logVariablesLocal;
    private final ExecutionListener listener;

    public DebugLoggingBpmnParseListener(boolean logActivityStart, boolean logActivityEnd, boolean logVariables, boolean logVariablesLocal) {
        this.logActivityStart = logActivityStart;
        this.logActivityEnd = logActivityEnd;
        this.logVariables = logVariables;
        this.logVariablesLocal = logVariablesLocal;
        this.listener = new ExecutionListenerLogger(logVariables, logVariablesLocal);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.logActivityStart) {
            logger.warn("Process activity start debug logging enabled. This should only be activated during process plugin development");
        }
        if (this.logActivityEnd) {
            logger.warn("Process activity end debug logging enabled. This should only be activated during process plugin development");
        }
        if (this.logVariables) {
            logger.warn("Process variable debug logging enabled. This should only be activated during process plugin development. WARNNING: Confidential information may be leaked via the debug log!");
        }
        if (this.logVariablesLocal) {
            logger.warn("Process local variable debug logging enabled. This should only be activated during process plugin development. WARNNING: Confidential information may be leaked via the debug log!");
        }
    }

    private void addListeners(ActivityImpl activity) {
        if (this.logActivityStart) {
            activity.addListener("start", (DelegateListener)this.listener, 0);
        }
        if (this.logActivityEnd) {
            activity.addListener("end", (DelegateListener)this.listener, 0);
        }
    }

    public void parseStartEvent(Element startEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseExclusiveGateway(Element exclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseInclusiveGateway(Element inclusiveGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseParallelGateway(Element parallelGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseScriptTask(Element scriptTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseServiceTask(Element serviceTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseBusinessRuleTask(Element businessRuleTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseTask(Element taskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseManualTask(Element manualTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseUserTask(Element userTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseEndEvent(Element endEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseSubProcess(Element subProcessElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseCallActivity(Element callActivityElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseSendTask(Element sendTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseReceiveTask(Element receiveTaskElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseEventBasedGateway(Element eventBasedGwElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseTransaction(Element transactionElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseIntermediateThrowEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseIntermediateCatchEvent(Element intermediateEventElement, ScopeImpl scope, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseBoundaryEvent(Element boundaryEventElement, ScopeImpl scopeElement, ActivityImpl activity) {
        this.addListeners(activity);
    }

    public void parseMultiInstanceLoopCharacteristics(Element activityElement, Element multiInstanceLoopCharacteristicsElement, ActivityImpl activity) {
        this.addListeners(activity);
    }

    private static final class ExecutionListenerLogger
    implements ExecutionListener {
        final boolean logVariables;
        final boolean logVariablesLocal;

        ExecutionListenerLogger(boolean logVariables, boolean logVariablesLocal) {
            this.logVariables = logVariables;
            this.logVariablesLocal = logVariablesLocal;
        }

        public void notify(DelegateExecution execution) throws Exception {
            if (execution != null) {
                logger.debug("EventName: '{}', ActivityInstanceId: '{}', BusinessKey: '{}', CurrentActivityId: '{}', CurrentActivityName: '{}', ProcessDefinitionId: '{}', ProcessInstanceId: '{}'", new Object[]{execution.getEventName(), execution.getActivityInstanceId(), execution.getBusinessKey(), execution.getCurrentActivityId(), execution.getCurrentActivityName(), execution.getProcessDefinitionId(), execution.getProcessInstanceId()});
                if (this.logVariables) {
                    logger.debug("Variables: {}", (Object)execution.getVariables());
                }
                if (this.logVariablesLocal) {
                    logger.debug("VariablesLocal: {}", (Object)execution.getVariablesLocal());
                }
            } else {
                logger.warn("Can't log, DelegateExecution is 'null'");
            }
        }
    }
}

