/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.variables;

import dev.dsf.bpe.listener.ListenerVariables;
import dev.dsf.bpe.subscription.QuestionnaireResponseHandler;
import dev.dsf.bpe.v1.variables.Target;
import dev.dsf.bpe.v1.variables.Targets;
import dev.dsf.bpe.v1.variables.Variables;
import dev.dsf.bpe.variables.FhirResourceValues;
import dev.dsf.bpe.variables.FhirResourcesList;
import dev.dsf.bpe.variables.FhirResourcesListValues;
import dev.dsf.bpe.variables.TargetImpl;
import dev.dsf.bpe.variables.TargetValues;
import dev.dsf.bpe.variables.TargetsImpl;
import dev.dsf.bpe.variables.TargetsValues;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.camunda.bpm.engine.delegate.DelegateExecution;
import org.camunda.bpm.engine.variable.value.TypedValue;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariablesImpl
implements Variables,
ListenerVariables {
    private static final Logger logger = LoggerFactory.getLogger(VariablesImpl.class);
    public static final String TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID = VariablesImpl.class.getName() + ".parentActivityInstanceId";
    private static final String TASKS = VariablesImpl.class.getName() + ".tasks";
    private final DelegateExecution execution;

    public VariablesImpl(DelegateExecution execution) {
        this.execution = Objects.requireNonNull(execution, "execution");
    }

    public void setAlternativeBusinessKey(String alternativeBusinessKey) {
        this.execution.setVariable("alternativeBusinessKey", (Object)alternativeBusinessKey);
    }

    public Target createTarget(String organizationIdentifierValue, String endpointIdentifierValue, String endpointAddress, String correlationKey) {
        Objects.requireNonNull(organizationIdentifierValue, "organizationIdentifierValue");
        Objects.requireNonNull(endpointIdentifierValue, "endpointIdentifierValue");
        Objects.requireNonNull(endpointAddress, "endpointAddress");
        return new TargetImpl(organizationIdentifierValue, endpointIdentifierValue, endpointAddress, correlationKey);
    }

    public void setTarget(Target target) throws IllegalArgumentException {
        if (target == null) {
            this.execution.setVariable("target", null);
            return;
        }
        if (!(target instanceof TargetImpl)) {
            throw new IllegalArgumentException("Given target implementing class " + target.getClass().getName() + " not supported");
        }
        TargetValues.TargetValue variable = TargetValues.create((TargetImpl)target);
        this.execution.setVariable("target", (Object)variable);
    }

    public Target getTarget() {
        return (TargetImpl)this.execution.getVariable("target");
    }

    public Targets createTargets(List<? extends Target> targets) {
        if (targets == null) {
            return new TargetsImpl(Collections.emptyList());
        }
        Optional<Target> firstNonMatch = targets.stream().filter(t -> !(t instanceof TargetImpl)).findFirst();
        if (firstNonMatch.isPresent()) {
            throw new IllegalArgumentException("Target implementing class " + firstNonMatch.get().getClass().getName() + " (in given List) not supported");
        }
        return new TargetsImpl(targets);
    }

    public void setTargets(Targets targets) throws IllegalArgumentException {
        if (targets == null) {
            this.execution.setVariable("targets", null);
            return;
        }
        if (!(targets instanceof TargetsImpl)) {
            throw new IllegalArgumentException("Given targets implementing class " + targets.getClass().getName() + " not supported");
        }
        TargetsValues.TargetsValue variable = targets == null ? null : TargetsValues.create((TargetsImpl)targets);
        this.execution.setVariable("targets", (Object)variable);
    }

    public Targets getTargets() {
        return (Targets)this.execution.getVariable("targets");
    }

    public void setResourceList(String variableName, List<? extends Resource> resources) {
        FhirResourcesListValues.FhirResourcesListValue variable = resources == null ? null : FhirResourcesListValues.create(resources);
        this.execution.setVariable(variableName, (Object)variable);
    }

    public <R extends Resource> List<R> getResourceList(String variableName) {
        FhirResourcesList list = (FhirResourcesList)this.execution.getVariable(variableName);
        return list == null ? null : list.getResourcesAndCast();
    }

    public void setResource(String variableName, Resource resource) {
        FhirResourceValues.FhirResourceValue variable = resource == null ? null : FhirResourceValues.create(resource);
        this.execution.setVariable(variableName, (Object)variable);
    }

    public <R extends Resource> R getResource(String variableName) {
        Resource resource = (Resource)this.execution.getVariable(variableName);
        return (R)resource;
    }

    public Task getStartTask() {
        List<Task> tasks = this.getTasks();
        return tasks == null || tasks.isEmpty() ? null : tasks.get(0);
    }

    public Task getLatestTask() {
        List<Task> tasks = this.getCurrentTasks();
        return tasks == null || tasks.isEmpty() ? null : tasks.get(tasks.size() - 1);
    }

    public List<Task> getTasks() {
        List tasks = this.getResourceList(TASKS);
        if (tasks == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < tasks.size(); ++i) {
            Task t = (Task)tasks.get(i);
            logger.trace("Task [{}] id: {}, parentActivityInstanceId: {}", new Object[]{i, t.getIdElement().getIdPart(), t.getUserData(TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID)});
        }
        return Collections.unmodifiableList(tasks);
    }

    public List<Task> getCurrentTasks() {
        logger.trace("parentActivityInstanceId: {}, parentId: {}", (Object)this.execution.getParentActivityInstanceId(), (Object)this.execution.getParentId());
        return this.getTasks().stream().filter(t -> {
            Object id = t.getUserData(TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID);
            return Objects.equals(id, this.execution.getParentActivityInstanceId()) || id == null && this.execution.getParentId() == null;
        }).toList();
    }

    public void updateTask(Task task) {
        if (task != null) {
            List<Task> allTasks = this.getTasks();
            if (allTasks.contains(task)) {
                this.setResourceList(TASKS, allTasks);
            } else {
                logger.warn("Given task not part of all-tasks list, ignoring task");
            }
        } else {
            logger.warn("Given task is null");
        }
    }

    @Override
    public void onStart(Task task) {
        if (task != null) {
            task.setUserData(TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID, (Object)this.execution.getParentActivityInstanceId());
            this.setResourceList(TASKS, Collections.singletonList(task));
        } else {
            logger.warn("Given task is null");
        }
    }

    @Override
    public void onContinue(Task task) {
        if (task != null) {
            task.setUserData(TASK_USERDATA_PARENT_ACTIVITY_INSTANCE_ID, (Object)this.execution.getParentActivityInstanceId());
            ArrayList<Task> tasks = new ArrayList<Task>(this.getTasks());
            tasks.add(task);
            this.setResourceList(TASKS, tasks);
        } else {
            logger.warn("Given task is null");
        }
    }

    @Override
    public void onEnd() {
        ArrayList<Task> tasks = new ArrayList<Task>(this.getTasks());
        tasks.removeAll(this.getCurrentTasks());
        this.setResourceList(TASKS, tasks);
    }

    public QuestionnaireResponse getLatestReceivedQuestionnaireResponse() {
        return (QuestionnaireResponse)this.getResource(QuestionnaireResponseHandler.QUESTIONNAIRE_RESPONSE_VARIABLE);
    }

    public void setVariable(String variableName, TypedValue value) {
        Objects.requireNonNull(variableName, "variableName");
        this.execution.setVariable(variableName, (Object)value);
    }

    public Object getVariable(String variableName) {
        Objects.requireNonNull(variableName, "variableName");
        return this.execution.getVariable(variableName);
    }
}

