/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.subscription;

import dev.dsf.bpe.subscription.ResourceHandler;
import dev.dsf.bpe.variables.FhirResourceValues;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.camunda.bpm.engine.TaskService;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class QuestionnaireResponseHandler
implements ResourceHandler<QuestionnaireResponse>,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(QuestionnaireResponseHandler.class);
    public static final String QUESTIONNAIRE_RESPONSE_VARIABLE = QuestionnaireResponseHandler.class.getName() + ".questionnaireResponse";
    private final TaskService userTaskService;

    public QuestionnaireResponseHandler(TaskService userTaskService) {
        this.userTaskService = userTaskService;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.userTaskService, "userTaskService");
    }

    @Override
    public void onResource(QuestionnaireResponse questionnaireResponse) {
        try {
            List items = questionnaireResponse.getItem();
            String questionnaireResponseId = questionnaireResponse.getId();
            String questionnaire = questionnaireResponse.getQuestionnaire();
            String user = questionnaireResponse.getAuthor().getIdentifier().getValue();
            String userType = questionnaireResponse.getAuthor().getType();
            String businessKey = this.getStringValueFromItems(items, "business-key", questionnaireResponseId).orElse("?");
            Optional<String> userTaskIdOpt = this.getStringValueFromItems(items, "user-task-id", questionnaireResponseId);
            userTaskIdOpt.ifPresentOrElse(userTaskId -> {
                logger.info("QuestionnaireResponse '{}' for Questionnaire '{}' completed [userTaskId: {}, businessKey: {}, user: {}]", new Object[]{questionnaireResponseId, questionnaire, userTaskId, businessKey, user + "|" + userType});
                Map<String, FhirResourceValues.FhirResourceValue> variables = Map.of(QUESTIONNAIRE_RESPONSE_VARIABLE, FhirResourceValues.create((Resource)questionnaireResponse));
                this.userTaskService.complete(userTaskId, variables);
            }, () -> logger.warn("QuestionnaireResponse '{}' for Questionnaire '{}' has no answer with item.linkId '{}' [businessKey: {}, user: {}], ignoring QuestionnaireResponse", new Object[]{questionnaireResponseId, questionnaire, "user-task-id", businessKey, user + "|" + userType}));
        }
        catch (Exception e) {
            logger.warn("Unable to complete UserTask", (Throwable)e);
        }
    }

    private Optional<String> getStringValueFromItems(List<QuestionnaireResponse.QuestionnaireResponseItemComponent> items, String linkId, String questionnaireResponseId) {
        List answers = items.stream().filter(i -> linkId.equals(i.getLinkId())).flatMap(i -> i.getAnswer().stream()).filter(a -> a.getValue() instanceof StringType).map(a -> (String)((StringType)a.getValue()).getValue()).collect(Collectors.toList());
        if (answers.size() == 0) {
            logger.info("QuestionnaireResponse with id '{}' did not contain any linkId '{}'", (Object)questionnaireResponseId, (Object)linkId);
            return Optional.empty();
        }
        if (answers.size() > 1) {
            logger.warn("QuestionnaireResponse with id '{}' contained {} linkIds '{}', using the first", new Object[]{questionnaireResponseId, answers.size(), linkId});
        }
        return Optional.of((String)answers.get(0));
    }
}

