/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import de.rwh.utils.crypto.CertificateHelper;
import de.rwh.utils.crypto.io.CertificateReader;
import de.rwh.utils.crypto.io.PemIo;
import dev.dsf.bpe.client.FhirClientProvider;
import dev.dsf.bpe.client.FhirClientProviderImpl;
import dev.dsf.bpe.spring.config.BuildInfoReaderConfig;
import dev.dsf.bpe.spring.config.FhirConfig;
import dev.dsf.bpe.spring.config.PropertiesConfig;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.fhir.service.ReferenceCleanerImpl;
import dev.dsf.fhir.service.ReferenceExtractor;
import dev.dsf.fhir.service.ReferenceExtractorImpl;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.UUID;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.pkcs.PKCSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class FhirClientConfig
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(FhirClientConfig.class);
    private static final BouncyCastleProvider provider = new BouncyCastleProvider();
    @Autowired
    private PropertiesConfig propertiesConfig;
    @Autowired
    private FhirConfig fhirConfig;
    @Autowired
    private BuildInfoReaderConfig buildInfoReaderConfig;

    public void afterPropertiesSet() throws Exception {
        logger.info("Local webservice client config: {trustStorePath: {}, certificatePath: {}, privateKeyPath: {}, privateKeyPassword: {}, url: {}, proxy: {}}", new Object[]{this.propertiesConfig.getClientCertificateTrustStoreFile(), this.propertiesConfig.getClientCertificateFile(), this.propertiesConfig.getClientCertificatePrivateKeyFile(), this.propertiesConfig.getClientCertificatePrivateKeyFilePassword() != null ? "***" : "null", this.propertiesConfig.getServerBaseUrl(), this.propertiesConfig.proxyConfig().isEnabled(this.propertiesConfig.getServerBaseUrl()) ? "enabled" : "disabled"});
        logger.info("Local websocket client config: {trustStorePath: {}, certificatePath: {}, privateKeyPath: {}, privateKeyPassword: {}, url: {}, proxy: {}}", new Object[]{this.propertiesConfig.getClientCertificateTrustStoreFile(), this.propertiesConfig.getClientCertificateFile(), this.propertiesConfig.getClientCertificatePrivateKeyFile(), this.propertiesConfig.getClientCertificatePrivateKeyFilePassword() != null ? "***" : "null", this.getWebsocketUrl(), this.propertiesConfig.proxyConfig().isEnabled(this.getWebsocketUrl()) ? "enabled" : "disabled"});
        logger.info("Remote webservice client config: {trustStorePath: {}, certificatePath: {}, privateKeyPath: {}, privateKeyPassword: {}, proxy: {}}", new Object[]{this.propertiesConfig.getClientCertificateTrustStoreFile(), this.propertiesConfig.getClientCertificateFile(), this.propertiesConfig.getClientCertificatePrivateKeyFile(), this.propertiesConfig.getClientCertificatePrivateKeyFilePassword() != null ? "***" : "null", this.propertiesConfig.proxyConfig().isEnabled() ? "enabled if remote server not in " + this.propertiesConfig.proxyConfig().getNoProxyUrls() : "disabled"});
    }

    @Bean
    public ReferenceCleaner referenceCleaner() {
        return new ReferenceCleanerImpl(this.referenceExtractor());
    }

    @Bean
    public ReferenceExtractor referenceExtractor() {
        return new ReferenceExtractorImpl();
    }

    @Bean
    public FhirClientProvider clientProvider() {
        char[] keyStorePassword = UUID.randomUUID().toString().toCharArray();
        try {
            KeyStore webserviceKeyStore = this.createKeyStore(this.propertiesConfig.getClientCertificateFile(), this.propertiesConfig.getClientCertificatePrivateKeyFile(), this.propertiesConfig.getClientCertificatePrivateKeyFilePassword(), keyStorePassword);
            KeyStore webserviceTrustStore = this.createTrustStore(this.propertiesConfig.getClientCertificateTrustStoreFile());
            return new FhirClientProviderImpl(this.fhirConfig.fhirContext(), this.referenceCleaner(), this.propertiesConfig.getServerBaseUrl(), this.propertiesConfig.getWebserviceClientLocalReadTimeout(), this.propertiesConfig.getWebserviceClientLocalConnectTimeout(), this.propertiesConfig.getWebserviceClientLocalVerbose(), webserviceTrustStore, webserviceKeyStore, keyStorePassword, this.propertiesConfig.getWebserviceClientRemoteReadTimeout(), this.propertiesConfig.getWebserviceClientRemoteConnectTimeout(), this.propertiesConfig.getWebserviceClientRemoteVerbose(), this.getWebsocketUrl(), webserviceTrustStore, webserviceKeyStore, keyStorePassword, this.propertiesConfig.proxyConfig(), this.buildInfoReaderConfig.buildInfoReader());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | PKCSException e) {
            throw new RuntimeException(e);
        }
    }

    private String getWebsocketUrl() {
        String baseUrl = this.propertiesConfig.getServerBaseUrl();
        if (baseUrl.startsWith("https://")) {
            return baseUrl.replace("https://", "wss://") + "/ws";
        }
        if (baseUrl.startsWith("http://")) {
            return baseUrl.replace("http://", "ws://") + "/ws";
        }
        throw new RuntimeException("server base url (" + baseUrl + ") does not start with https:// or http://");
    }

    private KeyStore createTrustStore(String trustStoreFile) throws IOException, NoSuchAlgorithmException, CertificateException, KeyStoreException {
        Path trustStorePath = Paths.get(trustStoreFile, new String[0]);
        if (!Files.isReadable(trustStorePath)) {
            throw new IOException("Trust store file '" + trustStorePath.toString() + "' not readable");
        }
        return CertificateReader.allFromCer((Path)trustStorePath);
    }

    private KeyStore createKeyStore(String certificateFile, String privateKeyFile, char[] privateKeyPassword, char[] keyStorePassword) throws IOException, PKCSException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Path certificatePath = Paths.get(certificateFile, new String[0]);
        Path privateKeyPath = Paths.get(privateKeyFile, new String[0]);
        if (!Files.isReadable(certificatePath)) {
            throw new IOException("Certificate file '" + certificatePath.toString() + "' not readable");
        }
        if (!Files.isReadable(certificatePath)) {
            throw new IOException("Private key file '" + privateKeyPath.toString() + "' not readable");
        }
        X509Certificate certificate = PemIo.readX509CertificateFromPem((Path)certificatePath);
        PrivateKey privateKey = PemIo.readPrivateKeyFromPem((BouncyCastleProvider)provider, (Path)privateKeyPath, (char[])privateKeyPassword);
        String subjectCommonName = CertificateHelper.getSubjectCommonName((X509Certificate)certificate);
        return CertificateHelper.toJksKeyStore((PrivateKey)privateKey, (Certificate[])new Certificate[]{certificate}, (String)subjectCommonName, (char[])keyStorePassword);
    }
}

