/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.spring.config;

import dev.dsf.bpe.dao.LastEventTimeDao;
import dev.dsf.bpe.dao.LastEventTimeDaoJdbc;
import dev.dsf.bpe.dao.ProcessPluginResourcesDao;
import dev.dsf.bpe.dao.ProcessPluginResourcesDaoJdbc;
import dev.dsf.bpe.dao.ProcessStateDao;
import dev.dsf.bpe.dao.ProcessStateDaoJdbc;
import dev.dsf.bpe.spring.config.PropertiesConfig;
import org.apache.commons.dbcp2.BasicDataSource;
import org.postgresql.Driver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DaoConfig {
    @Autowired
    private PropertiesConfig propertiesConfig;

    @Bean
    public BasicDataSource dataSource() {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(Driver.class.getName());
        dataSource.setUrl(this.propertiesConfig.getDbUrl());
        dataSource.setUsername(this.propertiesConfig.getDbUsername());
        dataSource.setPassword(this.toString(this.propertiesConfig.getDbPassword()));
        dataSource.setDefaultReadOnly(Boolean.valueOf(true));
        dataSource.setTestOnBorrow(true);
        dataSource.setValidationQuery("SELECT 1");
        return dataSource;
    }

    private String toString(char[] password) {
        return password == null ? null : String.valueOf(password);
    }

    @Bean
    public ProcessPluginResourcesDao processPluginResourcesDao() {
        return new ProcessPluginResourcesDaoJdbc(this.dataSource());
    }

    @Bean
    public ProcessStateDao processStateDao() {
        return new ProcessStateDaoJdbc(this.dataSource());
    }

    @Bean
    public LastEventTimeDao lastEventTimeDaoTask() {
        return new LastEventTimeDaoJdbc(this.dataSource(), "Task");
    }

    @Bean
    public LastEventTimeDao lastEventTimeDaoQuestionnaireResponse() {
        return new LastEventTimeDaoJdbc(this.dataSource(), "QuestionnaireResponse");
    }
}

