/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.plugin;

import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import org.hl7.fhir.r4.model.ResourceType;

public class ResourceInfo
implements Comparable<ResourceInfo> {
    private final ResourceType resourceType;
    private final String url;
    private final String version;
    private final String name;
    private final String identifier;
    private UUID resourceId;

    public ResourceInfo(ResourceType resourceType, String url, String version, String name, String identifier) {
        this.resourceType = resourceType;
        this.url = url;
        this.version = version;
        this.name = name;
        this.identifier = identifier;
        this.validate();
    }

    private void validate() {
        Objects.requireNonNull(this.resourceType, "resourceType");
        if (ResourceType.NamingSystem.equals((Object)this.getResourceType())) {
            if (this.url != null) {
                throw new IllegalArgumentException("url not null for " + this.resourceType);
            }
            if (this.version != null) {
                throw new IllegalArgumentException("version not null for " + this.resourceType);
            }
            Objects.requireNonNull(this.name, "name");
            if (this.identifier != null) {
                throw new IllegalArgumentException("identifier not null for " + this.resourceType);
            }
        } else if (ResourceType.Task.equals((Object)this.getResourceType())) {
            if (this.url != null) {
                throw new IllegalArgumentException("url not null for " + this.resourceType);
            }
            if (this.version != null) {
                throw new IllegalArgumentException("version not null for " + this.resourceType);
            }
            if (this.name != null) {
                throw new IllegalArgumentException("name not null for " + this.resourceType);
            }
            Objects.requireNonNull(this.identifier, "identifier");
        } else {
            Objects.requireNonNull(this.url, "url");
            Objects.requireNonNull(this.version, "version");
            if (this.name != null) {
                throw new IllegalArgumentException("name not null for " + this.resourceType);
            }
            if (this.identifier != null) {
                throw new IllegalArgumentException("identifier not null for " + this.resourceType);
            }
        }
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public String getUrl() {
        return this.url;
    }

    public String getVersion() {
        return this.version;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.name, this.resourceType, this.url, this.version);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceInfo other = (ResourceInfo)obj;
        return Objects.equals(this.identifier, other.identifier) && Objects.equals(this.name, other.name) && this.resourceType == other.resourceType && Objects.equals(this.url, other.url) && Objects.equals(this.version, other.version);
    }

    @Override
    public int compareTo(ResourceInfo o) {
        Comparator<ResourceInfo> comparator = ResourceType.NamingSystem.equals((Object)this.getResourceType()) ? Comparator.comparing(ResourceInfo::getResourceType).thenComparing(ResourceInfo::getName) : (ResourceType.Task.equals((Object)this.getResourceType()) ? Comparator.comparing(ResourceInfo::getResourceType).thenComparing(ResourceInfo::getIdentifier) : Comparator.comparing(ResourceInfo::getResourceType).thenComparing(ResourceInfo::getUrl).thenComparing(ResourceInfo::getVersion));
        return comparator.compare(this, o);
    }

    public String toString() {
        return "ResourceInfo [resourceType=" + this.resourceType + ", url=" + this.url + ", version=" + this.version + ", name=" + this.name + ", identifier=" + this.identifier + ", resourceId=" + this.resourceId + "]";
    }

    public String toConditionalUrl() {
        if (ResourceType.NamingSystem.equals((Object)this.getResourceType())) {
            return "name=" + this.getName();
        }
        if (ResourceType.Task.equals((Object)this.getResourceType())) {
            return "identifier=http://dsf.dev/sid/task-identifier|" + this.getIdentifier() + "&status=draft";
        }
        return "url=" + this.getUrl() + "&version=" + this.getVersion();
    }

    public UUID getResourceId() {
        return this.resourceId;
    }

    public ResourceInfo setResourceId(UUID resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    public boolean hasResourceId() {
        return this.resourceId != null;
    }
}

