/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.mail;

import de.rwh.utils.crypto.context.SSLContextFactory;
import dev.dsf.bpe.v1.service.MailService;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AbstractManager;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.filter.ThresholdFilter;
import org.apache.logging.log4j.core.layout.ByteBufferDestination;
import org.apache.logging.log4j.core.layout.HtmlLayout;
import org.apache.logging.log4j.core.net.MailManager;
import org.apache.logging.log4j.core.net.MailManagerFactory;
import org.apache.logging.log4j.core.net.SmtpManager;
import org.apache.logging.log4j.util.Strings;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoGeneratorBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEException;
import org.bouncycastle.mail.smime.SMIMESignedGenerator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class SmtpMailService
implements MailService,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(SmtpMailService.class);
    public static final String DEFAULT_DEBUG_LOG_LOCATION = "/opt/bpe/log/bpe.log";
    private final InternetAddress fromAddress;
    private final InternetAddress[] toAddresses;
    private final InternetAddress[] toAddressesCc;
    private final InternetAddress[] replyToAddresses;
    private final Session session;
    private final SMIMESignedGenerator smimeSignedGenerator;
    private final Log4jAppender log4jAppender;

    public SmtpMailService(String fromAddress, List<String> toAddresses, String mailServerHostname, int mailServerPort) {
        this(fromAddress, toAddresses, null, null, false, mailServerHostname, mailServerPort, null, null, null, null, null, null, null, false, 0, DEFAULT_DEBUG_LOG_LOCATION);
    }

    public SmtpMailService(String fromAddress, List<String> toAddresses, List<String> toAddressesCc, List<String> replyToAddresses, boolean useSmtps, String mailServerHostname, int mailServerPort, String mailServerUsername, char[] mailServerPassword, KeyStore trustStore, KeyStore keyStore, char[] keyStorePassword, KeyStore signStore, char[] signStorePassword, boolean mailOnErrorLogEvent, int mailOnErrorLogEventBufferSize, String debugLogLocation) {
        this.fromAddress = this.toInternetAddress(fromAddress).orElse(null);
        this.toAddresses = toAddresses == null ? new InternetAddress[]{} : (InternetAddress[])toAddresses.stream().flatMap(s -> this.toInternetAddress((String)s).stream()).toArray(InternetAddress[]::new);
        this.toAddressesCc = toAddressesCc == null ? new InternetAddress[]{} : (InternetAddress[])toAddressesCc.stream().flatMap(s -> this.toInternetAddress((String)s).stream()).toArray(InternetAddress[]::new);
        this.replyToAddresses = replyToAddresses == null ? new InternetAddress[]{} : (InternetAddress[])replyToAddresses.stream().flatMap(s -> this.toInternetAddress((String)s).stream()).toArray(InternetAddress[]::new);
        this.session = this.createSession(useSmtps, mailServerHostname, mailServerPort, mailServerUsername, mailServerPassword, trustStore, keyStore, keyStorePassword);
        this.smimeSignedGenerator = this.createSmimeSignedGenerator(fromAddress, signStore, signStorePassword);
        this.log4jAppender = !mailOnErrorLogEvent ? null : new Log4jAppender(this.session, this.createMimeMessage("DSF BPE Error", null), "DSF BPE Error", mailOnErrorLogEventBufferSize, debugLogLocation);
    }

    private Optional<InternetAddress> toInternetAddress(String fromAddress) {
        if (fromAddress == null || fromAddress.isBlank()) {
            return Optional.empty();
        }
        try {
            return Optional.of(new InternetAddress(fromAddress));
        }
        catch (AddressException e) {
            logger.warn("Unable to create {} from {}: {} - {}", new Object[]{InternetAddress.class.getName(), fromAddress, ((Object)((Object)e)).getClass().getName(), e.getMessage()});
            return Optional.empty();
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.fromAddress == null) {
            throw new IllegalArgumentException("no valid from address configured");
        }
        if (this.toAddresses.length == 0) {
            throw new IllegalArgumentException("no valid to addresses configured");
        }
    }

    private Session createSession(boolean useSmtps, String mailServerHostname, int mailServerPort, final String mailServerUsername, final char[] mailServerPassword, KeyStore trustStore, KeyStore keyStore, char[] keyStorePassword) {
        Properties properties = new Properties();
        Authenticator authenticator = null;
        if (mailServerUsername != null && mailServerPassword != null) {
            authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(mailServerUsername, String.copyValueOf(mailServerPassword));
                }
            };
            properties.put("mail.smtp.auth", "true");
            if (!useSmtps) {
                logger.warn("Username/Password configured, SMTPS not enabled. Password will be send without encryption! Consider activating/using SMTP over TLS (aka SMTPS)");
            }
        }
        if (useSmtps) {
            properties.put("mail.smtp.ssl.enable", "true");
            properties.put("mail.transport.protocol", "smtps");
            properties.put("mail.smtp.socketFactory.fallback", "false");
            properties.put("mail.smtp.ssl.checkserveridentity", "true");
            properties.put("mail.smtp.ssl.socketFactory", this.createSslSocketFactory(trustStore, keyStore, keyStorePassword));
        }
        properties.put("mail.smtp.host", mailServerHostname);
        properties.put("mail.smtp.port", (Object)mailServerPort);
        return Session.getInstance((Properties)properties, (Authenticator)authenticator);
    }

    public SSLSocketFactory createSslSocketFactory(KeyStore trustStore, KeyStore keyStore, char[] keyStorePassword) {
        try {
            return new SSLContextFactory().createSSLContext(trustStore, keyStore, keyStorePassword).getSocketFactory();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            logger.warn("Unable to create custom ssl socket factory: {} - {}", (Object)e.getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private SMIMESignedGenerator createSmimeSignedGenerator(String fromAddress, KeyStore signStore, char[] signStorePassword) {
        if (signStore == null) {
            return null;
        }
        try {
            Optional<Certificate[]> certificates = this.getFirstCertificateChain(signStore).filter(this.hasCertificateForAddress(fromAddress));
            if (certificates.isEmpty()) {
                logger.warn("Mail signing certificate store has no S/MIME certificate for {}, not signing mails", (Object)fromAddress);
                return null;
            }
            Optional<PrivateKey> pivateKey = this.getFirstPrivateKey(signStore, signStorePassword);
            if (pivateKey.isEmpty()) {
                logger.warn("Mail signing certificate store has no private key, not signing mails", (Object)fromAddress);
                return null;
            }
            Certificate certificate = (Certificate)certificates.flatMap(c -> Stream.of(c).filter(this.hasSubjectAlternativeNameRfc822Name(fromAddress)).findFirst()).get();
            ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
            SMIMECapabilityVector caps = new SMIMECapabilityVector();
            caps.addCapability(SMIMECapability.aES128_CBC);
            caps.addCapability(SMIMECapability.aES256_CBC);
            signedAttrs.add((ASN1Encodable)new SMIMECapabilitiesAttribute(caps));
            SMIMESignedGenerator generator = new SMIMESignedGenerator();
            generator.addSignerInfoGenerator(new JcaSimpleSignerInfoGeneratorBuilder().setProvider((Provider)new BouncyCastleProvider()).setSignedAttributeGenerator(new AttributeTable(signedAttrs)).build("SHA256withRSA", pivateKey.get(), new X509CertificateHolder(certificate.getEncoded())));
            generator.addCertificates((Store)new JcaCertStore((Collection)certificates.map(Arrays::asList).get()));
            return generator;
        }
        catch (IOException | KeyStoreException | CertificateException | OperatorCreationException e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<Certificate[]> getFirstCertificateChain(KeyStore store) throws KeyStoreException {
        return Collections.list(store.aliases()).stream().map(this.getCertificateChain(store)).findFirst();
    }

    private Function<String, Certificate[]> getCertificateChain(KeyStore store) {
        return alias -> {
            try {
                return store.getCertificateChain((String)alias);
            }
            catch (KeyStoreException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Predicate<Certificate[]> hasCertificateForAddress(String address) {
        return chain -> this.hasSubjectAlternativeNameRfc822Name(address).test(chain[0]);
    }

    private Predicate<Certificate> hasSubjectAlternativeNameRfc822Name(String address) {
        return certificate -> {
            try {
                X509CertificateHolder holder = new X509CertificateHolder(certificate.getEncoded());
                X509Certificate x509Certificate = new JcaX509CertificateConverter().getCertificate(holder);
                Collection<List<?>> sanCollections = x509Certificate.getSubjectAlternativeNames();
                if (sanCollections == null) {
                    return false;
                }
                return sanCollections.stream().anyMatch(l -> Objects.equals(1, l.get(0)) && Objects.equals(address, l.get(1)));
            }
            catch (IOException | CertificateException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private Optional<PrivateKey> getFirstPrivateKey(KeyStore store, char[] keyPassword) throws KeyStoreException {
        return Collections.list(store.aliases()).stream().map(this.getPrivateKey(store, keyPassword)).findFirst().filter(k -> k instanceof PrivateKey).map(k -> (PrivateKey)k);
    }

    private Function<String, Key> getPrivateKey(KeyStore store, char[] keyPassword) {
        return alias -> {
            try {
                return store.getKey((String)alias, keyPassword);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private MimeMessage createMimeMessage(String subject, MimeMultipart mimeMultipart) {
        try {
            MimeMessage mimeMessage = new MimeMessage(this.session);
            mimeMessage.setFrom((Address)this.fromAddress);
            mimeMessage.setRecipients(Message.RecipientType.TO, (Address[])this.toAddresses);
            mimeMessage.setRecipients(Message.RecipientType.CC, (Address[])this.toAddressesCc);
            mimeMessage.setReplyTo((Address[])this.replyToAddresses);
            mimeMessage.setSubject(subject);
            if (mimeMultipart != null) {
                mimeMessage.setContent((Multipart)mimeMultipart);
            }
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private MimeMultipart signMessage(MimeBodyPart body) {
        if (this.smimeSignedGenerator != null) {
            try {
                return this.smimeSignedGenerator.generate(body);
            }
            catch (SMIMEException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            if (body.getContent() != null && body.getContent() instanceof MimeMultipart) {
                return (MimeMultipart)body.getContent();
            }
            return new MimeMultipart(new BodyPart[]{body});
        }
        catch (IOException | MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void send(String subject, MimeBodyPart body, Consumer<MimeMessage> messageModifier) {
        MimeMessage message = this.createMimeMessage(subject, this.signMessage(body));
        if (messageModifier != null) {
            messageModifier.accept(message);
        }
        try {
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            logger.warn("Unable to send message: {} - {}", (Object)((Object)((Object)e)).getClass().getName(), (Object)e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public Log4jAppender getLog4jAppender() {
        return this.log4jAppender;
    }

    private static final class Log4jAppender
    extends AbstractAppender {
        private final MailManager manager;

        private Log4jAppender(Session session, MimeMessage message, String subject, int messageBufferSize, String debugLogLocation) {
            super("SmtpMailService.Log4jAppender", (Filter)ThresholdFilter.createFilter(null, null, null), (org.apache.logging.log4j.core.Layout)new Layout(debugLogLocation), false, null);
            MailManagerFactory factory = (name, data) -> new SmtpManager(name, session, message, data){};
            MailManager.FactoryData data2 = new MailManager.FactoryData(null, null, null, null, null, null, event -> subject, null, null, 0, null, null, false, messageBufferSize, null, null);
            this.manager = (MailManager)AbstractManager.getManager((String)"SmtpMailService.Log4jAppender.Manager", (ManagerFactory)factory, (Object)data2);
        }

        public boolean isFiltered(LogEvent event) {
            boolean filtered = super.isFiltered(event);
            if (filtered) {
                this.manager.add(event);
            }
            return filtered;
        }

        public void append(LogEvent event) {
            this.manager.sendEvents(this.getLayout(), event);
        }
    }

    private static final class Layout
    implements StringLayout {
        final HtmlLayout delegate = HtmlLayout.newBuilder().setDatePattern("yyyy-MM-dd HH:mm:ss.nnnn").build();
        final String debugLogLocation;

        Layout(String debugLogLocation) {
            this.debugLogLocation = debugLogLocation;
        }

        public byte[] getFooter() {
            StringBuilder sbuf = new StringBuilder();
            sbuf.append("</table>").append(Strings.LINE_SEPARATOR);
            sbuf.append("<br>").append(Strings.LINE_SEPARATOR);
            sbuf.append("For more details see debug log at <i>").append(Strings.LINE_SEPARATOR);
            sbuf.append(this.debugLogLocation).append(Strings.LINE_SEPARATOR);
            sbuf.append("</i>").append(Strings.LINE_SEPARATOR);
            sbuf.append("<br>").append(Strings.LINE_SEPARATOR);
            sbuf.append("</body></html>").append(Strings.LINE_SEPARATOR);
            return sbuf.toString().getBytes(this.getCharset());
        }

        public byte[] getHeader() {
            return this.delegate.getHeader();
        }

        public byte[] toByteArray(LogEvent event) {
            return this.delegate.toByteArray(event);
        }

        public String getContentType() {
            return this.delegate.getContentType();
        }

        public Map<String, String> getContentFormat() {
            return this.delegate.getContentFormat();
        }

        public void encode(LogEvent source, ByteBufferDestination destination) {
            this.delegate.encode(source, destination);
        }

        public Charset getCharset() {
            return this.delegate.getCharset();
        }

        public String toSerializable(LogEvent event) {
            return this.delegate.toSerializable(event);
        }
    }
}

