/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.client;

import ca.uhn.fhir.context.FhirContext;
import dev.dsf.bpe.client.FhirClientProvider;
import dev.dsf.common.config.ProxyConfig;
import dev.dsf.fhir.client.FhirWebserviceClient;
import dev.dsf.fhir.client.FhirWebserviceClientJersey;
import dev.dsf.fhir.client.WebsocketClient;
import dev.dsf.fhir.client.WebsocketClientTyrus;
import dev.dsf.fhir.service.ReferenceCleaner;
import dev.dsf.tools.build.BuildInfoReader;
import java.net.URI;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class FhirClientProviderImpl
implements FhirClientProvider,
InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(FhirClientProviderImpl.class);
    private static final String USER_AGENT_VALUE = "DSF/";
    private final Map<String, FhirWebserviceClient> webserviceClientsByUrl = new HashMap<String, FhirWebserviceClient>();
    private final Map<String, WebsocketClient> websocketClientsBySubscriptionId = new HashMap<String, WebsocketClient>();
    private final FhirContext fhirContext;
    private final ReferenceCleaner referenceCleaner;
    private final String localWebserviceBaseUrl;
    private final int localWebserviceReadTimeout;
    private final int localWebserviceConnectTimeout;
    private final boolean localWebserviceLogRequests;
    private final KeyStore webserviceTrustStore;
    private final KeyStore webserviceKeyStore;
    private final char[] webserviceKeyStorePassword;
    private final int remoteWebserviceReadTimeout;
    private final int remoteWebserviceConnectTimeout;
    private final boolean remoteWebserviceLogRequests;
    private final String localWebsocketUrl;
    private final KeyStore localWebsocketTrustStore;
    private final KeyStore localWebsocketKeyStore;
    private final char[] localWebsocketKeyStorePassword;
    private final ProxyConfig proxyConfig;
    private final BuildInfoReader buildInfoReader;

    public FhirClientProviderImpl(FhirContext fhirContext, ReferenceCleaner referenceCleaner, String localWebserviceBaseUrl, int localWebserviceReadTimeout, int localWebserviceConnectTimeout, boolean localWebserviceLogRequests, KeyStore webserviceTrustStore, KeyStore webserviceKeyStore, char[] webserviceKeyStorePassword, int remoteWebserviceReadTimeout, int remoteWebserviceConnectTimeout, boolean remoteWebserviceLogRequests, String localWebsocketUrl, KeyStore localWebsocketTrustStore, KeyStore localWebsocketKeyStore, char[] localWebsocketKeyStorePassword, ProxyConfig proxyConfig, BuildInfoReader buildInfoReader) {
        this.fhirContext = fhirContext;
        this.referenceCleaner = referenceCleaner;
        this.localWebserviceBaseUrl = localWebserviceBaseUrl;
        this.localWebserviceReadTimeout = localWebserviceReadTimeout;
        this.localWebserviceConnectTimeout = localWebserviceConnectTimeout;
        this.localWebserviceLogRequests = localWebserviceLogRequests;
        this.webserviceTrustStore = webserviceTrustStore;
        this.webserviceKeyStore = webserviceKeyStore;
        this.webserviceKeyStorePassword = webserviceKeyStorePassword;
        this.remoteWebserviceReadTimeout = remoteWebserviceReadTimeout;
        this.remoteWebserviceConnectTimeout = remoteWebserviceConnectTimeout;
        this.remoteWebserviceLogRequests = remoteWebserviceLogRequests;
        this.localWebsocketUrl = localWebsocketUrl;
        this.localWebsocketTrustStore = localWebsocketTrustStore;
        this.localWebsocketKeyStore = localWebsocketKeyStore;
        this.localWebsocketKeyStorePassword = localWebsocketKeyStorePassword;
        this.proxyConfig = proxyConfig;
        this.buildInfoReader = buildInfoReader;
    }

    public void afterPropertiesSet() throws Exception {
        Objects.requireNonNull(this.fhirContext, "fhirContext");
        Objects.requireNonNull(this.localWebserviceBaseUrl, "localBaseUrl");
        if (this.localWebserviceReadTimeout < 0) {
            throw new IllegalArgumentException("localReadTimeout < 0");
        }
        if (this.localWebserviceConnectTimeout < 0) {
            throw new IllegalArgumentException("localConnectTimeout < 0");
        }
        Objects.requireNonNull(this.webserviceTrustStore, "webserviceTrustStore");
        Objects.requireNonNull(this.webserviceKeyStore, "webserviceKeyStore");
        Objects.requireNonNull(this.webserviceKeyStorePassword, "webserviceKeyStorePassword");
        if (this.remoteWebserviceReadTimeout < 0) {
            throw new IllegalArgumentException("remoteReadTimeout < 0");
        }
        if (this.remoteWebserviceConnectTimeout < 0) {
            throw new IllegalArgumentException("remoteConnectTimeout < 0");
        }
        Objects.requireNonNull(this.localWebsocketUrl, "localWebsocketUrl");
        Objects.requireNonNull(this.localWebsocketTrustStore, "localWebsocketTrustStore");
        Objects.requireNonNull(this.localWebsocketKeyStore, "localWebsocketKeyStore");
        Objects.requireNonNull(this.localWebsocketKeyStorePassword, "localWebsocketKeyStorePassword");
        Objects.requireNonNull(this.proxyConfig, "proxyConfig");
        Objects.requireNonNull(this.buildInfoReader, "buildInfoReader");
    }

    public String getLocalBaseUrl() {
        return this.localWebserviceBaseUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FhirWebserviceClient getClient(String webserviceUrl) {
        Map<String, FhirWebserviceClient> map = this.webserviceClientsByUrl;
        synchronized (map) {
            if (this.webserviceClientsByUrl.containsKey(webserviceUrl)) {
                return this.webserviceClientsByUrl.get(webserviceUrl);
            }
            String proxyUrl = this.proxyConfig.isEnabled(webserviceUrl) ? this.proxyConfig.getUrl() : null;
            String proxyUsername = this.proxyConfig.isEnabled(webserviceUrl) ? this.proxyConfig.getUsername() : null;
            char[] proxyPassword = this.proxyConfig.isEnabled(webserviceUrl) ? this.proxyConfig.getPassword() : null;
            FhirWebserviceClientJersey client = this.localWebserviceBaseUrl.equals(webserviceUrl) ? new FhirWebserviceClientJersey(webserviceUrl, this.webserviceTrustStore, this.webserviceKeyStore, this.webserviceKeyStorePassword, null, proxyUrl, proxyUsername, proxyPassword, this.localWebserviceConnectTimeout, this.localWebserviceReadTimeout, this.localWebserviceLogRequests, USER_AGENT_VALUE + this.buildInfoReader.getProjectVersion(), this.fhirContext, this.referenceCleaner) : new FhirWebserviceClientJersey(webserviceUrl, this.webserviceTrustStore, this.webserviceKeyStore, this.webserviceKeyStorePassword, null, proxyUrl, proxyUsername, proxyPassword, this.remoteWebserviceConnectTimeout, this.remoteWebserviceReadTimeout, this.remoteWebserviceLogRequests, USER_AGENT_VALUE + this.buildInfoReader.getProjectVersion(), this.fhirContext, this.referenceCleaner);
            this.webserviceClientsByUrl.put(webserviceUrl, (FhirWebserviceClient)client);
            return client;
        }
    }

    @Override
    public FhirWebserviceClient getLocalWebserviceClient() {
        return this.getWebserviceClient(this.localWebserviceBaseUrl);
    }

    @Override
    public FhirWebserviceClient getWebserviceClient(String webserviceUrl) {
        Objects.requireNonNull(webserviceUrl, "webserviceUrl");
        FhirWebserviceClient cachedClient = this.webserviceClientsByUrl.get(webserviceUrl);
        if (cachedClient != null) {
            return cachedClient;
        }
        FhirWebserviceClient newClient = this.getClient(webserviceUrl);
        this.webserviceClientsByUrl.put(webserviceUrl, newClient);
        return newClient;
    }

    @Override
    public WebsocketClient getLocalWebsocketClient(Runnable reconnector, String subscriptionId) {
        if (!this.websocketClientsBySubscriptionId.containsKey(subscriptionId)) {
            WebsocketClientTyrus client = this.createWebsocketClient(reconnector, subscriptionId);
            this.websocketClientsBySubscriptionId.put(subscriptionId, (WebsocketClient)client);
            return client;
        }
        return this.websocketClientsBySubscriptionId.get(subscriptionId);
    }

    protected WebsocketClientTyrus createWebsocketClient(Runnable reconnector, String subscriptionId) {
        return new WebsocketClientTyrus(reconnector, URI.create(this.localWebsocketUrl), this.localWebsocketTrustStore, this.localWebsocketKeyStore, this.localWebsocketKeyStorePassword, this.proxyConfig.isEnabled(this.localWebsocketUrl) ? this.proxyConfig.getUrl() : null, this.proxyConfig.isEnabled(this.localWebsocketUrl) ? this.proxyConfig.getUsername() : null, this.proxyConfig.isEnabled(this.localWebsocketUrl) ? this.proxyConfig.getPassword() : null, USER_AGENT_VALUE + this.buildInfoReader.getProjectVersion(), subscriptionId);
    }

    @Override
    public void disconnectAll() {
        for (WebsocketClient c : this.websocketClientsBySubscriptionId.values()) {
            try {
                c.disconnect();
            }
            catch (Exception e) {
                logger.warn("Error while disconnecting websocket client", (Throwable)e);
            }
        }
    }
}

