/*
 * Decompiled with CFR 0.152.
 */
package dev.dsf.bpe.camunda;

import dev.dsf.bpe.camunda.DelegateProvider;
import dev.dsf.bpe.camunda.MultiVersionClassDelegateActivityBehavior;
import dev.dsf.bpe.camunda.MultiVersionClassDelegateExecutionListener;
import dev.dsf.bpe.camunda.MultiVersionClassDelegateTaskListener;
import dev.dsf.bpe.plugin.ProcessIdAndVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.camunda.bpm.engine.delegate.ExecutionListener;
import org.camunda.bpm.engine.delegate.TaskListener;
import org.camunda.bpm.engine.impl.bpmn.behavior.ClassDelegateActivityBehavior;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParse;
import org.camunda.bpm.engine.impl.bpmn.parser.BpmnParser;
import org.camunda.bpm.engine.impl.pvm.delegate.ActivityBehavior;
import org.camunda.bpm.engine.impl.pvm.process.ActivityImpl;
import org.camunda.bpm.engine.impl.pvm.process.ScopeImpl;
import org.camunda.bpm.engine.impl.task.TaskDefinition;
import org.camunda.bpm.engine.impl.util.xml.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiVersionBpmnParse
extends BpmnParse {
    private static final Logger logger = LoggerFactory.getLogger(MultiVersionBpmnParse.class);
    protected static final String TAGNAME_PROCESS = "process";
    protected static final String TAGNAME_EXTENSIONELEMENTS = "extensionElements";
    protected static final String TAGNAME_PROPERTIES = "properties";
    protected static final String TAGNAME_PROPERTY = "property";
    protected static final String PROPERTYNAME_ID = "id";
    protected static final String PROPERTYNAME_VERSION = "http://camunda.org/schema/1.0/bpmn:versionTag";
    private final DelegateProvider delegateProvider;

    public MultiVersionBpmnParse(BpmnParser parser, DelegateProvider delegateProvider) {
        super(parser);
        this.delegateProvider = delegateProvider;
    }

    public void parseServiceTaskLike(ActivityImpl activity, String elementName, Element serviceTaskElement, Element camundaPropertiesElement, ScopeImpl scope) {
        super.parseServiceTaskLike(activity, elementName, serviceTaskElement, camundaPropertiesElement, scope);
        if (activity.getActivityBehavior() instanceof ClassDelegateActivityBehavior) {
            String className = serviceTaskElement.attributeNS(CAMUNDA_BPMN_EXTENSIONS_NS, "class");
            List fieldDeclarations = this.parseFieldDeclarations(serviceTaskElement);
            logger.debug("Modifying {} for {} in BPMN element with id '{}'", new Object[]{activity.getActivityBehavior().getClass().getSimpleName(), className, this.getElementId(serviceTaskElement)});
            activity.setActivityBehavior((ActivityBehavior)new MultiVersionClassDelegateActivityBehavior(className, fieldDeclarations, this.delegateProvider));
        } else {
            logger.debug("Not modifying {} in BPMN element with id '{}'", (Object)activity.getActivityBehavior().getClass().getCanonicalName(), (Object)this.getElementId(serviceTaskElement));
        }
    }

    protected void parseTaskListeners(Element taskListenerElement, ActivityImpl timerActivity, TaskDefinition taskDefinition) {
        super.parseTaskListeners(taskListenerElement, timerActivity, taskDefinition);
        Class<? extends TaskListener> defaultUserTaskListenerClass = this.delegateProvider.getDefaultUserTaskListenerClass(this.getProcessPluginApiVersion());
        if (((List)taskDefinition.getTaskListeners().getOrDefault("create", new ArrayList())).stream().filter(l -> l instanceof MultiVersionClassDelegateTaskListener).map(l -> (MultiVersionClassDelegateTaskListener)((Object)l)).noneMatch(this.containsDefaultUserTaskListenerOrSuperClassOf(defaultUserTaskListenerClass))) {
            logger.debug("Adding new {} for event '{}' to BPMN element with id '{}'", new Object[]{defaultUserTaskListenerClass.getName(), "create", this.getElementId(taskListenerElement)});
            List fieldDeclarations = this.parseFieldDeclarations(taskListenerElement);
            MultiVersionClassDelegateTaskListener defaultUserTaskListener = new MultiVersionClassDelegateTaskListener(defaultUserTaskListenerClass.getName(), fieldDeclarations, this.delegateProvider);
            taskDefinition.addTaskListener("create", (TaskListener)defaultUserTaskListener);
        } else {
            logger.debug("Custom UserTaskListener extending {} is defined for event '{}' in BPMN element with id '{}'", new Object[]{defaultUserTaskListenerClass.getName(), "create", this.getElementId(taskListenerElement)});
        }
    }

    private String getProcessPluginApiVersion() {
        Element process = this.getRootElement().elements().stream().filter(e -> TAGNAME_PROCESS.equals(e.getTagName())).findFirst().orElseThrow(() -> new RuntimeException("Root element does not contain process element"));
        Element extensionElements = process.elements().stream().filter(e -> TAGNAME_EXTENSIONELEMENTS.equals(e.getTagName())).findFirst().orElseThrow(() -> new RuntimeException("Process element does not contain extensionElements element"));
        Element properties = extensionElements.elements().stream().filter(e -> TAGNAME_PROPERTIES.equals(e.getTagName())).findFirst().orElseThrow(() -> new RuntimeException("ExtensionElements element does not contain properties element"));
        Element property = properties.elements().stream().filter(e -> TAGNAME_PROPERTY.equals(e.getTagName())).filter(e -> e.attributes().contains("name") && "dsf.process.api.version".equals(e.attribute("name")) && e.attributes().contains("value")).findFirst().orElseThrow(() -> new RuntimeException("Properties element does not contain property element with attribute name = dsf.process.api.version and attribute value"));
        return property.attribute("value");
    }

    private Predicate<MultiVersionClassDelegateTaskListener> containsDefaultUserTaskListenerOrSuperClassOf(Class<? extends TaskListener> defaultUserTaskListenerClass) {
        return multiVersionClassDelegateTaskListener -> {
            try {
                Element process = this.getRootElement().elements().stream().filter(e -> TAGNAME_PROCESS.equals(e.getTagName())).findFirst().orElseThrow(() -> new RuntimeException("Root element does not contain process element"));
                ProcessIdAndVersion processKeyAndVersion = new ProcessIdAndVersion(this.getElementId(process), this.getElementVersion(process));
                Class<?> clazz = this.delegateProvider.getClassLoader(processKeyAndVersion).loadClass(multiVersionClassDelegateTaskListener.getClassName());
                return defaultUserTaskListenerClass.isAssignableFrom(clazz);
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not check if '" + defaultUserTaskListenerClass.getName() + "' is assignable from '" + multiVersionClassDelegateTaskListener.getClassName() + "'", exception);
            }
        };
    }

    protected TaskListener parseTaskListener(Element taskListenerElement, String taskElementId) {
        String className = taskListenerElement.attribute("class");
        if (className != null) {
            List fieldDeclarations = this.parseFieldDeclarations(taskListenerElement);
            logger.debug("Modifying {} for {} in BPMN element with id '{}'", new Object[]{MultiVersionClassDelegateTaskListener.class.getName(), className, this.getElementId(taskListenerElement)});
            return new MultiVersionClassDelegateTaskListener(className, fieldDeclarations, this.delegateProvider);
        }
        TaskListener taskListener = super.parseTaskListener(taskListenerElement, taskElementId);
        logger.debug("Not modifying {} in BPMN element with id '{}", (Object)taskListener.getClass().getName(), (Object)this.getElementId(taskListenerElement));
        return taskListener;
    }

    public ExecutionListener parseExecutionListener(Element executionListenerElement, String ancestorElementId) {
        String className = executionListenerElement.attribute("class");
        if (className != null) {
            List fieldDeclarations = this.parseFieldDeclarations(executionListenerElement);
            logger.debug("Modifying {} for {} in BPMN element with id '{}'", new Object[]{MultiVersionClassDelegateTaskListener.class.getName(), className, this.getElementId(executionListenerElement)});
            return new MultiVersionClassDelegateExecutionListener(className, fieldDeclarations, this.delegateProvider);
        }
        ExecutionListener executionListener = super.parseExecutionListener(executionListenerElement, ancestorElementId);
        logger.debug("Not modifying {} in BPMN element with id '{}'", (Object)executionListener.getClass().getName(), (Object)this.getElementId(executionListenerElement));
        return executionListener;
    }

    private String getElementId(Element element) {
        return element.attribute(PROPERTYNAME_ID);
    }

    private String getElementVersion(Element element) {
        return element.attribute(PROPERTYNAME_VERSION);
    }
}

